/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.Camera2Utils;
import com.twilio.video.CaptureRequestUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import com.twilio.video.VideoPixelFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import tvi.webrtc.Camera2Enumerator;
import tvi.webrtc.Camera2Session;
import tvi.webrtc.CameraEnumerationAndroid;
import tvi.webrtc.CameraVideoCapturer;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoCapturer;
import tvi.webrtc.VideoFrame;

@TargetApi(value=21)
public class Camera2Capturer
implements VideoCapturer {
    private static final String CAMERA_SWITCH_PENDING_ERROR_MESSAGE = "Camera switch already in progress.";
    private static final Logger logger = Logger.getLogger(Camera2Capturer.class);
    private final Object stateLock = new Object();
    private State state = State.IDLE;
    private final Map<String, List<VideoFormat>> supportedFormatsMap = new HashMap<String, List<VideoFormat>>();
    private final Context applicationContext;
    private final Camera2Enumerator camera2Enumerator;
    private final AtomicBoolean captureRequestUpdatePending = new AtomicBoolean(false);
    private CaptureRequestUpdater captureRequestUpdater;
    private final Listener listener;
    private final Handler handler;
    private String cameraId;
    private VideoCapturer.Listener videoCapturerListener;
    private tvi.webrtc.Camera2Capturer webrtcCamera2Capturer;
    private Camera2Session camera2Session;
    private SurfaceTextureHelper surfaceTextureHelper;
    private String pendingCameraId;
    private final CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String errorMessage) {
            Camera2Capturer.this.handler.post(() -> Camera2Capturer.this.listener.onError(new Exception(2, errorMessage)));
        }

        public void onCameraDisconnected() {
        }

        public void onCameraFreezed(String errorMessage) {
            logger.e("Camera froze.");
            Camera2Capturer.this.handler.post(() -> Camera2Capturer.this.listener.onError(new Exception(0, errorMessage)));
        }

        public void onCameraOpening(String s) {
        }

        public void onFirstFrameAvailable() {
            Camera2Capturer.this.handler.post(Camera2Capturer.this.listener::onFirstFrameAvailable);
        }

        public void onCameraClosed() {
        }
    };
    private final VideoCapturer.CapturerObserver observerAdapter = new VideoCapturer.CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            Camera2Capturer.this.videoCapturerListener.onCapturerStarted(success);
            Camera2Capturer.this.camera2Session = (Camera2Session)Camera2Capturer.this.webrtcCamera2Capturer.getCameraSession();
            Object object = Camera2Capturer.this.stateLock;
            synchronized (object) {
                Camera2Capturer.this.state = State.RUNNING;
                if (Camera2Capturer.this.captureRequestUpdater != null) {
                    Camera2Capturer.this.updateCaptureRequestOnCameraThread(Camera2Capturer.this.captureRequestUpdater);
                    Camera2Capturer.this.captureRequestUpdater = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStopped() {
            Object object = Camera2Capturer.this.stateLock;
            synchronized (object) {
                Camera2Capturer.this.state = State.IDLE;
            }
        }

        public void onFrameCaptured(tvi.webrtc.VideoFrame videoFrame) {
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            VideoDimensions dimensions = new VideoDimensions(buffer.getWidth(), buffer.getHeight());
            VideoFrame.RotationAngle orientation = VideoFrame.RotationAngle.fromInt(videoFrame.getRotation());
            Camera2Capturer.this.videoCapturerListener.onFrameCaptured(new VideoFrame(videoFrame, dimensions, orientation));
        }
    };
    private final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            Camera2Capturer camera2Capturer = Camera2Capturer.this;
            synchronized (camera2Capturer) {
                Camera2Capturer.this.cameraId = Camera2Capturer.this.pendingCameraId;
                Camera2Capturer.this.pendingCameraId = null;
            }
            Camera2Capturer.this.handler.post(() -> Camera2Capturer.this.listener.onCameraSwitched(Camera2Capturer.this.cameraId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera with ID: " + Camera2Capturer.this.pendingCameraId);
            Camera2Capturer camera2Capturer = Camera2Capturer.this;
            synchronized (camera2Capturer) {
                Camera2Capturer.this.pendingCameraId = null;
            }
            Camera2Capturer.this.handler.post(() -> Camera2Capturer.this.listener.onError(new Exception(1, errorMessage)));
        }
    };

    public static boolean isSupported(@NonNull Context context) {
        Preconditions.checkNotNull(context, "Context must not be null");
        return Camera2Enumerator.isSupported((Context)context);
    }

    public Camera2Capturer(@NonNull Context context, @NonNull String cameraId, @NonNull Listener listener) {
        this(context, cameraId, listener, Util.createCallbackHandler());
    }

    @VisibleForTesting
    Camera2Capturer(@NonNull Context context, @NonNull String cameraId, @NonNull Listener listener, @NonNull Handler handler) {
        Preconditions.checkState(Build.VERSION.SDK_INT >= 21, "Camera2Capturer unavailable for " + Build.VERSION.SDK_INT);
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(Camera2Capturer.isSupported(context), "Camera2Capturer is not supported on this device");
        Preconditions.checkNotNull(cameraId, "Camera ID must not be null");
        Preconditions.checkNotNull(listener, "Listener must not be null");
        Preconditions.checkArgument(!cameraId.isEmpty(), "Camera ID must not be empty");
        this.applicationContext = context.getApplicationContext();
        this.camera2Enumerator = new Camera2Enumerator(this.applicationContext);
        this.cameraId = cameraId;
        this.listener = listener;
        this.handler = handler;
    }

    @Override
    @NonNull
    public synchronized List<VideoFormat> getSupportedFormats() {
        this.checkCapturerState();
        List<VideoFormat> supportedFormats = this.supportedFormatsMap.get(this.cameraId);
        if (supportedFormats == null) {
            supportedFormats = this.convertToVideoFormats(this.camera2Enumerator.getSupportedFormats(this.cameraId));
            this.supportedFormatsMap.put(this.cameraId, supportedFormats);
        }
        return supportedFormats;
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(@NonNull VideoFormat captureFormat, @NonNull VideoCapturer.Listener videoCapturerListener) {
        this.checkCapturerState();
        Object object = this.stateLock;
        synchronized (object) {
            this.state = State.STARTING;
        }
        this.webrtcCamera2Capturer = (tvi.webrtc.Camera2Capturer)this.camera2Enumerator.createCapturer(this.cameraId, this.cameraEventsHandler);
        this.videoCapturerListener = videoCapturerListener;
        this.webrtcCamera2Capturer.initialize(this.surfaceTextureHelper, this.applicationContext, this.observerAdapter);
        this.webrtcCamera2Capturer.startCapture(captureFormat.dimensions.width, captureFormat.dimensions.height, captureFormat.framerate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        if (this.webrtcCamera2Capturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STOPPING;
            }
            this.webrtcCamera2Capturer.stopCapture();
            this.webrtcCamera2Capturer.dispose();
            this.webrtcCamera2Capturer = null;
        }
    }

    @NonNull
    public synchronized String getCameraId() {
        return this.cameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchCamera(@NonNull String newCameraId) {
        Preconditions.checkNotNull(newCameraId, "Camera ID must not be null");
        Preconditions.checkArgument(!newCameraId.isEmpty(), "Camera ID must not be empty");
        Preconditions.checkArgument(!newCameraId.equals(this.cameraId), "Camera ID must be different from current camera ID");
        Preconditions.checkArgument(Camera2Utils.cameraIdSupported(this.applicationContext, newCameraId), "Camera ID %s is not supported or could not be validated", (Object)newCameraId);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                if (this.pendingCameraId == null) {
                    this.pendingCameraId = newCameraId;
                    this.webrtcCamera2Capturer.switchCamera(newCameraId, this.cameraSwitchHandler);
                } else {
                    this.handler.post(() -> this.listener.onError(new Exception(1, CAMERA_SWITCH_PENDING_ERROR_MESSAGE)));
                }
            } else {
                this.cameraId = newCameraId;
                this.listener.onCameraSwitched(this.cameraId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCaptureRequest(@NonNull CaptureRequestUpdater captureRequestUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.captureRequestUpdatePending.get()) {
                    this.captureRequestUpdatePending.set(true);
                    return this.camera2Session.cameraThreadHandler.post(() -> this.updateCaptureRequestOnCameraThread(captureRequestUpdater));
                }
                logger.w("Parameters will not be applied with parameter update pending");
                return false;
            }
            logger.i("Camera2Capturer is not running. The CaptureRequest update will be applied when it is resumed");
            this.captureRequestUpdater = captureRequestUpdater;
            return true;
        }
    }

    void setSurfaceTextureHelper(@NonNull SurfaceTextureHelper surfaceTextureHelper) {
        this.surfaceTextureHelper = surfaceTextureHelper;
    }

    private void checkCapturerState() {
        Preconditions.checkState(Util.permissionGranted(this.applicationContext, "android.permission.CAMERA"), "CAMERA permission must be granted to create videotrack with Camera2Capturer");
        Preconditions.checkState(Camera2Utils.cameraIdSupported(this.applicationContext, this.cameraId), "Camera ID %s is not supported or could not be validated", (Object)this.cameraId);
    }

    private void reportError(Exception camera2Exception) {
        logger.e(camera2Exception.getMessage(), camera2Exception);
        this.handler.post(() -> this.listener.onError(camera2Exception));
    }

    @NonNull
    private List<VideoFormat> convertToVideoFormats(@NonNull List<CameraEnumerationAndroid.CaptureFormat> captureFormats) {
        ArrayList<VideoFormat> videoFormats = new ArrayList<VideoFormat>(captureFormats.size());
        for (CameraEnumerationAndroid.CaptureFormat captureFormat : captureFormats) {
            VideoDimensions dimensions = new VideoDimensions(captureFormat.width, captureFormat.height);
            int framerate = (captureFormat.framerate.max + 999) / 1000;
            videoFormats.add(new VideoFormat(dimensions, framerate, VideoPixelFormat.NV21));
        }
        return videoFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaptureRequestOnCameraThread(@NonNull CaptureRequestUpdater captureRequestUpdater) {
        Preconditions.checkNotNull(captureRequestUpdater, "captureRequestUpdate must not be null");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                logger.i("Applying custom capture request");
                this.camera2Session.checkIsOnCameraThread();
                CaptureRequest.Builder captureRequestBuilder = this.camera2Session.configureCaptureRequestBuilder();
                if (captureRequestBuilder == null) {
                    this.reportError(new Exception(3, "Failed to create capture request builder"));
                    this.captureRequestUpdatePending.set(false);
                    return;
                }
                captureRequestUpdater.apply(captureRequestBuilder);
                boolean succeeded = this.camera2Session.setSessionRepeatingRequest(captureRequestBuilder);
                if (!succeeded) {
                    this.reportError(new Exception(3, "Failed to set session repeating request"));
                    this.captureRequestUpdatePending.set(false);
                    return;
                }
            } else {
                logger.w("Attempted to update camera parameters while camera capturer is not running");
            }
            this.captureRequestUpdatePending.set(false);
        }
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched(@NonNull String var1);

        public void onError(@NonNull Exception var1);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static class Exception
    extends TwilioException {
        public static final int CAMERA_FROZE = 0;
        public static final int CAMERA_SWITCH_FAILED = 1;
        public static final int UNKNOWN = 2;
        public static final int CAPTURE_REQUEST_UPDATE_FAILED = 3;

        Exception(int code, @NonNull String message, @Nullable String explanation) {
            super(code, message, explanation);
        }

        Exception(int code, @NonNull String message) {
            this(code, message, null);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Code {
        }
    }
}

