/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.AudioDevice;
import com.twilio.video.AudioDeviceProxy;
import com.twilio.video.AudioFormat;
import com.twilio.video.AudioOptions;
import com.twilio.video.DefaultAudioDevice;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaOptions;
import com.twilio.video.Preconditions;
import com.twilio.video.Video;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import java.util.HashSet;
import java.util.Set;
import tvi.webrtc.EglBase;
import tvi.webrtc.audio.AudioDeviceModule;
import tvi.webrtc.audio.JavaAudioDeviceModule;

class MediaFactory {
    private static final String RELEASE_MESSAGE_TEMPLATE = "MediaFactory released %s unavailable";
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(MediaFactory.class);
    private static volatile MediaFactory instance;
    private static volatile Set<Object> mediaFactoryOwners;
    private long nativeMediaFactoryHandle;
    private EglBaseProvider eglBaseProvider;
    private AudioDeviceModule audioDeviceModule;
    private AudioDeviceProxy audioDeviceProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MediaFactory instance(@NonNull Object owner, @NonNull Context context) {
        Preconditions.checkNotNull(owner, "Owner must not be null");
        Preconditions.checkNotNull(context, "Context must not be null");
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance == null) {
                if (!libraryIsLoaded) {
                    ReLinker.loadLibrary((Context)context, (String)"twilio_video_android_so");
                    libraryIsLoaded = true;
                }
                Object temporaryEglOwner = new Object();
                EglBaseProvider eglBaseProvider = EglBaseProvider.instance(temporaryEglOwner);
                EglBase localEglBase = eglBaseProvider.getLocalEglBase();
                EglBase remoteEglBase = eglBaseProvider.getRemoteEglBase();
                AudioDevice audioDevice = Video.getAudioDevice();
                if (audioDevice instanceof DefaultAudioDevice) {
                    AudioDeviceModule audioDeviceModule = JavaAudioDeviceModule.builder((Context)context).createAudioDeviceModule();
                    long nativeAudioDeviceModule = audioDeviceModule.getNativeAudioDeviceModulePointer();
                    long nativeMediaFactoryHandle = MediaFactory.nativeCreate(context, localEglBase.getEglBaseContext(), remoteEglBase.getEglBaseContext(), nativeAudioDeviceModule);
                    if (nativeMediaFactoryHandle == 0L) {
                        logger.e("Failed to instance MediaFactory");
                    } else {
                        instance = new MediaFactory(audioDeviceModule, nativeMediaFactoryHandle);
                    }
                } else {
                    long nativeMediaFactoryHandle;
                    AudioFormat capturerAudioFormat = audioDevice.getCapturerFormat();
                    AudioFormat renderAudioFormat = audioDevice.getRendererFormat();
                    instance = new MediaFactory();
                    MediaFactory.instance.nativeMediaFactoryHandle = nativeMediaFactoryHandle = MediaFactory.nativeCreateWithCustomDevice(instance, context, audioDevice, capturerAudioFormat, renderAudioFormat, localEglBase.getEglBaseContext(), remoteEglBase.getEglBaseContext());
                }
                eglBaseProvider.release(temporaryEglOwner);
            }
            mediaFactoryOwners.add(owner);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return instance;
        }
    }

    @Nullable
    synchronized LocalAudioTrack createAudioTrack(Context context, boolean enabled, @Nullable AudioOptions audioOptions, String name) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createAudioTrack");
        return this.nativeCreateAudioTrack(this.nativeMediaFactoryHandle, context, enabled, audioOptions, name);
    }

    @Nullable
    synchronized LocalVideoTrack createVideoTrack(Context context, boolean enabled, VideoCapturer videoCapturer, VideoConstraints videoConstraints, String name) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createVideoTrack");
        return this.nativeCreateVideoTrack(this.nativeMediaFactoryHandle, context, enabled, videoCapturer, videoConstraints, name, this.eglBaseProvider.getLocalEglBase().getEglBaseContext());
    }

    synchronized LocalDataTrack createDataTrack(Context context, boolean ordered, int maxPacketLifeTime, int maxRetransmits, String name) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createDataTrack");
        return this.nativeCreateDataTrack(this.nativeMediaFactoryHandle, context, ordered, maxPacketLifeTime, maxRetransmits, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release(Object owner) {
        if (instance == null) return;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            mediaFactoryOwners.remove(owner);
            if (instance == null || !mediaFactoryOwners.isEmpty()) return;
            this.eglBaseProvider.release(this);
            this.eglBaseProvider = null;
            if (this.audioDeviceModule != null) {
                this.audioDeviceModule.release();
            }
            if (this.audioDeviceProxy != null) {
                this.audioDeviceProxy.release();
            }
            this.audioDeviceProxy = null;
            this.nativeRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
            instance = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long getNativeMediaFactoryHandle() {
        return this.nativeMediaFactoryHandle;
    }

    void setAudioDeviceProxy(AudioDeviceProxy audioDeviceProxy) {
        this.audioDeviceProxy = audioDeviceProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static MediaFactory testCreate(@NonNull Context context, @NonNull MediaOptions mediaOptions) {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (!libraryIsLoaded) {
                ReLinker.loadLibrary((Context)context, (String)"twilio_video_android_so");
                libraryIsLoaded = true;
            }
            long nativeMediaFactoryHandle = MediaFactory.nativeTestCreate(context, mediaOptions);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new MediaFactory(nativeMediaFactoryHandle);
        }
    }

    @VisibleForTesting(otherwise=5)
    void testRelease() {
        if (this.nativeMediaFactoryHandle != 0L) {
            this.eglBaseProvider.release(this);
            this.eglBaseProvider = null;
            this.nativeTestRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static boolean isReleased() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static void manualRelease() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance != null) {
                mediaFactoryOwners.clear();
                Object o = new Object();
                instance.release(o);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private MediaFactory() {
        this.eglBaseProvider = EglBaseProvider.instance(this);
    }

    private MediaFactory(AudioDeviceModule audioDeviceModule, long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
        this.eglBaseProvider = EglBaseProvider.instance(this);
        this.audioDeviceModule = audioDeviceModule;
    }

    private MediaFactory(long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
        this.eglBaseProvider = EglBaseProvider.instance(this);
    }

    private static native long nativeCreate(Context var0, EglBase.Context var1, EglBase.Context var2, long var3);

    private static native long nativeCreateWithCustomDevice(MediaFactory var0, Context var1, AudioDevice var2, AudioFormat var3, AudioFormat var4, EglBase.Context var5, EglBase.Context var6);

    private native LocalAudioTrack nativeCreateAudioTrack(long var1, Context var3, boolean var4, AudioOptions var5, String var6);

    private native LocalVideoTrack nativeCreateVideoTrack(long var1, Context var3, boolean var4, VideoCapturer var5, VideoConstraints var6, String var7, EglBase.Context var8);

    private native LocalDataTrack nativeCreateDataTrack(long var1, Context var3, boolean var4, int var5, int var6, String var7);

    private native void nativeRelease(long var1);

    @VisibleForTesting(otherwise=5)
    private static native long nativeTestCreate(Context var0, MediaOptions var1);

    @VisibleForTesting(otherwise=5)
    private native void nativeTestRelease(long var1);

    static {
        mediaFactoryOwners = new HashSet<Object>();
    }
}

