/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.AudioCodec;
import com.twilio.video.EncodingParameters;
import com.twilio.video.G722Codec;
import com.twilio.video.H264Codec;
import com.twilio.video.IceOptions;
import com.twilio.video.IsacCodec;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.MediaFactory;
import com.twilio.video.OpusCodec;
import com.twilio.video.PcmaCodec;
import com.twilio.video.PcmuCodec;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCodec;
import com.twilio.video.Vp8Codec;
import com.twilio.video.Vp9Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectOptions {
    private static final Set<Class> SUPPORTED_CODECS = new HashSet<Class>(Arrays.asList(IsacCodec.class, OpusCodec.class, PcmuCodec.class, PcmaCodec.class, G722Codec.class, Vp8Codec.class, H264Codec.class, Vp9Codec.class));
    private final String accessToken;
    private final String roomName;
    private final String region;
    private final List<LocalAudioTrack> audioTracks;
    private final List<LocalVideoTrack> videoTracks;
    private final List<LocalDataTrack> dataTracks;
    private final IceOptions iceOptions;
    private final boolean enableInsights;
    private final boolean enableAutomaticSubscription;
    private final boolean enableDominantSpeaker;
    private final boolean enableNetworkQuality;
    private final List<AudioCodec> preferredAudioCodecs;
    private final List<VideoCodec> preferredVideoCodecs;
    private final EncodingParameters encodingParameters;
    private final MediaFactory mediaFactory;

    static void checkAudioCodecs(@Nullable List<AudioCodec> audioCodecs) {
        if (audioCodecs != null) {
            for (AudioCodec audioCodec : audioCodecs) {
                Preconditions.checkNotNull(audioCodec);
                Preconditions.checkArgument(SUPPORTED_CODECS.contains(audioCodec.getClass()), String.format("Unsupported audio codec %s", audioCodec.getName()));
            }
        }
    }

    static void checkVideoCodecs(@Nullable List<VideoCodec> videoCodecs) {
        if (videoCodecs != null) {
            for (VideoCodec videoCodec : videoCodecs) {
                Preconditions.checkNotNull(videoCodec);
                Preconditions.checkArgument(SUPPORTED_CODECS.contains(videoCodec.getClass()), String.format("Unsupported video codec %s", videoCodec.getName()));
            }
        }
    }

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    static void checkVideoTracksReleased(@Nullable List<LocalVideoTrack> videoTracks) {
        if (videoTracks != null) {
            for (LocalVideoTrack localVideoTrack : videoTracks) {
                Preconditions.checkState(!localVideoTrack.isReleased(), "LocalVideoTrack cannot be released");
            }
        }
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.roomName = builder.roomName;
        this.audioTracks = builder.audioTracks;
        this.videoTracks = builder.videoTracks;
        this.dataTracks = builder.dataTracks;
        this.iceOptions = builder.iceOptions;
        this.enableInsights = builder.enableInsights;
        this.enableAutomaticSubscription = builder.enableAutomaticSubscription;
        this.enableDominantSpeaker = builder.enableDominantSpeaker;
        this.enableNetworkQuality = builder.enableNetworkQuality;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.preferredVideoCodecs = builder.preferredVideoCodecs;
        this.region = builder.region;
        this.encodingParameters = builder.encodingParameters;
        this.mediaFactory = builder.mediaFactory;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRoomName() {
        return this.roomName;
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    List<LocalVideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    List<LocalDataTrack> getDataTracks() {
        return this.dataTracks;
    }

    String getRegion() {
        return this.region;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    boolean isInsightsEnabled() {
        return this.enableInsights;
    }

    boolean isNetworkQualityEnabled() {
        return this.enableNetworkQuality;
    }

    private LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks != null && this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    private LocalVideoTrack[] getLocalVideoTracksArray() {
        LocalVideoTrack[] videoTracksArray = new LocalVideoTrack[]{};
        if (this.videoTracks != null && this.videoTracks.size() > 0) {
            videoTracksArray = new LocalVideoTrack[this.videoTracks.size()];
            videoTracksArray = this.videoTracks.toArray(videoTracksArray);
        }
        return videoTracksArray;
    }

    private LocalDataTrack[] getLocalDataTracksArray() {
        LocalDataTrack[] dataTracksArray = new LocalDataTrack[]{};
        if (this.dataTracks != null && this.dataTracks.size() > 0) {
            dataTracksArray = new LocalDataTrack[this.dataTracks.size()];
            dataTracksArray = this.dataTracks.toArray(dataTracksArray);
        }
        return dataTracksArray;
    }

    private AudioCodec[] getAudioCodecsArray() {
        AudioCodec[] audioCodecsArray = new AudioCodec[]{};
        if (this.preferredAudioCodecs != null && !this.preferredAudioCodecs.isEmpty()) {
            audioCodecsArray = new AudioCodec[this.preferredAudioCodecs.size()];
            audioCodecsArray = this.preferredAudioCodecs.toArray(audioCodecsArray);
        }
        return audioCodecsArray;
    }

    private VideoCodec[] getVideoCodecsArray() {
        VideoCodec[] videoCodecsArray = new VideoCodec[]{};
        if (this.preferredVideoCodecs != null && !this.preferredVideoCodecs.isEmpty()) {
            videoCodecsArray = new VideoCodec[this.preferredVideoCodecs.size()];
            videoCodecsArray = this.preferredVideoCodecs.toArray(videoCodecsArray);
        }
        return videoCodecsArray;
    }

    EncodingParameters getEncodingParameters() {
        return this.encodingParameters;
    }

    @VisibleForTesting(otherwise=5)
    @Nullable
    MediaFactory getMediaFactory() {
        return this.mediaFactory;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        ConnectOptions.checkVideoTracksReleased(this.videoTracks);
        return this.nativeCreate(this.accessToken, this.roomName, this.getLocalAudioTracksArray(), this.getLocalVideoTracksArray(), this.getLocalDataTracksArray(), this.iceOptions, this.enableInsights, this.enableAutomaticSubscription, this.enableNetworkQuality, this.enableDominantSpeaker, PlatformInfo.getNativeHandle(), this.getAudioCodecsArray(), this.getVideoCodecsArray(), this.region, this.encodingParameters);
    }

    private native long nativeCreate(String var1, String var2, LocalAudioTrack[] var3, LocalVideoTrack[] var4, LocalDataTrack[] var5, IceOptions var6, boolean var7, boolean var8, boolean var9, boolean var10, long var11, AudioCodec[] var13, VideoCodec[] var14, String var15, EncodingParameters var16);

    public static class Builder {
        private String accessToken = "";
        private String roomName = "";
        private IceOptions iceOptions;
        private List<LocalAudioTrack> audioTracks;
        private List<LocalVideoTrack> videoTracks;
        private List<LocalDataTrack> dataTracks;
        private boolean enableInsights = true;
        private boolean enableAutomaticSubscription = true;
        private boolean enableDominantSpeaker = false;
        private boolean enableNetworkQuality = false;
        private List<AudioCodec> preferredAudioCodecs;
        private List<VideoCodec> preferredVideoCodecs;
        private String region = "gll";
        private EncodingParameters encodingParameters;
        private MediaFactory mediaFactory;

        public Builder(@NonNull String accessToken) {
            Preconditions.checkNotNull(accessToken);
            this.accessToken = accessToken;
        }

        @NonNull
        public Builder roomName(@NonNull String roomName) {
            Preconditions.checkNotNull(roomName);
            this.roomName = roomName;
            return this;
        }

        @NonNull
        public Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "LocalAudioTrack List must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        @NonNull
        public Builder videoTracks(@NonNull List<LocalVideoTrack> videoTracks) {
            Preconditions.checkNotNull(videoTracks, "LocalVideoTrack List must not be null");
            this.videoTracks = new ArrayList<LocalVideoTrack>(videoTracks);
            return this;
        }

        @NonNull
        public Builder dataTracks(@NonNull List<LocalDataTrack> dataTracks) {
            Preconditions.checkNotNull(dataTracks);
            this.dataTracks = dataTracks;
            return this;
        }

        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions);
            this.iceOptions = iceOptions;
            return this;
        }

        @NonNull
        public Builder enableInsights(boolean enable) {
            this.enableInsights = enable;
            return this;
        }

        @NonNull
        public Builder enableAutomaticSubscription(boolean enableAutomaticSubscription) {
            this.enableAutomaticSubscription = enableAutomaticSubscription;
            return this;
        }

        @NonNull
        public Builder enableDominantSpeaker(boolean enableDominantSpeaker) {
            this.enableDominantSpeaker = enableDominantSpeaker;
            return this;
        }

        @NonNull
        public Builder enableNetworkQuality(boolean enableNetworkQuality) {
            this.enableNetworkQuality = enableNetworkQuality;
            return this;
        }

        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs);
            this.preferredAudioCodecs = new ArrayList<AudioCodec>(preferredAudioCodecs);
            return this;
        }

        @NonNull
        public Builder preferVideoCodecs(@NonNull List<VideoCodec> preferredVideoCodecs) {
            Preconditions.checkNotNull(preferredVideoCodecs);
            this.preferredVideoCodecs = new ArrayList<VideoCodec>(preferredVideoCodecs);
            return this;
        }

        @NonNull
        public Builder region(@NonNull String region) {
            this.region = region;
            return this;
        }

        @NonNull
        public Builder encodingParameters(@NonNull EncodingParameters encodingParameters) {
            Preconditions.checkNotNull(encodingParameters);
            this.encodingParameters = encodingParameters;
            return this;
        }

        @VisibleForTesting(otherwise=5)
        Builder mediaFactory(@Nullable MediaFactory mediaFactory) {
            this.mediaFactory = mediaFactory;
            return this;
        }

        @NonNull
        public ConnectOptions build() {
            Preconditions.checkNotNull(this.accessToken, "Token must not be null.");
            Preconditions.checkArgument(!this.accessToken.equals(""), "Token must not be empty.");
            ConnectOptions.checkAudioTracksReleased(this.audioTracks);
            ConnectOptions.checkVideoTracksReleased(this.videoTracks);
            ConnectOptions.checkAudioCodecs(this.preferredAudioCodecs);
            ConnectOptions.checkVideoCodecs(this.preferredVideoCodecs);
            return new ConnectOptions(this);
        }
    }
}

