/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.DataTrack;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.Preconditions;

public class LocalDataTrackPublication
implements DataTrackPublication {
    private final String sid;
    private final LocalDataTrack localDataTrack;

    LocalDataTrackPublication(@NonNull String sid, @NonNull LocalDataTrack localDataTrack) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(localDataTrack, "Local data track must not be null");
        this.sid = sid;
        this.localDataTrack = localDataTrack;
    }

    @Override
    @NonNull
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getTrackName() {
        return this.localDataTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localDataTrack.isEnabled();
    }

    @Override
    public DataTrack getDataTrack() {
        return this.localDataTrack;
    }

    @NonNull
    public LocalDataTrack getLocalDataTrack() {
        return this.localDataTrack;
    }
}

