/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.Logger;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteAudioTrack;
import com.twilio.video.RemoteAudioTrackPublication;
import com.twilio.video.RemoteDataTrack;
import com.twilio.video.RemoteDataTrackPublication;
import com.twilio.video.RemoteVideoTrack;
import com.twilio.video.RemoteVideoTrackPublication;
import com.twilio.video.ThreadChecker;
import com.twilio.video.TrackPublication;
import com.twilio.video.TwilioException;
import com.twilio.video.VideoTrackPublication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteParticipant
implements Participant {
    private static final Logger logger = Logger.getLogger(RemoteParticipant.class);
    private final String identity;
    private final String sid;
    private final List<RemoteAudioTrackPublication> remoteAudioTrackPublications;
    private final List<AudioTrackPublication> audioTrackPublications;
    private final List<RemoteVideoTrackPublication> remoteVideoTrackPublications;
    private final List<VideoTrackPublication> videoTrackPublications;
    private final List<RemoteDataTrackPublication> remoteDataTrackPublications;
    private final List<DataTrackPublication> dataTrackPublications;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    private final Listener participantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackPublished(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackPublished");
                RemoteParticipant.this.audioTrackPublications.add(remoteAudioTrackPublication);
                RemoteParticipant.this.remoteAudioTrackPublications.add(remoteAudioTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackPublished(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        public void onAudioTrackUnpublished(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackUnpublished");
                RemoteParticipant.this.audioTrackPublications.remove(remoteAudioTrackPublication);
                RemoteParticipant.this.remoteAudioTrackPublications.remove(remoteAudioTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackUnpublished(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        public void onAudioTrackSubscribed(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication, RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackSubscribed");
                remoteAudioTrackPublication.setSubscribed(true);
                remoteAudioTrackPublication.setRemoteAudioTrack(remoteAudioTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackSubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                }
            });
        }

        @Override
        public void onAudioTrackSubscriptionFailed(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication, TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackSubscriptionFailed");
                remoteAudioTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackSubscriptionFailed(remoteParticipant, remoteAudioTrackPublication, twilioException);
                }
            });
        }

        @Override
        public void onAudioTrackUnsubscribed(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication, RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnsubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackUnsubscribed");
                remoteAudioTrackPublication.setRemoteAudioTrack(null);
                remoteAudioTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackUnsubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                }
            });
        }

        @Override
        public void onVideoTrackPublished(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackPublished");
                RemoteParticipant.this.videoTrackPublications.add(remoteVideoTrackPublication);
                RemoteParticipant.this.remoteVideoTrackPublications.add(remoteVideoTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackPublished(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        public void onVideoTrackUnpublished(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackUnpublished");
                RemoteParticipant.this.videoTrackPublications.remove(remoteVideoTrackPublication);
                RemoteParticipant.this.remoteVideoTrackPublications.remove(remoteVideoTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackUnpublished(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        public void onVideoTrackSubscribed(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication, RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSubscribed");
                remoteVideoTrackPublication.setSubscribed(true);
                remoteVideoTrackPublication.setRemoteVideoTrack(remoteVideoTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                }
            });
        }

        @Override
        public void onVideoTrackSubscriptionFailed(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication, TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSubscriptionFailed");
                remoteVideoTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSubscriptionFailed(remoteParticipant, remoteVideoTrackPublication, twilioException);
                }
            });
        }

        @Override
        public void onVideoTrackUnsubscribed(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication, RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnsubscribed");
            remoteVideoTrack.release();
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackUnsubscribed");
                remoteVideoTrackPublication.setRemoteVideoTrack(null);
                remoteVideoTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackUnsubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                }
            });
        }

        @Override
        public void onDataTrackPublished(RemoteParticipant remoteParticipant, RemoteDataTrackPublication remoteDataTrackPublication) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackPublished");
                RemoteParticipant.this.dataTrackPublications.add(remoteDataTrackPublication);
                RemoteParticipant.this.remoteDataTrackPublications.add(remoteDataTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackPublished(remoteParticipant, remoteDataTrackPublication);
                }
            });
        }

        @Override
        public void onDataTrackUnpublished(RemoteParticipant remoteParticipant, RemoteDataTrackPublication remoteDataTrackPublication) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackUnpublished");
                RemoteParticipant.this.dataTrackPublications.remove(remoteDataTrackPublication);
                RemoteParticipant.this.remoteDataTrackPublications.remove(remoteDataTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackUnpublished(remoteParticipant, remoteDataTrackPublication);
                }
            });
        }

        @Override
        public void onDataTrackSubscribed(RemoteParticipant remoteParticipant, RemoteDataTrackPublication remoteDataTrackPublication, RemoteDataTrack remoteDataTrack) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackSubscribed");
                remoteDataTrackPublication.setSubscribed(true);
                remoteDataTrackPublication.setRemoteDataTrack(remoteDataTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackSubscribed(remoteParticipant, remoteDataTrackPublication, remoteDataTrack);
                }
            });
        }

        @Override
        public void onDataTrackSubscriptionFailed(RemoteParticipant remoteParticipant, RemoteDataTrackPublication remoteDataTrackPublication, TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackSubscriptionFailed");
                remoteDataTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackSubscriptionFailed(remoteParticipant, remoteDataTrackPublication, twilioException);
                }
            });
        }

        @Override
        public void onDataTrackUnsubscribed(RemoteParticipant remoteParticipant, RemoteDataTrackPublication remoteDataTrackPublication, RemoteDataTrack remoteDataTrack) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackUnsubscribed");
            remoteDataTrack.release();
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackUnsubscribed");
                remoteDataTrackPublication.setRemoteDataTrack(null);
                remoteDataTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackUnsubscribed(remoteParticipant, remoteDataTrackPublication, remoteDataTrack);
                }
            });
        }

        @Override
        public void onAudioTrackEnabled(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackEnabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackEnabled");
                remoteAudioTrackPublication.setEnabled(true);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackEnabled(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        public void onAudioTrackDisabled(RemoteParticipant remoteParticipant, RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackDisabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackDisabled");
                remoteAudioTrackPublication.setEnabled(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackDisabled(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        public void onVideoTrackEnabled(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackEnabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackEnabled");
                remoteVideoTrackPublication.setEnabled(true);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackEnabled(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        public void onVideoTrackDisabled(RemoteParticipant remoteParticipant, RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackDisabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackDisabled");
                remoteVideoTrackPublication.setEnabled(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackDisabled(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        private void checkCallback(RemoteParticipant remoteParticipant, TrackPublication trackPublication, String callback) {
            Preconditions.checkState(remoteParticipant != null, "Received null remote participant in %s", (Object)callback);
            Preconditions.checkState(trackPublication != null, "Received null track publication in %s", (Object)callback);
        }
    };
    private long nativeParticipantContext;

    RemoteParticipant(String identity, String sid, List<RemoteAudioTrackPublication> remoteAudioTrackPublications, List<RemoteVideoTrackPublication> remoteVideoTrackPublications, List<RemoteDataTrackPublication> remoteDataTrackPublications, Handler handler, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.remoteAudioTrackPublications = remoteAudioTrackPublications;
        this.audioTrackPublications = new ArrayList<AudioTrackPublication>(remoteAudioTrackPublications.size());
        this.addAudioTracks(remoteAudioTrackPublications);
        this.remoteVideoTrackPublications = remoteVideoTrackPublications;
        this.videoTrackPublications = new ArrayList<VideoTrackPublication>(remoteVideoTrackPublications.size());
        this.addVideoTracks(remoteVideoTrackPublications);
        this.remoteDataTrackPublications = remoteDataTrackPublications;
        this.dataTrackPublications = new ArrayList<DataTrackPublication>(remoteDataTrackPublications.size());
        this.addDataTracks(remoteDataTrackPublications);
        this.handler = handler;
        this.nativeParticipantContext = nativeParticipantContext;
    }

    @Override
    public String getSid() {
        return this.sid;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public List<AudioTrackPublication> getAudioTracks() {
        return Collections.unmodifiableList(this.audioTrackPublications);
    }

    @Override
    public List<VideoTrackPublication> getVideoTracks() {
        return Collections.unmodifiableList(this.videoTrackPublications);
    }

    @Override
    public List<DataTrackPublication> getDataTracks() {
        return Collections.unmodifiableList(this.dataTrackPublications);
    }

    public List<RemoteAudioTrackPublication> getRemoteAudioTracks() {
        return Collections.unmodifiableList(this.remoteAudioTrackPublications);
    }

    public List<RemoteVideoTrackPublication> getRemoteVideoTracks() {
        return Collections.unmodifiableList(this.remoteVideoTrackPublications);
    }

    public List<RemoteDataTrackPublication> getRemoteDataTracks() {
        return Collections.unmodifiableList(this.remoteDataTrackPublications);
    }

    public void setListener(Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized boolean isConnected() {
        return !this.isReleased() && this.nativeIsConnected(this.nativeParticipantContext);
    }

    synchronized void release() {
        if (!this.isReleased()) {
            for (RemoteVideoTrackPublication remoteVideoTrackPublication : this.remoteVideoTrackPublications) {
                RemoteVideoTrack remoteVideoTrack = remoteVideoTrackPublication.getRemoteVideoTrack();
                if (remoteVideoTrack == null) continue;
                remoteVideoTrack.release();
            }
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private void addAudioTracks(List<RemoteAudioTrackPublication> remoteAudioTracks) {
        this.audioTrackPublications.addAll(remoteAudioTracks);
    }

    private void addVideoTracks(List<RemoteVideoTrackPublication> remoteVideoTracks) {
        this.videoTrackPublications.addAll(remoteVideoTracks);
    }

    private void addDataTracks(List<RemoteDataTrackPublication> remoteDataTracks) {
        this.dataTrackPublications.addAll(remoteDataTracks);
    }

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackPublished(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackUnpublished(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackSubscribed(RemoteParticipant var1, RemoteAudioTrackPublication var2, RemoteAudioTrack var3);

        public void onAudioTrackSubscriptionFailed(RemoteParticipant var1, RemoteAudioTrackPublication var2, TwilioException var3);

        public void onAudioTrackUnsubscribed(RemoteParticipant var1, RemoteAudioTrackPublication var2, RemoteAudioTrack var3);

        public void onVideoTrackPublished(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackUnpublished(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackSubscribed(RemoteParticipant var1, RemoteVideoTrackPublication var2, RemoteVideoTrack var3);

        public void onVideoTrackSubscriptionFailed(RemoteParticipant var1, RemoteVideoTrackPublication var2, TwilioException var3);

        public void onVideoTrackUnsubscribed(RemoteParticipant var1, RemoteVideoTrackPublication var2, RemoteVideoTrack var3);

        public void onDataTrackPublished(RemoteParticipant var1, RemoteDataTrackPublication var2);

        public void onDataTrackUnpublished(RemoteParticipant var1, RemoteDataTrackPublication var2);

        public void onDataTrackSubscribed(RemoteParticipant var1, RemoteDataTrackPublication var2, RemoteDataTrack var3);

        public void onDataTrackSubscriptionFailed(RemoteParticipant var1, RemoteDataTrackPublication var2, TwilioException var3);

        public void onDataTrackUnsubscribed(RemoteParticipant var1, RemoteDataTrackPublication var2, RemoteDataTrack var3);

        public void onAudioTrackEnabled(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackDisabled(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onVideoTrackEnabled(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackDisabled(RemoteParticipant var1, RemoteVideoTrackPublication var2);
    }
}

