/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.AudioOptions;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaOptions;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import org.webrtc.EglBase;

class MediaFactory {
    private static final String RELEASE_MESSAGE_TEMPLATE = "MediaFactory released %s unavailable";
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(MediaFactory.class);
    private static volatile MediaFactory instance;
    private static volatile int mediaFactoryRefCount;
    private long nativeMediaFactoryHandle;
    private EglBaseProvider eglBaseProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MediaFactory instance(@NonNull Context context) {
        Preconditions.checkNotNull(context, "Context must not be null");
        if (instance != null) return instance;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance != null) return instance;
            if (!libraryIsLoaded) {
                ReLinker.loadLibrary((Context)context, (String)"jingle_peerconnection_so");
                libraryIsLoaded = true;
            }
            Object temporaryEglOwner = new Object();
            EglBaseProvider eglBaseProvider = EglBaseProvider.instance(temporaryEglOwner);
            EglBase localEglBase = eglBaseProvider.getLocalEglBase();
            EglBase remoteEglBase = eglBaseProvider.getRemoteEglBase();
            long nativeMediaFactoryHandle = MediaFactory.nativeCreate(context, localEglBase.getEglBaseContext(), remoteEglBase.getEglBaseContext());
            if (nativeMediaFactoryHandle == 0L) {
                logger.e("Failed to instance MediaFactory");
            } else {
                instance = new MediaFactory(nativeMediaFactoryHandle);
            }
            eglBaseProvider.release(temporaryEglOwner);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    synchronized LocalAudioTrack createAudioTrack(boolean enabled, @Nullable AudioOptions audioOptions, @Nullable String name) {
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createAudioTrack");
        this.addRef();
        LocalAudioTrack localAudioTrack = this.nativeCreateAudioTrack(this.nativeMediaFactoryHandle, enabled, audioOptions, name);
        if (localAudioTrack != null) {
            return localAudioTrack;
        }
        this.release();
        logger.e("Failed to create local audio track");
        return null;
    }

    synchronized LocalVideoTrack createVideoTrack(boolean enabled, @NonNull VideoCapturer videoCapturer, @Nullable VideoConstraints videoConstraints, @Nullable String name) {
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createVideoTrack");
        this.addRef();
        LocalVideoTrack localVideoTrack = this.nativeCreateVideoTrack(this.nativeMediaFactoryHandle, enabled, videoCapturer, videoConstraints, name, this.eglBaseProvider.getLocalEglBase().getEglBaseContext());
        if (localVideoTrack != null) {
            return localVideoTrack;
        }
        this.release();
        logger.e("Failed to create local video track");
        return null;
    }

    synchronized LocalDataTrack createDataTrack(boolean ordered, int maxPacketLifeTime, int maxRetransmits, String name) {
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createDataTrack");
        this.addRef();
        return this.nativeCreateDataTrack(this.nativeMediaFactoryHandle, ordered, maxPacketLifeTime, maxRetransmits, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            Preconditions.checkNotNull(instance, "MediaFactory instance must not be null");
            ++mediaFactoryRefCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release() {
        if (instance == null) return;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            --mediaFactoryRefCount;
            mediaFactoryRefCount = Math.max(0, mediaFactoryRefCount);
            if (instance == null || mediaFactoryRefCount != 0) return;
            this.eglBaseProvider.release(this);
            this.eglBaseProvider = null;
            this.nativeRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    long getNativeMediaFactoryHandle() {
        return this.nativeMediaFactoryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static MediaFactory testCreate(@NonNull Context context, @NonNull MediaOptions mediaOptions) {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (!libraryIsLoaded) {
                ReLinker.loadLibrary((Context)context, (String)"jingle_peerconnection_so");
                libraryIsLoaded = true;
            }
            long nativeMediaFactoryHandle = MediaFactory.nativeTestCreate(context, mediaOptions);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new MediaFactory(nativeMediaFactoryHandle);
        }
    }

    @VisibleForTesting(otherwise=5)
    void testRelease() {
        if (this.nativeMediaFactoryHandle != 0L) {
            this.nativeTestRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static boolean isReleased() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance == null;
        }
    }

    private MediaFactory(long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
        this.eglBaseProvider = EglBaseProvider.instance(this);
    }

    private static native long nativeCreate(Context var0, EglBase.Context var1, EglBase.Context var2);

    private native LocalAudioTrack nativeCreateAudioTrack(long var1, boolean var3, AudioOptions var4, String var5);

    private native LocalVideoTrack nativeCreateVideoTrack(long var1, boolean var3, VideoCapturer var4, VideoConstraints var5, String var6, EglBase.Context var7);

    private native LocalDataTrack nativeCreateDataTrack(long var1, boolean var3, int var4, int var5, String var6);

    private native void nativeRelease(long var1);

    @VisibleForTesting(otherwise=5)
    private static native long nativeTestCreate(Context var0, MediaOptions var1);

    @VisibleForTesting(otherwise=5)
    private native void nativeTestRelease(long var1);

    static {
        mediaFactoryRefCount = 0;
    }
}

