/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.RemoteVideoTrack;
import com.twilio.video.VideoTrack;
import com.twilio.video.VideoTrackPublication;

public class RemoteVideoTrackPublication
implements VideoTrackPublication {
    private final String sid;
    private final String name;
    private RemoteVideoTrack remoteVideoTrack;
    private boolean subscribed;
    private boolean enabled;

    RemoteVideoTrackPublication(boolean subscribed, boolean enabled, @NonNull String sid, @NonNull String name) {
        this.enabled = enabled;
        this.subscribed = subscribed;
        this.sid = sid;
        this.name = name;
    }

    @Override
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @Nullable
    public synchronized VideoTrack getVideoTrack() {
        return this.remoteVideoTrack;
    }

    @Override
    public String getTrackName() {
        return this.name;
    }

    @Override
    public synchronized boolean isTrackEnabled() {
        return this.enabled;
    }

    public synchronized boolean isTrackSubscribed() {
        return this.subscribed;
    }

    @Nullable
    public synchronized RemoteVideoTrack getRemoteVideoTrack() {
        return this.remoteVideoTrack;
    }

    synchronized void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.remoteVideoTrack != null) {
            this.remoteVideoTrack.setEnabled(enabled);
        }
    }

    synchronized void setRemoteVideoTrack(RemoteVideoTrack remoteVideoTrack) {
        this.remoteVideoTrack = remoteVideoTrack;
    }
}

