/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.AudioCodec;
import com.twilio.video.EncodingParameters;
import com.twilio.video.IceOptions;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.MediaFactory;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCodec;
import java.util.ArrayList;
import java.util.List;

public class ConnectOptions {
    private final String accessToken;
    private final String roomName;
    private final List<LocalAudioTrack> audioTracks;
    private final List<LocalVideoTrack> videoTracks;
    private final List<LocalDataTrack> dataTracks;
    private final IceOptions iceOptions;
    private final boolean enableInsights;
    private final List<AudioCodec> preferredAudioCodecs;
    private final List<VideoCodec> preferredVideoCodecs;
    private final EncodingParameters encodingParameters;
    @VisibleForTesting(otherwise=5)
    private final MediaFactory mediaFactory;

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    static void checkVideoTracksReleased(@Nullable List<LocalVideoTrack> videoTracks) {
        if (videoTracks != null) {
            for (LocalVideoTrack localVideoTrack : videoTracks) {
                Preconditions.checkState(!localVideoTrack.isReleased(), "LocalVideoTrack cannot be released");
            }
        }
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.roomName = builder.roomName;
        this.audioTracks = builder.audioTracks;
        this.videoTracks = builder.videoTracks;
        this.dataTracks = builder.dataTracks;
        this.iceOptions = builder.iceOptions;
        this.enableInsights = builder.enableInsights;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.preferredVideoCodecs = builder.preferredVideoCodecs;
        this.encodingParameters = builder.encodingParameters;
        this.mediaFactory = builder.mediaFactory;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRoomName() {
        return this.roomName;
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    List<LocalVideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    List<LocalDataTrack> getDataTracks() {
        return this.dataTracks;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    boolean isInsightsEnabled() {
        return this.enableInsights;
    }

    private LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks != null && this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    private LocalVideoTrack[] getLocalVideoTracksArray() {
        LocalVideoTrack[] videoTracksArray = new LocalVideoTrack[]{};
        if (this.videoTracks != null && this.videoTracks.size() > 0) {
            videoTracksArray = new LocalVideoTrack[this.videoTracks.size()];
            videoTracksArray = this.videoTracks.toArray(videoTracksArray);
        }
        return videoTracksArray;
    }

    private LocalDataTrack[] getLocalDataTracksArray() {
        LocalDataTrack[] dataTracksArray = new LocalDataTrack[]{};
        if (this.dataTracks != null && this.dataTracks.size() > 0) {
            dataTracksArray = new LocalDataTrack[this.dataTracks.size()];
            dataTracksArray = this.dataTracks.toArray(dataTracksArray);
        }
        return dataTracksArray;
    }

    private AudioCodec[] getAudioCodecsArray() {
        AudioCodec[] audioCodecsArray = new AudioCodec[]{};
        if (this.preferredAudioCodecs != null && !this.preferredAudioCodecs.isEmpty()) {
            audioCodecsArray = new AudioCodec[this.preferredAudioCodecs.size()];
            audioCodecsArray = this.preferredAudioCodecs.toArray(audioCodecsArray);
        }
        return audioCodecsArray;
    }

    private VideoCodec[] getVideoCodecsArray() {
        VideoCodec[] videoCodecsArray = new VideoCodec[]{};
        if (this.preferredVideoCodecs != null && !this.preferredVideoCodecs.isEmpty()) {
            videoCodecsArray = new VideoCodec[this.preferredVideoCodecs.size()];
            videoCodecsArray = this.preferredVideoCodecs.toArray(videoCodecsArray);
        }
        return videoCodecsArray;
    }

    EncodingParameters getEncodingParameters() {
        return this.encodingParameters;
    }

    @VisibleForTesting(otherwise=5)
    @Nullable
    MediaFactory getMediaFactory() {
        return this.mediaFactory;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        ConnectOptions.checkVideoTracksReleased(this.videoTracks);
        return this.nativeCreate(this.accessToken, this.roomName, this.getLocalAudioTracksArray(), this.getLocalVideoTracksArray(), this.getLocalDataTracksArray(), this.iceOptions, this.enableInsights, PlatformInfo.getNativeHandle(), this.getAudioCodecsArray(), this.getVideoCodecsArray(), this.encodingParameters);
    }

    private native long nativeCreate(String var1, String var2, LocalAudioTrack[] var3, LocalVideoTrack[] var4, LocalDataTrack[] var5, IceOptions var6, boolean var7, long var8, AudioCodec[] var10, VideoCodec[] var11, EncodingParameters var12);

    public static class Builder {
        private String accessToken = "";
        private String roomName = "";
        private IceOptions iceOptions;
        private List<LocalAudioTrack> audioTracks;
        private List<LocalVideoTrack> videoTracks;
        private List<LocalDataTrack> dataTracks;
        private boolean enableInsights = true;
        private List<AudioCodec> preferredAudioCodecs;
        private List<VideoCodec> preferredVideoCodecs;
        private EncodingParameters encodingParameters;
        private MediaFactory mediaFactory;

        public Builder(String accessToken) {
            this.accessToken = accessToken;
        }

        public Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public Builder audioTracks(List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "LocalAudioTrack List must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        public Builder videoTracks(List<LocalVideoTrack> videoTracks) {
            Preconditions.checkNotNull(videoTracks, "LocalVideoTrack List must not be null");
            this.videoTracks = new ArrayList<LocalVideoTrack>(videoTracks);
            return this;
        }

        public Builder dataTracks(List<LocalDataTrack> dataTracks) {
            this.dataTracks = dataTracks;
            return this;
        }

        public Builder iceOptions(IceOptions iceOptions) {
            this.iceOptions = iceOptions;
            return this;
        }

        public Builder enableInsights(boolean enable) {
            this.enableInsights = enable;
            return this;
        }

        public Builder preferAudioCodecs(List<AudioCodec> preferredAudioCodecs) {
            this.preferredAudioCodecs = new ArrayList<AudioCodec>(preferredAudioCodecs);
            return this;
        }

        public Builder preferVideoCodecs(List<VideoCodec> preferredVideoCodecs) {
            this.preferredVideoCodecs = new ArrayList<VideoCodec>(preferredVideoCodecs);
            return this;
        }

        public Builder encodingParameters(@Nullable EncodingParameters encodingParameters) {
            this.encodingParameters = encodingParameters;
            return this;
        }

        @VisibleForTesting(otherwise=5)
        Builder mediaFactory(@Nullable MediaFactory mediaFactory) {
            this.mediaFactory = mediaFactory;
            return this;
        }

        public ConnectOptions build() {
            Preconditions.checkNotNull(this.accessToken, "Token must not be null.");
            Preconditions.checkArgument(!this.accessToken.equals(""), "Token must not be empty.");
            ConnectOptions.checkAudioTracksReleased(this.audioTracks);
            ConnectOptions.checkVideoTracksReleased(this.videoTracks);
            return new ConnectOptions(this);
        }
    }
}

