/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import com.twilio.video.VideoTrack;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Participant {
    private static final Logger logger = Logger.getLogger(Participant.class);
    private final String identity;
    private final String sid;
    private final List<AudioTrack> audioTracks;
    private final List<VideoTrack> videoTracks;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    private final Listener participantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackAdded(final Participant participant, final AudioTrack audioTrack) {
            this.checkCallback(participant, audioTrack, "onAudioTrackAdded");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackAdded");
                    Participant.this.audioTracks.add(audioTrack);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackAdded(participant, audioTrack);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackRemoved(final Participant participant, final AudioTrack audioTrack) {
            this.checkCallback(participant, audioTrack, "onAudioTrackRemoved");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackRemoved");
                    Participant.this.audioTracks.remove(audioTrack);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackRemoved(participant, audioTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackAdded(final Participant participant, final VideoTrack videoTrack) {
            this.checkCallback(participant, videoTrack, "onVideoTrackAdded");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackAdded");
                    Participant.this.videoTracks.add(videoTrack);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackAdded(participant, videoTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackRemoved(final Participant participant, final VideoTrack videoTrack) {
            this.checkCallback(participant, videoTrack, "onVideoTrackRemoved");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackRemoved");
                    Participant.this.videoTracks.remove(videoTrack);
                    videoTrack.release();
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackRemoved(participant, videoTrack);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackEnabled(final Participant participant, final AudioTrack audioTrack) {
            this.checkCallback(participant, audioTrack, "onAudioTrackEnabled");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackEnabled");
                    audioTrack.setEnabled(true);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackEnabled(participant, audioTrack);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackDisabled(final Participant participant, final AudioTrack audioTrack) {
            this.checkCallback(participant, audioTrack, "onAudioTrackDisabled");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackDisabled");
                    audioTrack.setEnabled(false);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackDisabled(participant, audioTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackEnabled(final Participant participant, final VideoTrack videoTrack) {
            this.checkCallback(participant, videoTrack, "onVideoTrackEnabled");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackEnabled");
                    videoTrack.setEnabled(true);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackEnabled(participant, videoTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackDisabled(final Participant participant, final VideoTrack videoTrack) {
            this.checkCallback(participant, videoTrack, "onVideoTrackDisabled");
            Participant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackDisabled");
                    videoTrack.setEnabled(false);
                    Listener listener = (Listener)Participant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackDisabled(participant, videoTrack);
                    }
                }
            });
        }

        private void checkCallback(Participant participant, Track track, String callback) {
            Preconditions.checkState(participant != null, "Received null participant in %s", (Object)callback);
            Preconditions.checkState(track != null, "Received null track in %s", (Object)callback);
        }
    };
    private long nativeParticipantContext;

    Participant(String identity, String sid, List<AudioTrack> audioTracks, List<VideoTrack> videoTracks, Handler handler, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.audioTracks = audioTracks;
        this.videoTracks = videoTracks;
        this.handler = handler;
        this.nativeParticipantContext = nativeParticipantContext;
        this.nativeCreateParticipantListenerProxy(this.participantListenerProxy, nativeParticipantContext);
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getSid() {
        return this.sid;
    }

    public List<AudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    public List<VideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    public void setListener(@NonNull Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized boolean isConnected() {
        if (!this.isReleased()) {
            return this.nativeIsConnected(this.nativeParticipantContext);
        }
        return false;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            for (VideoTrack videoTrack : this.videoTracks) {
                videoTrack.release();
            }
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private native void nativeCreateParticipantListenerProxy(Listener var1, long var2);

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackAdded(Participant var1, AudioTrack var2);

        public void onAudioTrackRemoved(Participant var1, AudioTrack var2);

        public void onVideoTrackAdded(Participant var1, VideoTrack var2);

        public void onVideoTrackRemoved(Participant var1, VideoTrack var2);

        public void onAudioTrackEnabled(Participant var1, AudioTrack var2);

        public void onAudioTrackDisabled(Participant var1, AudioTrack var2);

        public void onVideoTrackEnabled(Participant var1, VideoTrack var2);

        public void onVideoTrackDisabled(Participant var1, VideoTrack var2);
    }
}

