/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.view.WindowManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Histogram;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

@Deprecated
public class VideoCapturerAndroid
implements CameraVideoCapturer,
Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "VideoCapturerAndroid";
    private static final int CAMERA_STOP_TIMEOUT_MS = 7000;
    private static final Histogram videoCapturerAndroidStartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.VideoCapturerAndroid.StartTimeMs", 1, 10000, 50);
    private static final Histogram videoCapturerAndroidStopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.VideoCapturerAndroid.StopTimeMs", 1, 10000, 50);
    private static final Histogram videoCapturerAndroidResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.VideoCapturerAndroid.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private Camera camera;
    private final AtomicBoolean isCameraRunning = new AtomicBoolean();
    private volatile Handler cameraThreadHandler;
    private Context applicationContext;
    private final Object cameraIdLock = new Object();
    private int id;
    private Camera.CameraInfo info;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final Object pendingCameraSwitchLock = new Object();
    private final Object pendingCameraParameterInjectionLock = new Object();
    private final Object pendingPictureLock = new Object();
    private volatile boolean pendingCameraSwitch;
    private volatile boolean pendingCameraParameterInjection;
    private volatile boolean pendingPicture;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private final Set<byte[]> queuedBuffers = new HashSet<byte[]>();
    private final boolean isCapturingToTexture;
    private SurfaceTextureHelper surfaceHelper;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private int openCameraAttempts;
    private long startStartTimeNs;
    private final Camera.ErrorCallback cameraErrorCallback = new Camera.ErrorCallback(){

        public void onError(int error, Camera camera) {
            boolean cameraRunning = VideoCapturerAndroid.this.isCameraRunning.get();
            String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
            Logging.e(VideoCapturerAndroid.TAG, errorMessage + ". Camera running: " + cameraRunning);
            if (VideoCapturerAndroid.this.eventsHandler != null) {
                if (error == 2) {
                    if (cameraRunning) {
                        VideoCapturerAndroid.this.eventsHandler.onCameraDisconnected();
                    } else {
                        Logging.d(VideoCapturerAndroid.TAG, "Ignore CAMERA_ERROR_EVICTED for closed camera.");
                    }
                } else {
                    VideoCapturerAndroid.this.eventsHandler.onCameraError(errorMessage);
                }
            }
        }
    };

    public static VideoCapturerAndroid create(String name, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return VideoCapturerAndroid.create(name, eventsHandler, false);
    }

    @Deprecated
    public static VideoCapturerAndroid create(String name, CameraVideoCapturer.CameraEventsHandler eventsHandler, boolean captureToTexture) {
        try {
            return new VideoCapturerAndroid(name, eventsHandler, captureToTexture);
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Couldn't create camera.", e);
            return null;
        }
    }

    public void printStackTrace() {
        StackTraceElement[] cameraStackTraces;
        Thread cameraThread = null;
        if (this.cameraThreadHandler != null) {
            cameraThread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (cameraThread != null && (cameraStackTraces = cameraThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "VideoCapturerAndroid stacks trace:");
            for (StackTraceElement stackTrace : cameraStackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        if (Camera.getNumberOfCameras() < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Logging.w(TAG, "Ignoring camera switch request.");
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchError("Pending camera switch already in progress.");
                }
                return;
            }
            this.pendingCameraSwitch = true;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoCapturerAndroid.this.switchCameraOnCameraThread();
                Object object = VideoCapturerAndroid.this.pendingCameraSwitchLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraSwitch = false;
                }
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchDone(((VideoCapturerAndroid)VideoCapturerAndroid.this).info.facing == 1);
                }
            }
        });
        if (!didPost) {
            Object object2 = this.pendingCameraSwitchLock;
            synchronized (object2) {
                this.pendingCameraSwitch = false;
            }
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("Camera is stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectCameraParameters(final CameraParameterInjector cameraParameterInjector) {
        Object object = this.pendingCameraParameterInjectionLock;
        synchronized (object) {
            if (this.pendingCameraParameterInjection) {
                Logging.w(TAG, "Ignoring camera parameter injection switch request.");
                return false;
            }
            this.pendingCameraParameterInjection = true;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (cameraParameterInjector != null && VideoCapturerAndroid.this.camera != null) {
                    Camera.Parameters parameters = VideoCapturerAndroid.this.camera.getParameters();
                    cameraParameterInjector.onCameraParameters(parameters);
                    VideoCapturerAndroid.this.injectCameraParametersOnCameraThread(parameters);
                }
                Object object = VideoCapturerAndroid.this.pendingCameraParameterInjectionLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraParameterInjection = false;
                }
            }
        });
        return didPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takePicture(final PictureEventHandler pictureEventHandler) {
        Object object = this.pendingPictureLock;
        synchronized (object) {
            if (this.pendingPicture) {
                Logging.w(TAG, "Ignoring camera picture request.");
                return false;
            }
            this.pendingPicture = true;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (pictureEventHandler != null && VideoCapturerAndroid.this.camera != null) {
                    VideoCapturerAndroid.this.camera.takePicture(new Camera.ShutterCallback(){

                        public void onShutter() {
                            pictureEventHandler.onShutter();
                        }
                    }, null, new Camera.PictureCallback(){

                        public void onPictureTaken(byte[] data, Camera camera) {
                            pictureEventHandler.onPictureTaken(data);
                            if (VideoCapturerAndroid.this.camera != null) {
                                camera.startPreview();
                            }
                        }
                    });
                }
                Object object = VideoCapturerAndroid.this.pendingPictureLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingPicture = false;
                }
            }
        });
        return didPost;
    }

    @Override
    public void changeCaptureFormat(final int width, final int height, final int framerate) {
        this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startPreviewOnCameraThread(width, height, framerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    public VideoCapturerAndroid(String cameraName, CameraVideoCapturer.CameraEventsHandler eventsHandler, boolean captureToTexture) {
        if (Camera.getNumberOfCameras() == 0) {
            throw new RuntimeException("No cameras available");
        }
        this.id = cameraName == null || cameraName.equals("") ? 0 : Camera1Enumerator.getCameraIndex(cameraName);
        this.eventsHandler = eventsHandler;
        this.isCapturingToTexture = captureToTexture;
        Logging.d(TAG, "VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture);
    }

    private void checkIsOnCameraThread() {
        if (this.cameraThreadHandler == null) {
            Logging.e(TAG, "Camera is not initialized - can't check thread.");
        } else if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private boolean maybePostOnCameraThread(Runnable runnable) {
        return this.maybePostDelayedOnCameraThread(0, runnable);
    }

    private boolean maybePostDelayedOnCameraThread(int delayMs, Runnable runnable) {
        return this.cameraThreadHandler != null && this.isCameraRunning.get() && this.cameraThreadHandler.postAtTime(runnable, (Object)this, SystemClock.uptimeMillis() + (long)delayMs);
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
    }

    private boolean isInitialized() {
        return this.applicationContext != null && this.frameObserver != null;
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, VideoCapturer.CapturerObserver frameObserver) {
        Logging.d(TAG, "initialize");
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext not set.");
        }
        if (frameObserver == null) {
            throw new IllegalArgumentException("frameObserver not set.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
        this.applicationContext = applicationContext;
        this.frameObserver = frameObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    @Override
    public void startCapture(final int width, final int height, final int framerate) {
        Logging.d(TAG, "startCapture requested: " + width + "x" + height + "@" + framerate);
        if (!this.isInitialized()) {
            throw new IllegalStateException("startCapture called in uninitialized state");
        }
        if (this.surfaceHelper == null) {
            this.frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("No SurfaceTexture created.");
            }
            return;
        }
        if (this.isCameraRunning.getAndSet(true)) {
            Logging.e(TAG, "Camera has already been started.");
            return;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.openCameraAttempts = 0;
                VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate);
            }
        });
        if (!didPost) {
            this.frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Could not post task to camera thread.");
            }
            this.isCameraRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(final int width, final int height, final int framerate) {
        block13: {
            this.checkIsOnCameraThread();
            this.startStartTimeNs = System.nanoTime();
            if (!this.isCameraRunning.get()) {
                Logging.e(TAG, "startCaptureOnCameraThread: Camera is stopped");
                return;
            }
            if (this.camera != null) {
                Logging.e(TAG, "startCaptureOnCameraThread: Camera has already been started.");
                return;
            }
            this.firstFrameReported = false;
            try {
                try {
                    Object object = this.cameraIdLock;
                    synchronized (object) {
                        Logging.d(TAG, "Opening camera " + this.id);
                        if (this.eventsHandler != null) {
                            this.eventsHandler.onCameraOpening(Camera1Enumerator.getDeviceName(this.id));
                        }
                        this.camera = Camera.open((int)this.id);
                        this.info = new Camera.CameraInfo();
                        Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
                    }
                }
                catch (RuntimeException e) {
                    ++this.openCameraAttempts;
                    if (this.openCameraAttempts < 3) {
                        Logging.e(TAG, "Camera.open failed, retrying", e);
                        this.maybePostDelayedOnCameraThread(500, new Runnable(){

                            @Override
                            public void run() {
                                VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate);
                            }
                        });
                        return;
                    }
                    throw e;
                }
                this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
                Logging.d(TAG, "Camera orientation: " + this.info.orientation + " .Device orientation: " + this.getDeviceOrientation());
                this.camera.setErrorCallback(this.cameraErrorCallback);
                this.startPreviewOnCameraThread(width, height, framerate);
                this.frameObserver.onCapturerStarted(true);
                if (this.isCapturingToTexture) {
                    this.surfaceHelper.startListening(this);
                }
                this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(this.surfaceHelper, this.eventsHandler);
            }
            catch (IOException | RuntimeException e) {
                Logging.e(TAG, "startCapture failed", e);
                this.stopCaptureOnCameraThread(true);
                this.frameObserver.onCapturerStarted(false);
                if (this.eventsHandler == null) break block13;
                this.eventsHandler.onCameraError("Camera can not be started.");
            }
        }
    }

    private void startPreviewOnCameraThread(int width, int height, int framerate) {
        List focusModes;
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get() || this.camera == null) {
            Logging.e(TAG, "startPreviewOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d(TAG, "startPreviewOnCameraThread requested: " + width + "x" + height + "@" + framerate);
        this.requestedWidth = width;
        this.requestedHeight = height;
        this.requestedFramerate = framerate;
        Camera.Parameters parameters = this.camera.getParameters();
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + supportedFramerates);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(supportedFramerates, framerate);
        List<Size> supportedPreviewSizes = Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes());
        Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize(supportedPreviewSizes, width, height);
        CameraEnumerationAndroid.reportCameraResolution(videoCapturerAndroidResolutionHistogram, previewSize);
        Logging.d(TAG, "Available preview sizes: " + supportedPreviewSizes);
        CameraEnumerationAndroid.CaptureFormat captureFormat = new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
        if (captureFormat.equals(this.captureFormat)) {
            return;
        }
        Logging.d(TAG, "isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported());
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (captureFormat.framerate.max > 0) {
            parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        }
        parameters.setPreviewSize(previewSize.width, previewSize.height);
        if (!this.isCapturingToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        Size pictureSize = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        if ((focusModes = parameters.getSupportedFocusModes()).contains("continuous-video")) {
            Logging.d(TAG, "Enable continuous auto focus mode.");
            parameters.setFocusMode("continuous-video");
        }
        Logging.d(TAG, "Start capturing: " + captureFormat);
        this.captureFormat = captureFormat;
        this.camera.setParameters(parameters);
        this.camera.setDisplayOrientation(0);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                this.queuedBuffers.add(buffer.array());
                this.camera.addCallbackBuffer(buffer.array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    @Override
    public void stopCapture() throws InterruptedException {
        Logging.d(TAG, "stopCapture");
        final CountDownLatch barrier = new CountDownLatch(1);
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.stopCaptureOnCameraThread(true);
                barrier.countDown();
            }
        });
        if (!didPost) {
            Logging.e(TAG, "Calling stopCapture() for already stopped camera.");
            return;
        }
        if (!barrier.await(7000L, TimeUnit.MILLISECONDS)) {
            Logging.e(TAG, "Camera stop timeout");
            this.printStackTrace();
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera stop timeout");
            }
        }
        this.frameObserver.onCapturerStopped();
        Logging.d(TAG, "stopCapture done");
    }

    private void stopCaptureOnCameraThread(boolean stopHandler) {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "stopCaptureOnCameraThread");
        long stopStartTime = System.nanoTime();
        if (this.surfaceHelper != null) {
            this.surfaceHelper.stopListening();
        }
        if (stopHandler) {
            this.isCameraRunning.set(false);
            this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
        }
        if (this.cameraStatistics != null) {
            this.cameraStatistics.release();
            this.cameraStatistics = null;
        }
        Logging.d(TAG, "Stop preview.");
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Logging.d(TAG, "Release camera.");
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
        int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
        videoCapturerAndroidStopTimeMsHistogram.addSample(stopTimeMs);
        Logging.d(TAG, "stopCaptureOnCameraThread done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "switchCameraOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d(TAG, "switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread(false);
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate);
        Logging.d(TAG, "switchCameraOnCameraThread done");
    }

    private void injectCameraParametersOnCameraThread(Camera.Parameters parameters) {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "injectCameraParametersOnCameraThread");
        this.camera.stopPreview();
        this.camera.setPreviewCallbackWithBuffer(null);
        this.camera.setParameters(parameters);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int frameSize = this.captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                this.queuedBuffers.add(buffer.array());
                this.camera.addCallbackBuffer(buffer.array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    public void onPreviewFrame(byte[] data, Camera callbackCamera) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "onPreviewFrame: Camera is stopped");
            return;
        }
        if (!this.queuedBuffers.contains(data)) {
            return;
        }
        if (this.camera != callbackCamera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (!this.firstFrameReported) {
            this.onFirstFrameAvailable();
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onByteBufferFrameCaptured(data, this.captureFormat.width, this.captureFormat.height, this.getFrameOrientation(), captureTimeNs);
        this.camera.addCallbackBuffer(data);
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "onTextureFrameAvailable: Camera is stopped");
            this.surfaceHelper.returnTextureFrame();
            return;
        }
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        }
        if (!this.firstFrameReported) {
            this.onFirstFrameAvailable();
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, oesTextureId, transformMatrix, rotation, timestampNs);
    }

    private void onFirstFrameAvailable() {
        if (this.eventsHandler != null) {
            this.eventsHandler.onFirstFrameAvailable();
        }
        int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startStartTimeNs);
        videoCapturerAndroidStartTimeMsHistogram.addSample(startTimeMs);
        this.firstFrameReported = true;
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public static interface PictureEventHandler {
        public void onShutter();

        public void onPictureTaken(byte[] var1);
    }

    public static interface CameraParameterInjector {
        public void onCameraParameters(Camera.Parameters var1);
    }
}

