/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.LocalAudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import com.twilio.video.VideoTrack;

public class LocalVideoTrack
extends VideoTrack {
    private static final Logger logger = Logger.getLogger(LocalAudioTrack.class);
    private long nativeLocalVideoTrackHandle;
    private final VideoCapturer videoCapturer;
    private final VideoConstraints videoConstraints;

    LocalVideoTrack(long nativeLocalVideoTrackHandle, VideoCapturer videoCapturer, VideoConstraints videoConstraints, org.webrtc.VideoTrack webrtcVideoTrack) {
        super(webrtcVideoTrack);
        this.nativeLocalVideoTrackHandle = nativeLocalVideoTrackHandle;
        this.videoCapturer = videoCapturer;
        this.videoConstraints = videoConstraints;
    }

    public VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    public VideoConstraints getVideoConstraints() {
        return this.videoConstraints;
    }

    @Override
    public boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalVideoTrackHandle);
        }
        logger.e("Local video track is not enabled because it has been removed");
        return false;
    }

    public void enable(boolean enabled) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalVideoTrackHandle, enabled);
        } else {
            logger.e("Cannot enable a local video track that has been removed");
        }
    }

    @Override
    synchronized void release() {
        if (!this.isReleased()) {
            super.release();
            this.nativeRelease(this.nativeLocalVideoTrackHandle);
            this.nativeLocalVideoTrackHandle = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeLocalVideoTrackHandle == 0L;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

