/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.IceServer;
import com.twilio.video.IceTransportPolicy;
import java.util.Set;

public class IceOptions {
    private final Set<IceServer> iceServers;
    private final IceTransportPolicy iceTransportPolicy;

    private IceOptions(Builder builder) {
        this.iceServers = builder.iceServers;
        this.iceTransportPolicy = builder.iceTransportPolicy;
    }

    public Set<IceServer> getIceServers() {
        return this.iceServers;
    }

    public IceTransportPolicy getIceTransportPolicy() {
        return this.iceTransportPolicy;
    }

    IceServer[] getIceServersArray() {
        IceServer[] iceServersArray = new IceServer[]{};
        if (this.iceServers != null && this.iceServers.size() > 0) {
            iceServersArray = this.iceServers.toArray(new IceServer[this.iceServers.size()]);
        }
        return iceServersArray;
    }

    public static class Builder {
        private Set<IceServer> iceServers;
        private IceTransportPolicy iceTransportPolicy = IceTransportPolicy.ALL;

        public Builder iceServers(Set<IceServer> iceServers) {
            this.iceServers = iceServers;
            return this;
        }

        public Builder iceTransportPolicy(IceTransportPolicy iceTransportPolicy) {
            this.iceTransportPolicy = iceTransportPolicy;
            return this;
        }

        public IceOptions build() {
            return new IceOptions(this);
        }
    }
}

