/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import com.twilio.video.CameraCapturerEventsHandler;
import com.twilio.video.CameraCapturerFormatProvider;
import com.twilio.video.CapturerErrorListener;
import com.twilio.video.CapturerException;
import com.twilio.video.Logger;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import java.util.List;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoCapturerAndroid;

public class CameraCapturer
implements VideoCapturer {
    private static final Logger logger = Logger.getLogger(CameraCapturer.class);
    private final Context context;
    private final CapturerErrorListener listener;
    private final CameraCapturerFormatProvider formatProvider = new CameraCapturerFormatProvider();
    private VideoCapturerAndroid webrtcCapturer;
    private CameraSource cameraSource;
    private VideoCapturer.Listener videoCapturerListener;
    private SurfaceTextureHelper surfaceTextureHelper;
    private final VideoCapturer.CapturerObserver observerAdapter = new VideoCapturer.CapturerObserver(){

        public void onCapturerStarted(boolean success) {
            CameraCapturer.this.videoCapturerListener.onCapturerStarted(success);
        }

        public void onByteBufferFrameCaptured(byte[] bytes, int width, int height, int rotation, long timestamp) {
            VideoDimensions frameDimensions = new VideoDimensions(width, height);
            VideoFrame frame = new VideoFrame(bytes, frameDimensions, rotation, timestamp);
            CameraCapturer.this.videoCapturerListener.onFrameCaptured(frame);
        }

        public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestampNs) {
        }

        public void onOutputFormatRequest(int width, int height, int framerate) {
        }
    };

    public CameraCapturer(Context context, CameraSource cameraSource, CapturerErrorListener listener) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (cameraSource == null) {
            throw new NullPointerException("camera source must not be null");
        }
        if (!Util.permissionGranted(context, "android.permission.CAMERA") && listener != null) {
            listener.onError(new CapturerException(CapturerException.ExceptionDomain.CAMERA, "CAMERA permission not granted"));
        }
        this.context = context;
        this.cameraSource = cameraSource;
        this.listener = listener;
    }

    @Override
    public List<VideoFormat> getSupportedFormats() {
        return this.formatProvider.getSupportedFormats(this.cameraSource);
    }

    @Override
    public void startCapture(VideoFormat captureFormat, VideoCapturer.Listener videoCapturerListener) {
        this.webrtcCapturer = this.createVideoCapturerAndroid();
        if (this.webrtcCapturer == null) {
            if (this.listener != null) {
                this.listener.onError(new CapturerException(CapturerException.ExceptionDomain.CAPTURER, "Failed to create capturer"));
            }
            videoCapturerListener.onCapturerStarted(false);
            return;
        }
        this.videoCapturerListener = videoCapturerListener;
        this.webrtcCapturer.startCapture(captureFormat.dimensions.width, captureFormat.dimensions.height, captureFormat.framerate, this.surfaceTextureHelper, this.context, this.observerAdapter);
    }

    @Override
    public void stopCapture() {
        try {
            this.webrtcCapturer.stopCapture();
        }
        catch (InterruptedException e) {
            logger.e("Failed to stop camera capturer");
        }
        this.webrtcCapturer.dispose();
        this.webrtcCapturer = null;
    }

    public synchronized CameraSource getCameraSource() {
        return this.cameraSource;
    }

    public synchronized void switchCamera() {
        if (this.webrtcCapturer != null) {
            this.webrtcCapturer.switchCamera(null);
        }
        this.cameraSource = this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
    }

    void setSurfaceTextureHelper(SurfaceTextureHelper surfaceTextureHelper) {
        this.surfaceTextureHelper = surfaceTextureHelper;
    }

    private VideoCapturerAndroid createVideoCapturerAndroid() {
        int cameraId = CameraCapturerFormatProvider.getCameraId(this.cameraSource);
        if (cameraId < 0) {
            logger.e("Failed to find camera source");
            if (this.listener != null) {
                this.listener.onError(new CapturerException(CapturerException.ExceptionDomain.CAMERA, "Unsupported camera source provided"));
            }
            return null;
        }
        CameraCapturerEventsHandler eventsHandler = new CameraCapturerEventsHandler(this.listener);
        String deviceName = CameraEnumerationAndroid.getDeviceName((int)cameraId);
        if (deviceName == null) {
            return null;
        }
        return VideoCapturerAndroid.create((String)deviceName, (VideoCapturerAndroid.CameraEventsHandler)eventsHandler);
    }

    public static enum CameraSource {
        FRONT_CAMERA,
        BACK_CAMERA;

    }
}

