/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.util;

import com.twilio.util.TwilioLogger;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0005"}, d2={"SslContext", "Ljavax/net/ssl/SSLContext;", "certificates", "", "", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nSslContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslContext.kt\ncom/twilio/twilsock/util/SslContextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1864#2,3:42\n*S KotlinDebug\n*F\n+ 1 SslContext.kt\ncom/twilio/twilsock/util/SslContextKt\n*L\n19#1:42,3\n*E\n"})
public final class SslContextKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SSLContext SslContext(@NotNull List<String> certificates) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Iterable $this$forEachIndexed$iv = certificates;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Object object = $this$forEachIndexed$iv.iterator();
        while (object.hasNext()) {
            void certificate;
            int n;
            Object item$iv = object.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            ByteArrayInputStream stream = new ByteArrayInputStream(StringsKt.encodeToByteArray((String)((Object)StringsKt.trim((CharSequence)((CharSequence)certificate))).toString()));
            try {
                Certificate ca = cf.generateCertificate(stream);
                ks.setCertificateEntry("entry" + index, ca);
            }
            catch (Exception e) {
                TwilioLogger.Companion.getLogger("SslContextHelper").e("Error parsing: \n" + (String)certificate, (Throwable)e);
            }
        }
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(ks);
        Object $this$SslContext_u24lambda_u241 = object = SSLContext.getInstance("TLS");
        boolean bl = false;
        ((SSLContext)$this$SslContext_u24lambda_u241).init(null, tmf.getTrustManagers(), new SecureRandom());
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getInstance(\"TLS\").apply\u2026rs, SecureRandom())\n    }");
        return object2;
    }
}

