/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.twilio.twilsock.client.ClientMetadata;
import com.twilio.twilsock.util.MetadataAndroidKt;
import com.twilio.util.TwilioLogger;
import com.twilio.util.TwilioLoggerKt;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0002\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"isProbablyRunningOnEmulator", "", "()Z", "isProbablyRunningOnEmulator$delegate", "Lkotlin/Lazy;", "deviceManufacturer", "", "Landroid/content/Context;", "getDeviceManufacturer", "(Landroid/content/Context;)Ljava/lang/String;", "deviceName", "getDeviceName", "deviceType", "getDeviceType", "packageInfo", "Landroid/content/pm/PackageInfo;", "getPackageInfo", "(Landroid/content/Context;)Landroid/content/pm/PackageInfo;", "capitalize", "s", "toClientMetadata", "Lcom/twilio/twilsock/client/ClientMetadata;", "sdkVersion", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nMetadataAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataAndroid.kt\ncom/twilio/twilsock/util/MetadataAndroidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class MetadataAndroidKt {
    @NotNull
    private static final Lazy isProbablyRunningOnEmulator$delegate = LazyKt.lazy((Function0)isProbablyRunningOnEmulator.2.INSTANCE);

    @NotNull
    public static final ClientMetadata toClientMetadata(@NotNull Context $this$toClientMetadata, @NotNull String sdkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toClientMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Object object = $this$toClientMetadata.getPackageName();
        String string = MetadataAndroidKt.getPackageInfo((Context)$this$toClientMetadata).versionName;
        String string2 = Build.VERSION.RELEASE;
        String string3 = System.getProperty("os.arch");
        String string4 = MetadataAndroidKt.getDeviceName($this$toClientMetadata);
        String string5 = MetadataAndroidKt.getDeviceManufacturer($this$toClientMetadata);
        String string6 = MetadataAndroidKt.getDeviceType($this$toClientMetadata);
        Object it = object = new ClientMetadata(null, null, "Android", string2, string3, string4, string5, string6, (String)object, string, "sync", "Android", sdkVersion, 3, null);
        boolean bl = false;
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("BOARD " + Build.BOARD), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("BRAND " + Build.BRAND), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("DEVICE " + Build.DEVICE), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("DISPLAY " + Build.DISPLAY), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("FINGERPRINT " + Build.FINGERPRINT), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("HARDWARE " + Build.HARDWARE), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("MANUFACTURER " + Build.MANUFACTURER), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("MODEL " + Build.MODEL), null, (int)2, null);
        TwilioLogger.d$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)$this$toClientMetadata), (String)("PRODUCT " + Build.PRODUCT), null, (int)2, null);
        return object;
    }

    private static final PackageInfo getPackageInfo(Context $this$packageInfo) {
        PackageInfo packageInfo;
        if (Build.VERSION.SDK_INT >= 33) {
            PackageInfo packageInfo2 = $this$packageInfo.getPackageManager().getPackageInfo($this$packageInfo.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
            packageInfo = packageInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"packageManager.getPackag\u2026r.PackageInfoFlags.of(0))");
        } else {
            PackageInfo packageInfo3 = $this$packageInfo.getPackageManager().getPackageInfo($this$packageInfo.getPackageName(), 0);
            packageInfo = packageInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo3, (String)"packageManager.getPackageInfo(packageName, 0)");
        }
        return packageInfo;
    }

    private static final String getDeviceName(Context $this$deviceName) {
        if (MetadataAndroidKt.isProbablyRunningOnEmulator()) {
            return "emulator";
        }
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        Intrinsics.checkNotNullExpressionValue((Object)manufacturer, (String)"manufacturer");
        return StringsKt.startsWith$default((String)model, (String)manufacturer, (boolean)false, (int)2, null) ? MetadataAndroidKt.capitalize(model) : MetadataAndroidKt.capitalize(manufacturer) + ' ' + model;
    }

    private static final String getDeviceManufacturer(Context $this$deviceManufacturer) {
        String string;
        if (MetadataAndroidKt.isProbablyRunningOnEmulator()) {
            string = "emulator";
        } else {
            String string2 = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MANUFACTURER");
            string = MetadataAndroidKt.capitalize(string2);
        }
        return string;
    }

    private static final String getDeviceType(Context $this$deviceType) {
        String string;
        if (MetadataAndroidKt.isProbablyRunningOnEmulator()) {
            string = "emulator";
        } else {
            String string2 = Build.DEVICE;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String capitalize(String s) {
        String string;
        String string2 = s;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private static final boolean isProbablyRunningOnEmulator() {
        Lazy lazy = isProbablyRunningOnEmulator$delegate;
        return (Boolean)lazy.getValue();
    }
}

