/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import com.twilio.twilsock.util.ConnectivityMonitor;
import com.twilio.twilsock.util.ConnectivityMonitorImpl;
import com.twilio.util.ApplicationContextHolder;
import com.twilio.util.TwilioLoggerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u001f\u0010\u0005\u001a\u00060\u0006R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/twilio/twilsock/util/ConnectivityMonitorImpl;", "Lcom/twilio/twilsock/util/ConnectivityMonitor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "connectionStatusCallback", "Lcom/twilio/twilsock/util/ConnectivityMonitorImpl$ConnectionStatusCallback;", "getConnectionStatusCallback", "()Lcom/twilio/twilsock/util/ConnectivityMonitorImpl$ConnectionStatusCallback;", "connectionStatusCallback$delegate", "Lkotlin/Lazy;", "connectivityManager", "Landroid/net/ConnectivityManager;", "<set-?>", "", "isNetworkAvailable", "()Z", "setNetworkAvailable", "(Z)V", "isNetworkAvailable$delegate", "Lkotlin/properties/ReadWriteProperty;", "onChanged", "Lkotlin/Function0;", "", "getOnChanged", "()Lkotlin/jvm/functions/Function0;", "setOnChanged", "(Lkotlin/jvm/functions/Function0;)V", "initNetworkAvailable", "start", "stop", "ConnectionStatusCallback", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nConnectivityMonitorAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityMonitorAndroid.kt\ncom/twilio/twilsock/util/ConnectivityMonitorImpl\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,100:1\n33#2,3:101\n*S KotlinDebug\n*F\n+ 1 ConnectivityMonitorAndroid.kt\ncom/twilio/twilsock/util/ConnectivityMonitorImpl\n*L\n31#1:101,3\n*E\n"})
public final class ConnectivityMonitorImpl
implements ConnectivityMonitor {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final ReadWriteProperty isNetworkAvailable$delegate;
    @NotNull
    private Function0<Unit> onChanged;
    @NotNull
    private final Lazy connectionStatusCallback$delegate;

    /*
     * WARNING - void declaration
     */
    public ConnectivityMonitorImpl(@NotNull CoroutineScope coroutineScope) {
        Context context;
        ConnectivityMonitorImpl connectivityMonitorImpl;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        ConnectivityMonitorImpl connectivityMonitorImpl2 = this;
        try {
            connectivityMonitorImpl = connectivityMonitorImpl2;
            context = ApplicationContextHolder.getApplicationContext();
            Object object = context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            context = (ConnectivityManager)object;
        }
        catch (Throwable throwable) {
            void t;
            connectivityMonitorImpl = connectivityMonitorImpl2;
            TwilioLoggerKt.getLogger((Object)this).w("Cannot get ConnectivityManager, considering network as always available", (Throwable)t);
            context = null;
        }
        connectivityMonitorImpl.connectivityManager = context;
        context = Delegates.INSTANCE;
        Boolean initialValue$iv = this.initNetworkAvailable();
        boolean $i$f$observable = false;
        this.isNetworkAvailable$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ ConnectivityMonitorImpl this$0;
            {
                this.this$0 = connectivityMonitorImpl;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void new_;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean old = (Boolean)oldValue;
                boolean bl2 = false;
                if (old != new_) {
                    BuildersKt.launch$default((CoroutineScope)ConnectivityMonitorImpl.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        final /* synthetic */ ConnectivityMonitorImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.getOnChanged().invoke();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        };
        this.onChanged = onChanged.1.INSTANCE;
        this.connectionStatusCallback$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConnectionStatusCallback>(this){
            final /* synthetic */ ConnectivityMonitorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ConnectionStatusCallback invoke() {
                return this.this$0.new ConnectionStatusCallback();
            }
        }));
    }

    @Override
    public boolean isNetworkAvailable() {
        return (Boolean)this.isNetworkAvailable$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void setNetworkAvailable(boolean bl) {
        this.isNetworkAvailable$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    @NotNull
    public Function0<Unit> getOnChanged() {
        return this.onChanged;
    }

    @Override
    public void setOnChanged(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onChanged = function0;
    }

    private final ConnectionStatusCallback getConnectionStatusCallback() {
        Lazy lazy = this.connectionStatusCallback$delegate;
        return (ConnectionStatusCallback)((Object)lazy.getValue());
    }

    @Override
    public void start() {
        try {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager != null) {
                connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)this.getConnectionStatusCallback());
            }
        }
        catch (Exception e) {
            TwilioLoggerKt.getLogger((Object)this).w("Cannot registerNetworkCallback (probably app doesn't have ACCESS_NETWORK_STATE permission? Considering network as always available)", (Throwable)e);
            this.setNetworkAvailable(true);
        }
    }

    @Override
    public void stop() {
        try {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager != null) {
                connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.getConnectionStatusCallback());
            }
        }
        catch (Exception e) {
            TwilioLoggerKt.getLogger((Object)this).w("Cannot unregisterNetworkCallback (probably app doesn't have ACCESS_NETWORK_STATE permission?", (Throwable)e);
        }
    }

    private final boolean initNetworkAvailable() {
        boolean bl;
        try {
            boolean bl2;
            if (this.connectivityManager == null) {
                bl2 = true;
            } else if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities capabilities;
                Network network = this.connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = capabilities = this.connectivityManager.getNetworkCapabilities(network);
                bl2 = networkCapabilities != null ? networkCapabilities.hasCapability(12) : false;
            } else {
                NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
                bl2 = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            }
            bl = bl2;
        }
        catch (Exception e) {
            TwilioLoggerKt.getLogger((Object)this).w("Cannot read current network state (probably app doesn't have ACCESS_NETWORK_STATE permission? Considering network as available)", (Throwable)e);
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(ConnectivityMonitorImpl $this) {
        return $this.coroutineScope;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ConnectivityMonitorImpl.class, "isNetworkAvailable", "isNetworkAvailable()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/twilio/twilsock/util/ConnectivityMonitorImpl$ConnectionStatusCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lcom/twilio/twilsock/util/ConnectivityMonitorImpl;)V", "activeNetworks", "", "Landroid/net/Network;", "onAvailable", "", "network", "onLost", "twilsock_release"})
    @SourceDebugExtension(value={"SMAP\nConnectivityMonitorAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityMonitorAndroid.kt\ncom/twilio/twilsock/util/ConnectivityMonitorImpl$ConnectionStatusCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n2624#2,3:101\n*S KotlinDebug\n*F\n+ 1 ConnectivityMonitorAndroid.kt\ncom/twilio/twilsock/util/ConnectivityMonitorImpl$ConnectionStatusCallback\n*L\n93#1:101,3\n*E\n"})
    private final class ConnectionStatusCallback
    extends ConnectivityManager.NetworkCallback {
        @NotNull
        private final List<Network> activeNetworks = new ArrayList();

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            CollectionsKt.removeAll(this.activeNetworks, (Function1)((Function1)new Function1<Network, Boolean>(network){
                final /* synthetic */ Network $network;
                {
                    this.$network = $network;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Network activeNetwork) {
                    Intrinsics.checkNotNullParameter((Object)activeNetwork, (String)"activeNetwork");
                    return Intrinsics.areEqual((Object)activeNetwork, (Object)this.$network);
                }
            }));
            ConnectivityMonitorImpl.this.setNetworkAvailable(!((Collection)this.activeNetworks).isEmpty());
        }

        public void onAvailable(@NotNull Network network) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Iterable $this$none$iv = this.activeNetworks;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Network activeNetwork = (Network)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)activeNetwork, (Object)network)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.activeNetworks.add(network);
            }
            ConnectivityMonitorImpl.this.setNetworkAvailable(!((Collection)this.activeNetworks).isEmpty());
        }
    }
}

