/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static Map<String, String> toMap(JSONObject object) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            map.put(key, (String)((Object)value));
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    private static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static String getDeviceName() {
        if (Utils.isEmulator()) {
            return "emulator";
        }
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return Utils.capitalize(model);
        }
        return Utils.capitalize(manufacturer) + " " + model;
    }

    public static String getDeviceManufacturer() {
        if (Utils.isEmulator()) {
            return "emulator";
        }
        String manufacturer = Build.MANUFACTURER;
        return Utils.capitalize(manufacturer);
    }

    public static String getDeviceType() {
        if (Utils.isEmulator()) {
            return "emulator";
        }
        return Build.DEVICE;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static String getAndroidSDKVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getAppName(Context ctx) {
        return ctx.getPackageName();
    }

    public static String getAppVersion(Context ctx) {
        try {
            PackageInfo packageInfo = Build.VERSION.SDK_INT >= 33 ? ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L)) : ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException xcp) {
            return "unknown";
        }
    }
}

