/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtils {
    private static final String ISO_8601_PATTERN_0 = "yyyy-MM-dd'T'HH:mmZ";
    private static final String ISO_8601_PATTERN_1 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ISO_8601_PATTERN_2 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String[] SUPPORTED_ISO_8601_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
    private static final int TICK_MARK_COUNT = 2;
    private static final int COLON_PREFIX_COUNT = "+00".length();
    private static final int COLON_INDEX = 22;

    public static Date parseIso8601DateTime(String string) {
        if (string == null) {
            return null;
        }
        String s = string.replace("Z", "+00:00");
        for (String pattern : SUPPORTED_ISO_8601_PATTERNS) {
            String str = s;
            int colonPosition = pattern.lastIndexOf(90) - 2 + COLON_PREFIX_COUNT;
            if (str.length() > colonPosition) {
                str = str.substring(0, colonPosition) + str.substring(colonPosition + 1);
            }
            try {
                return new SimpleDateFormat(pattern, Locale.US).parse(str);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static String formatIso8601DateTime(Date date, TimeZone timeZone) {
        String formatted;
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_8601_PATTERN_1, Locale.US);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        if ((formatted = dateFormat.format(date)) != null && formatted.length() > 22) {
            formatted = formatted.substring(0, 22) + ":" + formatted.substring(22);
        }
        return formatted;
    }

    private DateUtils() {
    }
}

