/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.ConversationsClient;
import com.twilio.conversations.ConversationsClientListener;
import com.twilio.conversations.ListenerException;
import com.twilio.conversations.User;
import com.twilio.conversations.internal.HandlerUtil;
import com.twilio.conversations.internal.RethrowingForwarder;
import com.twilio.util.ErrorInfo;
import com.twilio.util.TwilioLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;

public class ConversationsClientListenerForwarder
implements ConversationsClientListener {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(ConversationsClientListenerForwarder.class));
    Map<ConversationsClientListener, Handler> listeners = new ConcurrentHashMap<ConversationsClientListener, Handler>();
    private ConversationsClient.SynchronizationStatus rememberedClientSyncState = null;
    private ConversationsClient.ConnectionState rememberedClientConnectState = null;

    public void addListener(@NonNull ConversationsClientListener listener_) {
        if (listener_ == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Handler handler = HandlerUtil.setupListenerHandler();
        ConversationsClientListener listener = RethrowingForwarder.create(listener_, ListenerException.class);
        this.listeners.put(listener, handler);
        if (this.rememberedClientSyncState != null) {
            listener.onClientSynchronization(this.rememberedClientSyncState);
        }
        if (this.rememberedClientConnectState != null) {
            listener.onConnectionStateChange(this.rememberedClientConnectState);
        }
    }

    public void removeListener(@NonNull ConversationsClientListener listener_) {
        if (listener_ == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        ConversationsClientListener listener = RethrowingForwarder.create(listener_, ListenerException.class);
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void logConversation(String prefixText, Conversation conversation) {
        logger.d(prefixText + " sid|" + conversation.getSid() + "| " + conversation.hashCode());
    }

    private void notifyListeners(final ListenerNotifier notifier) {
        for (Map.Entry<ConversationsClientListener, Handler> entry : this.listeners.entrySet()) {
            final ConversationsClientListener listener = entry.getKey();
            Handler handler = entry.getValue();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    notifier.onNotify(listener);
                }
            });
        }
    }

    @Override
    public void onConversationAdded(final Conversation conversation) {
        if (conversation == null) {
            return;
        }
        this.logConversation("onConversationAdded", conversation);
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onConversationAdded(conversation);
            }
        });
    }

    @Override
    public void onConversationUpdated(final Conversation conversation, final Conversation.UpdateReason reason) {
        if (conversation == null) {
            return;
        }
        this.logConversation("onConversationUpdated", conversation);
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onConversationUpdated(conversation, reason);
            }
        });
    }

    @Override
    public void onConversationDeleted(final Conversation conversation) {
        if (conversation == null) {
            return;
        }
        this.logConversation("onConversationDeleted", conversation);
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onConversationDeleted(conversation);
            }
        });
    }

    @Override
    public void onUserUpdated(final User user, final User.UpdateReason reason) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onUserUpdated(user, reason);
            }
        });
    }

    @Override
    public void onUserSubscribed(final User user) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onUserSubscribed(user);
            }
        });
    }

    @Override
    public void onUserUnsubscribed(final User user) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onUserUnsubscribed(user);
            }
        });
    }

    @Override
    public void onError(final ErrorInfo errorInfo) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onError(errorInfo);
            }
        });
    }

    @Override
    public void onNewMessageNotification(final String conversationSid, final String messageSid, final long messageIndex) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onNewMessageNotification(conversationSid, messageSid, messageIndex);
            }
        });
    }

    @Override
    public void onAddedToConversationNotification(final String conversationId) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onAddedToConversationNotification(conversationId);
            }
        });
    }

    @Override
    public void onRemovedFromConversationNotification(final String conversationId) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onRemovedFromConversationNotification(conversationId);
            }
        });
    }

    @Override
    public void onNotificationSubscribed() {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onNotificationSubscribed();
            }
        });
    }

    @Override
    public void onNotificationFailed(final ErrorInfo errorInfo) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onNotificationFailed(errorInfo);
            }
        });
    }

    @Override
    public void onConversationSynchronizationChange(final Conversation conversation) {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onConversationSynchronizationChange(conversation);
            }
        });
    }

    @Override
    public void onClientSynchronization(final ConversationsClient.SynchronizationStatus state) {
        logger.d("Client synchronization update - " + state.toString());
        this.rememberedClientSyncState = state;
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onClientSynchronization(state);
            }
        });
    }

    @Override
    public void onConnectionStateChange(final ConversationsClient.ConnectionState state) {
        this.rememberedClientConnectState = state;
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onConnectionStateChange(state);
            }
        });
    }

    @Override
    public void onTokenExpired() {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onTokenExpired();
            }
        });
    }

    @Override
    public void onTokenAboutToExpire() {
        this.notifyListeners(new ListenerNotifier(){

            @Override
            public void onNotify(ConversationsClientListener listener) {
                listener.onTokenAboutToExpire();
            }
        });
    }

    private static interface ListenerNotifier {
        public void onNotify(ConversationsClientListener var1);
    }
}

