/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.User;
import com.twilio.conversations.internal.StatusListenerForwarder;
import com.twilio.util.TwilioLogger;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.json.JSONException;

final class UserImpl
implements User,
Disposable {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(UserImpl.class));
    private long nativeHandle;
    private boolean isDisposed = false;

    protected UserImpl(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    @Override
    public native String getFriendlyName();

    @Override
    public void setFriendlyName(String friendlyName, StatusListener listener) {
        this.checkDisposed("setFriendlyName");
        this.nativeSetFriendlyName(friendlyName, new StatusListenerForwarder(listener));
    }

    @Override
    @NonNull
    public Attributes getAttributes() {
        this.checkDisposed("getAttributes");
        String attrString = this.nativeGetAttributes();
        try {
            return Attributes.parse(attrString);
        }
        catch (JSONException e) {
            logger.e("Unable to parse user attributes", (Throwable)e);
            return Attributes.DEFAULT;
        }
    }

    @Override
    public void setAttributes(@NonNull Attributes attributes, StatusListener listener) {
        this.checkDisposed("setAttributes");
        this.nativeUpdateAttributes(attributes.toString(), new StatusListenerForwarder(listener));
    }

    @Override
    public native String getIdentity();

    @Override
    public native boolean isOnline();

    @Override
    public native boolean isNotifiable();

    @Override
    public native void unsubscribe();

    @Override
    public native boolean isSubscribed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        UserImpl userImpl = this;
        synchronized (userImpl) {
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
        }
    }

    private void checkDisposed(String method) {
        if (this.isDisposed) {
            logger.e("Attempt to use disposed object in UserInfo#" + method);
        }
    }

    private native void nativeSetFriendlyName(String var1, StatusListener var2);

    private native String nativeGetAttributes();

    private native void nativeUpdateAttributes(String var1, StatusListener var2);

    private native void nativeDispose();
}

