/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Date;

public class DetailedDeliveryReceipt {
    private final String mSid;
    private final String mMessageSid;
    private final String mConversationSid;
    private final String mChannelMessageSid;
    private final String mParticipantSid;
    private final DeliveryStatus mStatus;
    private final int mErrorCode;
    private final Date mDateCreated;
    private final Date mDateUpdated;

    DetailedDeliveryReceipt(String sid, String messageSid, String conversationSid, String channelMessageSid, String participantSid, DeliveryStatus status, int errorCode, Date dateCreated, Date dateUpdated) {
        this.mSid = sid;
        this.mMessageSid = messageSid;
        this.mConversationSid = conversationSid;
        this.mChannelMessageSid = channelMessageSid;
        this.mParticipantSid = participantSid;
        this.mStatus = status;
        this.mErrorCode = errorCode;
        this.mDateCreated = dateCreated;
        this.mDateUpdated = dateUpdated;
    }

    public String getSid() {
        return this.mSid;
    }

    public String getMessageSid() {
        return this.mMessageSid;
    }

    public String getConversationSid() {
        return this.mConversationSid;
    }

    public String getChannelMessageSid() {
        return this.mChannelMessageSid;
    }

    public String getParticipantSid() {
        return this.mParticipantSid;
    }

    public DeliveryStatus getStatus() {
        return this.mStatus;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public Date getDateCreatedAsDate() {
        return this.mDateCreated;
    }

    public Date getDateUpdatedAsDate() {
        return this.mDateUpdated;
    }

    public int hashCode() {
        int result = this.mSid != null ? this.mSid.hashCode() : 0;
        result = 31 * result + (this.mMessageSid != null ? this.mMessageSid.hashCode() : 0);
        result = 31 * result + (this.mConversationSid != null ? this.mConversationSid.hashCode() : 0);
        result = 31 * result + (this.mChannelMessageSid != null ? this.mChannelMessageSid.hashCode() : 0);
        result = 31 * result + (this.mParticipantSid != null ? this.mParticipantSid.hashCode() : 0);
        result = 31 * result + this.mErrorCode;
        result = 31 * result + (this.mDateCreated != null ? this.mDateCreated.hashCode() : 0);
        result = 31 * result + (this.mDateUpdated != null ? this.mDateUpdated.hashCode() : 0);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DetailedDeliveryReceipt)) {
            return false;
        }
        DetailedDeliveryReceipt other = (DetailedDeliveryReceipt)obj;
        return (this.mSid == other.mSid || this.mSid != null && this.mSid.equals(other.mSid)) && (this.mMessageSid == other.mMessageSid || this.mMessageSid != null && this.mMessageSid.equals(other.mMessageSid)) && (this.mConversationSid == other.mConversationSid || this.mConversationSid != null && this.mConversationSid.equals(other.mConversationSid)) && (this.mChannelMessageSid == other.mChannelMessageSid || this.mChannelMessageSid != null && this.mChannelMessageSid.equals(other.mChannelMessageSid)) && (this.mParticipantSid == other.mParticipantSid || this.mParticipantSid != null && this.mParticipantSid.equals(other.mParticipantSid)) && this.mErrorCode == other.mErrorCode && (this.mDateCreated == other.mDateCreated || this.mDateCreated != null && this.mDateCreated.equals(other.mDateCreated)) && (this.mDateUpdated == other.mDateUpdated || this.mDateUpdated != null && this.mDateUpdated.equals(other.mDateUpdated));
    }

    @NonNull
    public String toString() {
        return "DeliveryReceipt(\nsid: " + this.mSid + "\nmessageSid: " + this.mMessageSid + "\nconversationSid: " + this.mConversationSid + "\nchannelSid: " + this.mChannelMessageSid + "\nparticipantSid: " + this.mParticipantSid + "\nstatus: " + (Object)((Object)this.mStatus) + "\nerrorCode: " + this.mErrorCode + "\ndateCreated: " + this.mDateCreated + "\ndateUpdated: " + this.mDateUpdated + "\n)";
    }

    public static enum DeliveryStatus {
        READ(0),
        UNDELIVERED(1),
        DELIVERED(2),
        FAILED(3),
        SENT(4),
        QUEUED(5);

        private final int mValue;

        private DeliveryStatus(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static DeliveryStatus fromInt(int value) {
            for (DeliveryStatus status : DeliveryStatus.values()) {
                if (status.getValue() != value) continue;
                return status;
            }
            throw new IllegalStateException("Invalid value " + value + " for DeliveryReceipt.DeliveryStatus");
        }
    }
}

