/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import com.twilio.audioswitch.AudioFocusRequestWrapper;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0014H\u0007J\u0006\u0010\u001b\u001a\u00020\u0014J\b\u0010\u001c\u001a\u00020\u0014H\u0007J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0007J\b\u0010\u001f\u001a\u00020\u0017H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/twilio/audioswitch/AudioDeviceManager;", "", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioManager", "Landroid/media/AudioManager;", "build", "Lcom/twilio/audioswitch/android/BuildWrapper;", "audioFocusRequest", "Lcom/twilio/audioswitch/AudioFocusRequestWrapper;", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;Landroid/media/AudioManager;Lcom/twilio/audioswitch/android/BuildWrapper;Lcom/twilio/audioswitch/AudioFocusRequestWrapper;Landroid/media/AudioManager$OnAudioFocusChangeListener;)V", "audioRequest", "Landroid/media/AudioFocusRequest;", "savedAudioMode", "", "savedIsMicrophoneMuted", "", "savedSpeakerphoneEnabled", "cacheAudioState", "", "enableBluetoothSco", "enable", "enableSpeakerphone", "hasEarpiece", "hasSpeakerphone", "mute", "restoreAudioState", "setAudioFocus", "audioswitch_release"})
public final class AudioDeviceManager {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AudioManager audioManager;
    @NotNull
    private final BuildWrapper build;
    @NotNull
    private final AudioFocusRequestWrapper audioFocusRequest;
    @NotNull
    private final AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private int savedAudioMode;
    private boolean savedIsMicrophoneMuted;
    private boolean savedSpeakerphoneEnabled;
    @Nullable
    private AudioFocusRequest audioRequest;

    public AudioDeviceManager(@NotNull Context context, @NotNull Logger logger, @NotNull AudioManager audioManager, @NotNull BuildWrapper build, @NotNull AudioFocusRequestWrapper audioFocusRequest, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)audioFocusRequest, (String)"audioFocusRequest");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        this.context = context;
        this.logger = logger;
        this.audioManager = audioManager;
        this.build = build;
        this.audioFocusRequest = audioFocusRequest;
        this.audioFocusChangeListener = audioFocusChangeListener;
    }

    public /* synthetic */ AudioDeviceManager(Context context, Logger logger, AudioManager audioManager, BuildWrapper buildWrapper, AudioFocusRequestWrapper audioFocusRequestWrapper, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            buildWrapper = new BuildWrapper();
        }
        if ((n & 0x10) != 0) {
            audioFocusRequestWrapper = new AudioFocusRequestWrapper();
        }
        this(context, logger, audioManager, buildWrapper, audioFocusRequestWrapper, onAudioFocusChangeListener);
    }

    public final boolean hasEarpiece() {
        boolean hasEarpiece = this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
        if (hasEarpiece) {
            this.logger.d("AudioDeviceManager", "Earpiece available");
        }
        return hasEarpiece;
    }

    @SuppressLint(value={"NewApi"})
    public final boolean hasSpeakerphone() {
        boolean bl;
        if (this.build.getVersion() >= 23 && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.output")) {
            AudioDeviceInfo[] devices = this.audioManager.getDevices(2);
            Intrinsics.checkNotNullExpressionValue((Object)devices, (String)"devices");
            for (AudioDeviceInfo device : devices) {
                if (device.getType() != 2) continue;
                this.logger.d("AudioDeviceManager", "Speakerphone available");
                return true;
            }
            bl = false;
        } else {
            this.logger.d("AudioDeviceManager", "Speakerphone available");
            bl = true;
        }
        return bl;
    }

    @SuppressLint(value={"NewApi"})
    public final void setAudioFocus() {
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest = this.audioFocusRequest.buildRequest(this.audioFocusChangeListener);
            if (audioFocusRequest != null) {
                AudioFocusRequest it = audioFocusRequest;
                boolean bl = false;
                this.audioManager.requestAudioFocus(it);
            }
        } else {
            this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        }
        this.audioManager.setMode(3);
    }

    public final void enableBluetoothSco(boolean enable) {
        AudioManager $this$enableBluetoothSco_u24lambda_u2d1 = this.audioManager;
        boolean bl = false;
        if (enable) {
            $this$enableBluetoothSco_u24lambda_u2d1.startBluetoothSco();
        } else {
            $this$enableBluetoothSco_u24lambda_u2d1.stopBluetoothSco();
        }
    }

    @SuppressLint(value={"NewApi"})
    public final void enableSpeakerphone(boolean enable) {
        this.audioManager.setSpeakerphoneOn(enable);
        if (!this.audioManager.isSpeakerphoneOn()) {
            Regex regex = new Regex("^SM-G(960|99)");
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (regex.containsMatchIn((CharSequence)string)) {
                AudioDeviceInfo[] devices = this.audioManager.getDevices(2);
                Intrinsics.checkNotNullExpressionValue((Object)devices, (String)"devices");
                for (AudioDeviceInfo device : devices) {
                    if (device.getType() != 22) continue;
                    this.audioManager.setMode(0);
                    break;
                }
            }
        }
    }

    public final void mute(boolean mute) {
        this.audioManager.setMicrophoneMute(mute);
    }

    public final void cacheAudioState() {
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsMicrophoneMuted = this.audioManager.isMicrophoneMute();
        this.savedSpeakerphoneEnabled = this.audioManager.isSpeakerphoneOn();
    }

    @SuppressLint(value={"NewApi"})
    public final void restoreAudioState() {
        this.audioManager.setMode(this.savedAudioMode);
        this.mute(this.savedIsMicrophoneMuted);
        this.enableSpeakerphone(this.savedSpeakerphoneEnabled);
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest;
            if (audioFocusRequest != null) {
                AudioFocusRequest it = audioFocusRequest;
                boolean bl = false;
                this.audioManager.abandonAudioFocusRequest(it);
            }
        } else {
            this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        }
    }
}

