/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.AudioSwitch;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.PermissionsCheckStrategy;
import com.twilio.audioswitch.android.ProductionLogger;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetManager;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0014\u0018\u0000 _2\u00020\u0001:\u0004^_`aBG\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b\u00a2\u0006\u0002\u0010\u000eBu\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010J\u001a\u00020&J\u0010\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020\rH\u0002J\u0012\u0010L\u001a\u00020&2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\b\u0010O\u001a\u00020&H\u0002J\u0006\u0010P\u001a\u00020&J\u0014\u0010Q\u001a\u00020&2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010NH\u0002J\n\u0010R\u001a\u0004\u0018\u00010\u001aH\u0002J,\u0010S\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b2\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bH\u0002J\u001e\u0010T\u001a\u00020\u00072\u0014\u0010U\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bH\u0002J\r\u0010V\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bWJ\u0010\u0010X\u001a\u00020&2\b\u0010K\u001a\u0004\u0018\u00010\rJN\u0010Y\u001a\u00020&2F\u0010Z\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020&\u0018\u00010!j\u0004\u0018\u0001`'JP\u0010[\u001a\u00020&2H\b\u0002\u0010Z\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020&\u0018\u00010!j\u0004\u0018\u0001`'J\u0006\u0010\\\u001a\u00020&J\u0016\u0010]\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\u000bH\u0002R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fRZ\u0010 \u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020&\u0018\u00010!j\u0004\u0018\u0001`'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001e\u00107\u001a\u0012\u0012\u0004\u0012\u00020\r08j\b\u0012\u0004\u0012\u00020\r`9X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u00020?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0010\u0010D\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020FX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010I\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/twilio/audioswitch/AudioSwitch;", "", "context", "Landroid/content/Context;", "bluetoothHeadsetConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "loggingEnabled", "", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "preferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "(Landroid/content/Context;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;ZLandroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;)V", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "permissionsCheckStrategy", "Lcom/twilio/audioswitch/android/PermissionsCheckStrategy;", "bluetoothManager", "Landroid/bluetooth/BluetoothManager;", "bluetoothHeadsetManager", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "(Landroid/content/Context;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;Lcom/twilio/audioswitch/android/Logger;Landroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/android/PermissionsCheckStrategy;Landroid/bluetooth/BluetoothManager;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;)V", "applicationLifecycleListener", "Landroid/app/Application$ActivityLifecycleCallbacks;", "getApplicationLifecycleListener$audioswitch_release", "()Landroid/app/Application$ActivityLifecycleCallbacks;", "audioDeviceChangeListener", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "audioDevices", "selectedAudioDevice", "", "Lcom/twilio/audioswitch/AudioDeviceChangeListener;", "getAudioDeviceChangeListener$audioswitch_release", "()Lkotlin/jvm/functions/Function2;", "setAudioDeviceChangeListener$audioswitch_release", "(Lkotlin/jvm/functions/Function2;)V", "availableAudioDevices", "getAvailableAudioDevices", "()Ljava/util/List;", "bluetoothDeviceConnectionListener", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "value", "getLoggingEnabled", "()Z", "setLoggingEnabled", "(Z)V", "mutableAudioDevices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "permissionsRequestStrategy", "getSelectedAudioDevice", "()Lcom/twilio/audioswitch/AudioDevice;", "selectedDevice", "state", "Lcom/twilio/audioswitch/AudioSwitch$State;", "getState$audioswitch_release", "()Lcom/twilio/audioswitch/AudioSwitch$State;", "setState$audioswitch_release", "(Lcom/twilio/audioswitch/AudioSwitch$State;)V", "userSelectedDevice", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredHeadsetAvailable", "activate", "audioDevice", "addAvailableAudioDevices", "bluetoothHeadsetName", "", "closeListeners", "deactivate", "enumerateDevices", "getBluetoothHeadsetManager", "getPreferredDeviceList", "hasNoDuplicates", "list", "hasPermissions", "hasPermissions$audioswitch_release", "selectDevice", "setAudioDeviceChangeListener", "listener", "start", "stop", "userSelectedDevicePresent", "AudioDeviceState", "Companion", "DefaultPermissionsCheckStrategy", "State", "audioswitch_release"})
public final class AudioSwitch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private Logger logger;
    @NotNull
    private final AudioDeviceManager audioDeviceManager;
    @NotNull
    private final WiredHeadsetReceiver wiredHeadsetReceiver;
    @Nullable
    private Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> audioDeviceChangeListener;
    @Nullable
    private AudioDevice selectedDevice;
    @Nullable
    private AudioDevice userSelectedDevice;
    private boolean wiredHeadsetAvailable;
    @NotNull
    private final ArrayList<AudioDevice> mutableAudioDevices;
    @Nullable
    private BluetoothHeadsetManager bluetoothHeadsetManager;
    @NotNull
    private final List<Class<? extends AudioDevice>> preferredDeviceList;
    @Nullable
    private BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener;
    @NotNull
    private final PermissionsCheckStrategy permissionsRequestStrategy;
    @NotNull
    private State state;
    @NotNull
    private final BluetoothHeadsetConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    private final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    @NotNull
    private final Application.ActivityLifecycleCallbacks applicationLifecycleListener;
    @NotNull
    private final List<AudioDevice> availableAudioDevices;
    @NotNull
    public static final String VERSION = "1.2.2";
    @NotNull
    private static final Lazy<List<Class<? extends AudioDevice>>> defaultPreferredDeviceList$delegate = LazyKt.lazy((Function0)Companion.defaultPreferredDeviceList.2.INSTANCE);

    @Nullable
    public final Function2<List<? extends AudioDevice>, AudioDevice, Unit> getAudioDeviceChangeListener$audioswitch_release() {
        return this.audioDeviceChangeListener;
    }

    public final void setAudioDeviceChangeListener$audioswitch_release(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2) {
        this.audioDeviceChangeListener = function2;
    }

    @NotNull
    public final State getState$audioswitch_release() {
        return this.state;
    }

    public final void setState$audioswitch_release(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final BluetoothHeadsetConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    @NotNull
    public final Application.ActivityLifecycleCallbacks getApplicationLifecycleListener$audioswitch_release() {
        return this.applicationLifecycleListener;
    }

    public final boolean getLoggingEnabled() {
        return this.logger.getLoggingEnabled();
    }

    public final void setLoggingEnabled(boolean value) {
        this.logger.setLoggingEnabled(value);
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedDevice;
    }

    @NotNull
    public final List<AudioDevice> getAvailableAudioDevices() {
        return this.availableAudioDevices;
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, @Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this(context2, bluetoothHeadsetConnectionListener, new ProductionLogger(loggingEnabled), audioFocusChangeListener, preferredDeviceList, null, null, null, null, null, 992, null);
    }

    public /* synthetic */ AudioSwitch(Context context, BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, boolean bl, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bluetoothHeadsetConnectionListener = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            onAudioFocusChangeListener = AudioSwitch::_init_$lambda-0;
        }
        if ((n & 0x10) != 0) {
            list = AudioSwitch.Companion.getDefaultPreferredDeviceList();
        }
        this(context, bluetoothHeadsetConnectionListener, bl, onAudioFocusChangeListener, list);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    public AudioSwitch(@NotNull Context context, @Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, @NotNull Logger logger, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @NotNull PermissionsCheckStrategy permissionsCheckStrategy, @Nullable BluetoothManager bluetoothManager, @Nullable BluetoothHeadsetManager bluetoothHeadsetManager) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BluetoothHeadsetManager bluetoothHeadsetManager2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        Intrinsics.checkNotNullParameter((Object)permissionsCheckStrategy, (String)"permissionsCheckStrategy");
        this.logger = new ProductionLogger(false, 1, null);
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new BluetoothHeadsetConnectionListener(this){
            final /* synthetic */ AudioSwitch this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBluetoothHeadsetStateChanged(@Nullable String headsetName, int state) {
                block0: {
                    AudioSwitch.access$enumerateDevices(this.this$0, headsetName);
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = AudioSwitch.access$getBluetoothHeadsetConnectionListener$p(this.this$0);
                    if (bluetoothHeadsetConnectionListener == null) break block0;
                    bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(headsetName, state);
                }
            }

            public void onBluetoothScoStateChanged(int state) {
                block0: {
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = AudioSwitch.access$getBluetoothHeadsetConnectionListener$p(this.this$0);
                    if (bluetoothHeadsetConnectionListener == null) break block0;
                    bluetoothHeadsetConnectionListener.onBluetoothScoStateChanged(state);
                }
            }

            public void onBluetoothHeadsetActivationError() {
                block1: {
                    if (AudioSwitch.access$getUserSelectedDevice$p(this.this$0) instanceof AudioDevice.BluetoothHeadset) {
                        AudioSwitch.access$setUserSelectedDevice$p(this.this$0, null);
                    }
                    AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = AudioSwitch.access$getBluetoothHeadsetConnectionListener$p(this.this$0);
                    if (bluetoothHeadsetConnectionListener == null) break block1;
                    bluetoothHeadsetConnectionListener.onBluetoothHeadsetActivationError();
                }
            }
        };
        this.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            final /* synthetic */ AudioSwitch this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDeviceConnected() {
                AudioSwitch.access$setWiredHeadsetAvailable$p(this.this$0, true);
                AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
            }

            public void onDeviceDisconnected() {
                AudioSwitch.access$setWiredHeadsetAvailable$p(this.this$0, false);
                AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
            }
        };
        this.applicationLifecycleListener = new Application.ActivityLifecycleCallbacks(this){
            final /* synthetic */ AudioSwitch this$0;
            {
                this.this$0 = $receiver;
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (State.STOPPED == this.this$0.getState$audioswitch_release() || AudioSwitch.access$getBluetoothHeadsetManager$p(this.this$0) != null) break block1;
                    BluetoothHeadsetManager bluetoothHeadsetManager = AudioSwitch.access$getBluetoothHeadsetManager(this.this$0);
                    if (bluetoothHeadsetManager != null) {
                        bluetoothHeadsetManager.start(this.this$0.getBluetoothDeviceConnectionListener$audioswitch_release());
                    }
                }
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }
        };
        this.availableAudioDevices = this.mutableAudioDevices;
        this.context = context;
        this.logger = logger;
        this.bluetoothHeadsetConnectionListener = bluetoothHeadsetConnectionListener;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.preferredDeviceList = this.getPreferredDeviceList(preferredDeviceList);
        this.permissionsRequestStrategy = permissionsCheckStrategy;
        if (this.hasPermissions$audioswitch_release()) {
            bluetoothHeadsetManager2 = bluetoothHeadsetManager;
        } else {
            logger.w("AudioSwitch", "Bluetooth unsupported, permissions not granted");
            bluetoothHeadsetManager2 = null;
        }
        this.bluetoothHeadsetManager = bluetoothHeadsetManager2;
        logger.d("AudioSwitch", "AudioSwitch(1.2.2)");
        Iterable iterable = this.preferredDeviceList;
        String string = "AudioSwitch";
        Logger logger2 = logger;
        boolean $i$f$map = false;
        void var13_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Class clazz = (Class)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSimpleName());
        }
        collection = (List)destination$iv$iv;
        logger2.d(string, "Preferred device list = " + (List)collection);
    }

    public /* synthetic */ AudioSwitch(Context context, BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, Logger logger, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, AudioDeviceManager audioDeviceManager, WiredHeadsetReceiver wiredHeadsetReceiver, PermissionsCheckStrategy permissionsCheckStrategy, BluetoothManager bluetoothManager, BluetoothHeadsetManager bluetoothHeadsetManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            audioDeviceManager = new AudioDeviceManager(context, logger, (AudioManager)object, null, null, onAudioFocusChangeListener, 24, null);
        }
        if ((n & 0x40) != 0) {
            wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logger);
        }
        if ((n & 0x80) != 0) {
            permissionsCheckStrategy = new DefaultPermissionsCheckStrategy(context);
        }
        if ((n & 0x100) != 0) {
            Object object = context.getSystemService("bluetooth");
            BluetoothManager bluetoothManager2 = bluetoothManager = object instanceof BluetoothManager ? (BluetoothManager)object : null;
        }
        if ((n & 0x200) != 0) {
            BluetoothManager bluetoothManager3 = bluetoothManager;
            bluetoothHeadsetManager = BluetoothHeadsetManager.Companion.newInstance$audioswitch_release(context, logger, (BluetoothAdapter)(bluetoothManager3 != null ? bluetoothManager3.getAdapter() : null), audioDeviceManager);
        }
        this(context, bluetoothHeadsetConnectionListener, logger, onAudioFocusChangeListener, list, audioDeviceManager, wiredHeadsetReceiver, permissionsCheckStrategy, bluetoothManager, bluetoothHeadsetManager);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Class<? extends AudioDevice>> getPreferredDeviceList(List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        List list;
        if (!this.hasNoDuplicates(preferredDeviceList)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (preferredDeviceList.isEmpty() || Intrinsics.areEqual(preferredDeviceList, (Object)AudioSwitch.Companion.getDefaultPreferredDeviceList())) {
            list = AudioSwitch.Companion.getDefaultPreferredDeviceList();
        } else {
            void var2_4;
            List result = CollectionsKt.toMutableList((Collection)AudioSwitch.Companion.getDefaultPreferredDeviceList());
            result.removeAll((Collection)preferredDeviceList);
            Iterable $this$forEachIndexed$iv = preferredDeviceList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void device;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Class clazz = (Class)item$iv;
                int index = n;
                boolean bl = false;
                result.add(index, device);
            }
            list = var2_4;
        }
        return list;
    }

    public final void start(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener) {
        Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2 = listener;
        if (function2 != null) {
            Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> it = function2;
            boolean bl = false;
            this.audioDeviceChangeListener = it;
        }
        if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
            this.state = State.STARTED;
            AudioSwitch.enumerateDevices$default(this, null, 1, null);
            BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
            if (bluetoothHeadsetManager != null) {
                bluetoothHeadsetManager.start(this.bluetoothDeviceConnectionListener);
            }
            this.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
            Context context = this.context.getApplicationContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            ((Application)context).registerActivityLifecycleCallbacks(this.applicationLifecycleListener);
        } else {
            this.logger.d("AudioSwitch", "Redundant start() invocation while already in the started or activated state");
        }
    }

    public static /* synthetic */ void start$default(AudioSwitch audioSwitch, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            function2 = null;
        }
        audioSwitch.start((Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit>)function2);
    }

    public final void setAudioDeviceChangeListener(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener) {
        this.audioDeviceChangeListener = listener;
    }

    public final void stop() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 2: {
                this.deactivate();
                this.closeListeners();
                break;
            }
            case 3: {
                this.closeListeners();
                break;
            }
            case 1: {
                this.logger.d("AudioSwitch", "Redundant stop() invocation while already in the stopped state");
            }
        }
    }

    public final void activate() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.state = State.ACTIVATED;
                this.audioDeviceManager.cacheAudioState();
                this.audioDeviceManager.mute(false);
                this.audioDeviceManager.setAudioFocus();
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice it = audioDevice;
                    boolean bl = false;
                    this.activate(it);
                }
                break;
            }
            case 2: {
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice it = audioDevice;
                    boolean bl = false;
                    this.activate(it);
                }
                break;
            }
            case 1: {
                throw new IllegalStateException();
            }
        }
    }

    public final void deactivate() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 2: {
                this.state = State.STARTED;
                BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
                if (bluetoothHeadsetManager != null) {
                    bluetoothHeadsetManager.deactivate();
                }
                this.audioDeviceManager.restoreAudioState();
            }
        }
    }

    public final void selectDevice(@Nullable AudioDevice audioDevice) {
        if (!Intrinsics.areEqual((Object)this.selectedDevice, (Object)audioDevice)) {
            this.logger.d("AudioSwitch", "Selected AudioDevice = " + audioDevice);
            this.userSelectedDevice = audioDevice;
            AudioSwitch.enumerateDevices$default(this, null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoDuplicates(List<? extends Class<? extends AudioDevice>> list) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupingBy$iv = list;
        boolean $i$f$groupingBy = false;
        Map $this$filter$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Class<? extends AudioDevice>, Class<? extends AudioDevice>>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<Class<? extends AudioDevice>> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                Class it = (Class)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.isEmpty();
    }

    private final void activate(AudioDevice audioDevice) {
        block2: {
            AudioDevice audioDevice2;
            block3: {
                block1: {
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block1;
                    this.audioDeviceManager.enableSpeakerphone(false);
                    BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
                    if (bluetoothHeadsetManager == null) break block2;
                    bluetoothHeadsetManager.activate();
                    break block2;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece ? true : audioDevice2 instanceof AudioDevice.WiredHeadset)) break block3;
                this.audioDeviceManager.enableSpeakerphone(false);
                BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
                if (bluetoothHeadsetManager == null) break block2;
                bluetoothHeadsetManager.deactivate();
                break block2;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block2;
            this.audioDeviceManager.enableSpeakerphone(true);
            BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
            if (bluetoothHeadsetManager != null) {
                bluetoothHeadsetManager.deactivate();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void enumerateDevices(String bluetoothHeadsetName) {
        block9: {
            block7: {
                block8: {
                    block6: {
                        $this$map$iv = this.mutableAudioDevices;
                        $i$f$map = false;
                        var5_4 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var10_9 = (AudioDevice)item$iv$iv;
                            var12_11 = destination$iv$iv;
                            $i$a$-map-AudioSwitch$enumerateDevices$oldAudioDeviceState$1 = false;
                            var12_11.add(it);
                        }
                        var13_12 = this.selectedDevice;
                        var14_13 = (List)destination$iv$iv;
                        oldAudioDeviceState = new AudioDeviceState(var14_13, var13_12);
                        this.addAvailableAudioDevices(bluetoothHeadsetName);
                        if (!this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices)) {
                            this.userSelectedDevice = null;
                        }
                        this.logger.d("AudioSwitch", "Current user selected AudioDevice = " + this.userSelectedDevice);
                        if (this.userSelectedDevice == null) break block6;
                        v0 = this.userSelectedDevice;
                        break block7;
                    }
                    if (this.mutableAudioDevices.size() <= 0) break block8;
                    v1 = this.mutableAudioDevices.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"mutableAudioDevices[0]");
                    firstAudioDevice = v1;
                    if (!(firstAudioDevice instanceof AudioDevice.BluetoothHeadset)) ** GOTO lbl-1000
                    v2 = this.getBluetoothHeadsetManager();
                    v3 = v2 != null ? v2.hasActivationError() : false;
                    if (v3) {
                        v0 = this.mutableAudioDevices.get(1);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = firstAudioDevice;
                    }
                    break block7;
                }
                v0 = this.selectedDevice = (AudioDevice)null;
            }
            if (this.state == State.ACTIVATED) {
                this.activate();
            }
            if (Intrinsics.areEqual((Object)(newAudioDeviceState = new AudioDeviceState((List<? extends AudioDevice>)this.mutableAudioDevices, this.selectedDevice)), (Object)oldAudioDeviceState)) break block9;
            v4 = this.audioDeviceChangeListener;
            if (v4 != null) {
                v4.invoke(this.mutableAudioDevices, (Object)this.selectedDevice);
            }
        }
    }

    static /* synthetic */ void enumerateDevices$default(AudioSwitch audioSwitch, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        audioSwitch.enumerateDevices(string);
    }

    private final void addAvailableAudioDevices(String bluetoothHeadsetName) {
        this.mutableAudioDevices.clear();
        Iterable $this$forEach$iv = this.preferredDeviceList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class audioDevice = (Class)element$iv;
            boolean bl = false;
            Class clazz = audioDevice;
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.BluetoothHeadset.class)) {
                Object object = this.getBluetoothHeadsetManager();
                if (object != null && (object = object.getHeadset(bluetoothHeadsetName)) != null) {
                    Object it = object;
                    boolean bl2 = false;
                    this.mutableAudioDevices.add((AudioDevice)it);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.WiredHeadset.class)) {
                if (!this.wiredHeadsetAvailable) continue;
                this.mutableAudioDevices.add(new AudioDevice.WiredHeadset(null, 1, null));
                continue;
            }
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.Earpiece.class)) {
                if (!this.audioDeviceManager.hasEarpiece() || this.wiredHeadsetAvailable) continue;
                this.mutableAudioDevices.add(new AudioDevice.Earpiece(null, 1, null));
                continue;
            }
            if (!Intrinsics.areEqual((Object)clazz, AudioDevice.Speakerphone.class) || !this.audioDeviceManager.hasSpeakerphone()) continue;
            this.mutableAudioDevices.add(new AudioDevice.Speakerphone(null, 1, null));
        }
        this.logger.d("AudioSwitch", "Available AudioDevice list updated: " + this.availableAudioDevices);
    }

    private final boolean userSelectedDevicePresent(List<? extends AudioDevice> audioDevices) {
        boolean bl;
        AudioDevice audioDevice = this.userSelectedDevice;
        if (audioDevice != null) {
            AudioDevice selectedDevice = audioDevice;
            boolean bl2 = false;
            if (selectedDevice instanceof AudioDevice.BluetoothHeadset) {
                Object v1;
                block7: {
                    Iterable iterable = audioDevices;
                    for (Object t : iterable) {
                        AudioDevice it = (AudioDevice)t;
                        boolean bl3 = false;
                        if (!(it instanceof AudioDevice.BluetoothHeadset)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                AudioDevice audioDevice2 = v1;
                if (audioDevice2 != null) {
                    AudioDevice newHeadset = audioDevice2;
                    boolean bl4 = false;
                    this.userSelectedDevice = newHeadset;
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = audioDevices.contains(selectedDevice);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void closeListeners() {
        this.state = State.STOPPED;
        BluetoothHeadsetManager bluetoothHeadsetManager = this.getBluetoothHeadsetManager();
        if (bluetoothHeadsetManager != null) {
            bluetoothHeadsetManager.stop();
        }
        this.wiredHeadsetReceiver.stop();
        Context context = this.context.getApplicationContext();
        if (context == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
        }
        ((Application)context).unregisterActivityLifecycleCallbacks(this.applicationLifecycleListener);
        this.audioDeviceChangeListener = null;
    }

    private final BluetoothHeadsetManager getBluetoothHeadsetManager() {
        if (this.bluetoothHeadsetManager == null && this.hasPermissions$audioswitch_release()) {
            BluetoothManager bluetoothManager;
            Object object = this.context.getSystemService("bluetooth");
            BluetoothManager bluetoothManager2 = bluetoothManager = object instanceof BluetoothManager ? (BluetoothManager)object : null;
            this.bluetoothHeadsetManager = BluetoothHeadsetManager.Companion.newInstance$audioswitch_release(this.context, this.logger, (BluetoothAdapter)(bluetoothManager2 != null ? bluetoothManager2.getAdapter() : null), this.audioDeviceManager);
        }
        return this.bluetoothHeadsetManager;
    }

    public final boolean hasPermissions$audioswitch_release() {
        return this.permissionsRequestStrategy.hasPermissions();
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, @Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        this(context, bluetoothHeadsetConnectionListener, loggingEnabled, audioFocusChangeListener, null, 16, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, @Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, boolean loggingEnabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, bluetoothHeadsetConnectionListener, loggingEnabled, null, null, 24, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, @Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, bluetoothHeadsetConnectionListener, false, null, null, 28, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, false, null, null, 30, null);
    }

    private static final void _init_$lambda-0(int it) {
    }

    public static final /* synthetic */ void access$enumerateDevices(AudioSwitch $this, String bluetoothHeadsetName) {
        $this.enumerateDevices(bluetoothHeadsetName);
    }

    public static final /* synthetic */ BluetoothHeadsetConnectionListener access$getBluetoothHeadsetConnectionListener$p(AudioSwitch $this) {
        return $this.bluetoothHeadsetConnectionListener;
    }

    public static final /* synthetic */ AudioDevice access$getUserSelectedDevice$p(AudioSwitch $this) {
        return $this.userSelectedDevice;
    }

    public static final /* synthetic */ void access$setUserSelectedDevice$p(AudioSwitch $this, AudioDevice audioDevice) {
        $this.userSelectedDevice = audioDevice;
    }

    public static final /* synthetic */ void access$setWiredHeadsetAvailable$p(AudioSwitch $this, boolean bl) {
        $this.wiredHeadsetAvailable = bl;
    }

    public static final /* synthetic */ BluetoothHeadsetManager access$getBluetoothHeadsetManager$p(AudioSwitch $this) {
        return $this.bluetoothHeadsetManager;
    }

    public static final /* synthetic */ BluetoothHeadsetManager access$getBluetoothHeadsetManager(AudioSwitch $this) {
        return $this.getBluetoothHeadsetManager();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$State;", "", "(Ljava/lang/String;I)V", "STARTED", "ACTIVATED", "STOPPED", "audioswitch_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State ACTIVATED = new State();
        public static final /* enum */ State STOPPED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.STARTED, State.ACTIVATED, State.STOPPED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$AudioDeviceState;", "", "audioDeviceList", "", "Lcom/twilio/audioswitch/AudioDevice;", "selectedAudioDevice", "(Ljava/util/List;Lcom/twilio/audioswitch/AudioDevice;)V", "getAudioDeviceList", "()Ljava/util/List;", "getSelectedAudioDevice", "()Lcom/twilio/audioswitch/AudioDevice;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "audioswitch_release"})
    public static final class AudioDeviceState {
        @NotNull
        private final List<AudioDevice> audioDeviceList;
        @Nullable
        private final AudioDevice selectedAudioDevice;

        public AudioDeviceState(@NotNull List<? extends AudioDevice> audioDeviceList, @Nullable AudioDevice selectedAudioDevice) {
            Intrinsics.checkNotNullParameter(audioDeviceList, (String)"audioDeviceList");
            this.audioDeviceList = audioDeviceList;
            this.selectedAudioDevice = selectedAudioDevice;
        }

        @NotNull
        public final List<AudioDevice> getAudioDeviceList() {
            return this.audioDeviceList;
        }

        @Nullable
        public final AudioDevice getSelectedAudioDevice() {
            return this.selectedAudioDevice;
        }

        @NotNull
        public final List<AudioDevice> component1() {
            return this.audioDeviceList;
        }

        @Nullable
        public final AudioDevice component2() {
            return this.selectedAudioDevice;
        }

        @NotNull
        public final AudioDeviceState copy(@NotNull List<? extends AudioDevice> audioDeviceList, @Nullable AudioDevice selectedAudioDevice) {
            Intrinsics.checkNotNullParameter(audioDeviceList, (String)"audioDeviceList");
            return new AudioDeviceState(audioDeviceList, selectedAudioDevice);
        }

        public static /* synthetic */ AudioDeviceState copy$default(AudioDeviceState audioDeviceState, List list, AudioDevice audioDevice, int n, Object object) {
            if ((n & 1) != 0) {
                list = audioDeviceState.audioDeviceList;
            }
            if ((n & 2) != 0) {
                audioDevice = audioDeviceState.selectedAudioDevice;
            }
            return audioDeviceState.copy(list, audioDevice);
        }

        @NotNull
        public String toString() {
            return "AudioDeviceState(audioDeviceList=" + this.audioDeviceList + ", selectedAudioDevice=" + this.selectedAudioDevice + ")";
        }

        public int hashCode() {
            int result = ((Object)this.audioDeviceList).hashCode();
            result = result * 31 + (this.selectedAudioDevice == null ? 0 : this.selectedAudioDevice.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AudioDeviceState)) {
                return false;
            }
            AudioDeviceState audioDeviceState = (AudioDeviceState)other;
            if (!Intrinsics.areEqual(this.audioDeviceList, audioDeviceState.audioDeviceList)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.selectedAudioDevice, (Object)audioDeviceState.selectedAudioDevice);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$DefaultPermissionsCheckStrategy;", "Lcom/twilio/audioswitch/android/PermissionsCheckStrategy;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "hasPermissions", "", "audioswitch_release"})
    public static final class DefaultPermissionsCheckStrategy
    implements PermissionsCheckStrategy {
        @NotNull
        private final Context context;

        public DefaultPermissionsCheckStrategy(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public boolean hasPermissions() {
            return this.context.getApplicationInfo().targetSdkVersion <= 30 || Build.VERSION.SDK_INT <= 30 ? this.context.checkPermission("android.permission.BLUETOOTH", Process.myPid(), Process.myUid()) == 0 : this.context.checkPermission("android.permission.BLUETOOTH_CONNECT", Process.myPid(), Process.myUid()) == 0;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$Companion;", "", "()V", "VERSION", "", "defaultPreferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "getDefaultPreferredDeviceList", "()Ljava/util/List;", "defaultPreferredDeviceList$delegate", "Lkotlin/Lazy;", "audioswitch_release"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Class<? extends AudioDevice>> getDefaultPreferredDeviceList() {
            Lazy lazy = defaultPreferredDeviceList$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.STOPPED.ordinal()] = 1;
            nArray[State.ACTIVATED.ordinal()] = 2;
            nArray[State.STARTED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

