/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.selection;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessorImpl;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothController;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetReceiver;
import com.twilio.audioswitch.bluetooth.PreConnectedDeviceListener;
import com.twilio.audioswitch.selection.AudioDevice;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import com.twilio.audioswitch.selection.AudioDeviceSelector$WhenMappings;
import com.twilio.audioswitch.selection.AudioFocusRequestWrapper;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001FB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010<\u001a\u00020\u0016J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u0011H\u0002J\b\u0010>\u001a\u00020\u0016H\u0002J\u0006\u0010?\u001a\u00020\u0016J\b\u0010@\u001a\u00020\u0016H\u0002J\u0010\u0010A\u001a\u00020\u00162\b\u0010=\u001a\u0004\u0018\u00010\u0011JJ\u0010B\u001a\u00020\u00162B\u0010C\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u000fj\u0002`\u0017J\u0006\u0010D\u001a\u00020\u0016J\u0016\u0010E\u001a\u00020;2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002RZ\u0010\u000e\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000fj\u0004\u0018\u0001`\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00110+j\b\u0012\u0004\u0012\u00020\u0011`,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b-\u0010!R\u0010\u0010.\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0010\u00105\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u000207X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "audioDeviceManager", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "bluetoothController", "Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "(Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothController;)V", "audioDeviceChangeListener", "Lkotlin/Function2;", "", "Lcom/twilio/audioswitch/selection/AudioDevice;", "Lkotlin/ParameterName;", "name", "audioDevices", "selectedAudioDevice", "", "Lcom/twilio/audioswitch/selection/AudioDeviceChangeListener;", "getAudioDeviceChangeListener$audioswitch_release", "()Lkotlin/jvm/functions/Function2;", "setAudioDeviceChangeListener$audioswitch_release", "(Lkotlin/jvm/functions/Function2;)V", "availableAudioDevices", "getAvailableAudioDevices", "()Ljava/util/List;", "bluetoothAudioDevice", "getBluetoothAudioDevice", "()Lcom/twilio/audioswitch/selection/AudioDevice;", "setBluetoothAudioDevice", "(Lcom/twilio/audioswitch/selection/AudioDevice;)V", "getBluetoothController$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "bluetoothDeviceConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "mutableAudioDevices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedAudioDevice", "selectedDevice", "state", "Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "getState$audioswitch_release", "()Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "setState$audioswitch_release", "(Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;)V", "userSelectedDevice", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredHeadsetAvailable", "", "activate", "audioDevice", "closeListeners", "deactivate", "enumerateDevices", "selectDevice", "start", "listener", "stop", "userSelectedDevicePresent", "State", "audioswitch_release"})
public final class AudioDeviceSelector {
    private LogWrapper logger;
    private final AudioDeviceManager audioDeviceManager;
    private final WiredHeadsetReceiver wiredHeadsetReceiver;
    @Nullable
    private final BluetoothController bluetoothController;
    @Nullable
    private Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> audioDeviceChangeListener;
    private AudioDevice selectedDevice;
    private AudioDevice userSelectedDevice;
    private boolean wiredHeadsetAvailable;
    private final ArrayList<AudioDevice> mutableAudioDevices;
    @Nullable
    private AudioDevice bluetoothAudioDevice;
    @NotNull
    private State state;
    @NotNull
    private final BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    private final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    @NotNull
    private final List<AudioDevice> availableAudioDevices;

    @Nullable
    public final BluetoothController getBluetoothController$audioswitch_release() {
        return this.bluetoothController;
    }

    @Nullable
    public final Function2<List<? extends AudioDevice>, AudioDevice, Unit> getAudioDeviceChangeListener$audioswitch_release() {
        return this.audioDeviceChangeListener;
    }

    public final void setAudioDeviceChangeListener$audioswitch_release(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2) {
        this.audioDeviceChangeListener = function2;
    }

    @Nullable
    public final AudioDevice getBluetoothAudioDevice() {
        return this.bluetoothAudioDevice;
    }

    public final void setBluetoothAudioDevice(@Nullable AudioDevice audioDevice) {
        this.bluetoothAudioDevice = audioDevice;
    }

    @NotNull
    public final State getState$audioswitch_release() {
        return this.state;
    }

    public final void setState$audioswitch_release(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final BluetoothDeviceConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    public final void start(@NotNull Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.audioDeviceChangeListener = listener;
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                BluetoothController bluetoothController = this.bluetoothController;
                if (bluetoothController != null) {
                    bluetoothController.start(this.bluetoothDeviceConnectionListener);
                }
                this.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
                this.enumerateDevices();
                this.state = State.STARTED;
                break;
            }
            default: {
                this.logger.d("AudioDeviceSelector", "Redundant start() invocation while already in the started or activated state");
            }
        }
    }

    public final void stop() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.deactivate();
                this.closeListeners();
                break;
            }
            case 2: {
                this.closeListeners();
                break;
            }
            case 3: {
                this.logger.d("AudioDeviceSelector", "Redundant stop() invocation while already in the stopped state");
                break;
            }
        }
    }

    public final void activate() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$2[this.state.ordinal()]) {
            case 1: {
                this.audioDeviceManager.cacheAudioState();
                this.audioDeviceManager.mute(false);
                this.audioDeviceManager.setAudioFocus();
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice2 = audioDevice;
                    boolean bl = false;
                    boolean bl2 = false;
                    AudioDevice it = audioDevice2;
                    boolean bl3 = false;
                    this.activate(it);
                }
                this.state = State.ACTIVATED;
                break;
            }
            case 2: {
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice3 = audioDevice;
                    boolean bl = false;
                    boolean bl4 = false;
                    AudioDevice it = audioDevice3;
                    boolean bl5 = false;
                    this.activate(it);
                }
                break;
            }
            case 3: {
                throw (Throwable)new IllegalStateException();
            }
        }
    }

    private final void activate(AudioDevice audioDevice) {
        block2: {
            AudioDevice audioDevice2;
            block3: {
                block1: {
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block1;
                    this.audioDeviceManager.enableSpeakerphone(false);
                    BluetoothController bluetoothController = this.bluetoothController;
                    if (bluetoothController == null) break block2;
                    bluetoothController.activate();
                    break block2;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece) && !(audioDevice2 instanceof AudioDevice.WiredHeadset)) break block3;
                this.audioDeviceManager.enableSpeakerphone(false);
                BluetoothController bluetoothController = this.bluetoothController;
                if (bluetoothController == null) break block2;
                bluetoothController.deactivate();
                break block2;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block2;
            this.audioDeviceManager.enableSpeakerphone(true);
            BluetoothController bluetoothController = this.bluetoothController;
            if (bluetoothController != null) {
                bluetoothController.deactivate();
            }
        }
    }

    public final void deactivate() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$3[this.state.ordinal()]) {
            case 1: {
                BluetoothController bluetoothController = this.bluetoothController;
                if (bluetoothController != null) {
                    bluetoothController.deactivate();
                }
                this.audioDeviceManager.restoreAudioState();
                this.state = State.STARTED;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
    }

    public final void selectDevice(@Nullable AudioDevice audioDevice) {
        if (Intrinsics.areEqual((Object)this.selectedDevice, (Object)audioDevice) ^ true) {
            this.userSelectedDevice = audioDevice;
            this.enumerateDevices();
        }
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedDevice;
    }

    @NotNull
    public final List<AudioDevice> getAvailableAudioDevices() {
        return this.availableAudioDevices;
    }

    private final void enumerateDevices() {
        block8: {
            boolean bl;
            boolean bl2;
            Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2;
            this.mutableAudioDevices.clear();
            Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function22 = this.bluetoothAudioDevice;
            if (function22 != null) {
                function2 = function22;
                bl2 = false;
                bl = false;
                Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> it = function2;
                boolean bl3 = false;
                this.mutableAudioDevices.add((AudioDevice)it);
            }
            if (this.wiredHeadsetAvailable) {
                this.mutableAudioDevices.add(new AudioDevice.WiredHeadset(null, 1, null));
            }
            if (this.audioDeviceManager.hasEarpiece() && !this.wiredHeadsetAvailable) {
                this.mutableAudioDevices.add(new AudioDevice.Earpiece(null, 1, null));
            }
            if (this.audioDeviceManager.hasSpeakerphone()) {
                this.mutableAudioDevices.add(new AudioDevice.Speakerphone(null, 1, null));
            }
            if (!this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices)) {
                this.userSelectedDevice = null;
            }
            AudioDevice audioDevice = this.userSelectedDevice != null && this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices) ? this.userSelectedDevice : (this.selectedDevice = this.mutableAudioDevices.size() > 0 ? this.mutableAudioDevices.get(0) : null);
            if (this.state == State.ACTIVATED) {
                this.activate();
            }
            Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function23 = this.audioDeviceChangeListener;
            if (function23 == null) break block8;
            function2 = function23;
            bl2 = false;
            bl = false;
            Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener = function2;
            boolean bl4 = false;
            AudioDevice audioDevice2 = this.selectedDevice;
            if (audioDevice2 != null) {
                AudioDevice audioDevice3 = audioDevice2;
                boolean bl5 = false;
                boolean bl6 = false;
                AudioDevice selectedDevice = audioDevice3;
                boolean bl7 = false;
                listener.invoke(this.mutableAudioDevices, (Object)selectedDevice);
            } else {
                AudioDeviceSelector audioDeviceSelector = this;
                boolean bl8 = false;
                boolean bl9 = false;
                AudioDeviceSelector $this$run = audioDeviceSelector;
                boolean bl10 = false;
                listener.invoke($this$run.mutableAudioDevices, null);
            }
        }
    }

    private final boolean userSelectedDevicePresent(List<? extends AudioDevice> audioDevices) {
        for (AudioDevice audioDevice : audioDevices) {
            if (!Intrinsics.areEqual((Object)audioDevice, (Object)this.userSelectedDevice)) continue;
            return true;
        }
        return false;
    }

    private final void closeListeners() {
        BluetoothController bluetoothController = this.bluetoothController;
        if (bluetoothController != null) {
            bluetoothController.stop();
        }
        this.wiredHeadsetReceiver.stop();
        this.audioDeviceChangeListener = null;
        this.state = State.STOPPED;
    }

    public AudioDeviceSelector(@NotNull Context context) {
        BluetoothController bluetoothController;
        AudioDeviceSelector audioDeviceSelector;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = new LogWrapper();
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new BluetoothDeviceConnectionListener(this){
            final /* synthetic */ AudioDeviceSelector this$0;

            public void onBluetoothConnected(@NotNull BluetoothDeviceWrapper bluetoothDeviceWrapper) {
                Intrinsics.checkParameterIsNotNull((Object)bluetoothDeviceWrapper, (String)"bluetoothDeviceWrapper");
                this.this$0.setBluetoothAudioDevice(new AudioDevice.BluetoothHeadset(bluetoothDeviceWrapper.getName()));
                if (this.this$0.getState$audioswitch_release() == State.ACTIVATED) {
                    AudioDeviceSelector.access$setUserSelectedDevice$p(this.this$0, this.this$0.getBluetoothAudioDevice());
                }
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }

            public void onBluetoothDisconnected() {
                this.this$0.setBluetoothAudioDevice(null);
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }

            public void onBluetoothConnectionError(@NotNull BluetoothDeviceConnectionListener.ConnectionError error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                if (error instanceof BluetoothDeviceConnectionListener.ConnectionError.SCO_CONNECTION_ERROR) {
                    AudioDeviceSelector.access$getLogger$p(this.this$0).d("AudioDeviceSelector", "Removing the bluetooth audio device as the selected device due to a sco connection error.");
                    this.this$0.setBluetoothAudioDevice(null);
                    AudioDeviceSelector.access$enumerateDevices(this.this$0);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            final /* synthetic */ AudioDeviceSelector this$0;

            public void onDeviceConnected() {
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(this.this$0, true);
                AudioDeviceSelector.access$getLogger$p(this.this$0).d("AudioDeviceSelector", "Wired Headset available");
                if (this.this$0.getState$audioswitch_release() == State.ACTIVATED) {
                    AudioDeviceSelector.access$setUserSelectedDevice$p(this.this$0, new AudioDevice.WiredHeadset(null, 1, null));
                }
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }

            public void onDeviceDisconnected() {
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(this.this$0, false);
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.availableAudioDevices = this.mutableAudioDevices;
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        LogWrapper logger = new LogWrapper();
        AudioDeviceManager audioDeviceManager = new AudioDeviceManager(context, logger, audioManager, new BuildWrapper(), new AudioFocusRequestWrapper());
        this.logger = logger;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logger);
        AudioDeviceSelector audioDeviceSelector2 = this;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null) {
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            AudioDeviceSelector audioDeviceSelector3 = audioDeviceSelector2;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothAdapter bluetoothAdapter3 = bluetoothAdapter2;
            boolean bl3 = false;
            BluetoothController bluetoothController2 = new BluetoothController(context, bluetoothAdapter3, new PreConnectedDeviceListener(logger, bluetoothAdapter3, null, 4, null), new BluetoothHeadsetReceiver(context, logger, new BluetoothIntentProcessorImpl(), audioDeviceManager, null, null, null, 112, null));
            audioDeviceSelector = audioDeviceSelector3;
            bluetoothController = bluetoothController2;
        } else {
            AudioDeviceSelector audioDeviceSelector4 = this;
            AudioDeviceSelector audioDeviceSelector5 = audioDeviceSelector2;
            boolean bl = false;
            boolean bl4 = false;
            AudioDeviceSelector $this$run = audioDeviceSelector4;
            boolean bl5 = false;
            logger.d("AudioDeviceSelector", "Bluetooth is not supported on this device");
            Object var11_18 = null;
            audioDeviceSelector = audioDeviceSelector5;
            bluetoothController = var11_18;
        }
        audioDeviceSelector.bluetoothController = bluetoothController;
    }

    public AudioDeviceSelector(@NotNull LogWrapper logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothController bluetoothController) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        this.logger = new LogWrapper();
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        this.wiredDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        this.availableAudioDevices = this.mutableAudioDevices;
        this.logger = logger;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.bluetoothController = bluetoothController;
    }

    public static final /* synthetic */ AudioDevice access$getUserSelectedDevice$p(AudioDeviceSelector $this) {
        return $this.userSelectedDevice;
    }

    public static final /* synthetic */ void access$setUserSelectedDevice$p(AudioDeviceSelector $this, AudioDevice audioDevice) {
        $this.userSelectedDevice = audioDevice;
    }

    public static final /* synthetic */ void access$enumerateDevices(AudioDeviceSelector $this) {
        $this.enumerateDevices();
    }

    public static final /* synthetic */ LogWrapper access$getLogger$p(AudioDeviceSelector $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setLogger$p(AudioDeviceSelector $this, LogWrapper logWrapper) {
        $this.logger = logWrapper;
    }

    public static final /* synthetic */ boolean access$getWiredHeadsetAvailable$p(AudioDeviceSelector $this) {
        return $this.wiredHeadsetAvailable;
    }

    public static final /* synthetic */ void access$setWiredHeadsetAvailable$p(AudioDeviceSelector $this, boolean bl) {
        $this.wiredHeadsetAvailable = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "", "(Ljava/lang/String;I)V", "STARTED", "ACTIVATED", "STOPPED", "audioswitch_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State ACTIVATED;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = STARTED = new State();
            stateArray[1] = ACTIVATED = new State();
            stateArray[2] = STOPPED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

