/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.selection;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import com.twilio.audioswitch.selection.AudioFocusRequestWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u0000B/\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b'\u0010(J\r\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0007J\u000f\u0010\r\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0003R\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%\u00a8\u0006)"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "", "cacheAudioState", "()V", "", "enable", "enableBluetoothSco", "(Z)V", "enableSpeakerphone", "hasEarpiece", "()Z", "hasSpeakerphone", "mute", "restoreAudioState", "setAudioFocus", "Lcom/twilio/audioswitch/selection/AudioFocusRequestWrapper;", "audioFocusRequest", "Lcom/twilio/audioswitch/selection/AudioFocusRequestWrapper;", "Landroid/media/AudioManager;", "audioManager", "Landroid/media/AudioManager;", "Landroid/media/AudioFocusRequest;", "audioRequest", "Landroid/media/AudioFocusRequest;", "Lcom/twilio/audioswitch/android/BuildWrapper;", "build", "Lcom/twilio/audioswitch/android/BuildWrapper;", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lcom/twilio/audioswitch/android/LogWrapper;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "", "savedAudioMode", "I", "savedIsMicrophoneMuted", "Z", "savedSpeakerphoneEnabled", "<init>", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/LogWrapper;Landroid/media/AudioManager;Lcom/twilio/audioswitch/android/BuildWrapper;Lcom/twilio/audioswitch/selection/AudioFocusRequestWrapper;)V", "audioswitch_release"}, xs="", pn="", xi=0)
public final class AudioDeviceManager {
    public int savedAudioMode;
    public boolean savedIsMicrophoneMuted;
    public boolean savedSpeakerphoneEnabled;
    public AudioFocusRequest audioRequest;
    public final Context context;
    public final LogWrapper logger;
    public final AudioManager audioManager;
    public final BuildWrapper build;
    public final AudioFocusRequestWrapper audioFocusRequest;

    public AudioDeviceManager(@NotNull Context context, @NotNull LogWrapper logWrapper, @NotNull AudioManager audioManager, @NotNull BuildWrapper buildWrapper, @NotNull AudioFocusRequestWrapper audioFocusRequestWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logWrapper, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioManager, (String)"audioManager");
        Intrinsics.checkParameterIsNotNull((Object)buildWrapper, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)audioFocusRequestWrapper, (String)"audioFocusRequest");
        this.context = context;
        this.logger = logWrapper;
        this.audioManager = audioManager;
        this.build = buildWrapper;
        this.audioFocusRequest = audioFocusRequestWrapper;
    }

    public final boolean hasEarpiece() {
        boolean bl = this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
        if (bl) {
            this.logger.d("AudioDeviceManager", "Earpiece available");
        }
        return bl;
    }

    @SuppressLint(value={"NewApi"})
    public final boolean hasSpeakerphone() {
        boolean bl;
        if (this.build.getVersion() >= 23 && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.output")) {
            for (AudioDeviceInfo audioDeviceInfo : this.audioManager.getDevices(2)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceInfo, (String)"device");
                if (audioDeviceInfo.getType() != 2) continue;
                this.logger.d("AudioDeviceManager", "Speakerphone available");
                return true;
            }
            bl = false;
        } else {
            this.logger.d("AudioDeviceManager", "Speakerphone available");
            bl = true;
        }
        return bl;
    }

    @SuppressLint(value={"NewApi"})
    public final void setAudioFocus() {
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest;
            this.audioRequest = audioFocusRequest = this.audioFocusRequest.buildRequest();
            if (audioFocusRequest != null) {
                this.audioManager.requestAudioFocus(audioFocusRequest);
            }
        } else {
            this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)setAudioFocus.2.INSTANCE, 0, 2);
        }
        this.audioManager.setMode(3);
    }

    public final void enableBluetoothSco(boolean bl) {
        AudioDeviceManager audioDeviceManager = audioDeviceManager.audioManager;
        if (bl) {
            audioDeviceManager.startBluetoothSco();
        } else {
            audioDeviceManager.stopBluetoothSco();
        }
    }

    public final void enableSpeakerphone(boolean bl) {
        this.audioManager.setSpeakerphoneOn(bl);
    }

    public final void mute(boolean bl) {
        this.audioManager.setMicrophoneMute(bl);
    }

    public final void cacheAudioState() {
        AudioDeviceManager audioDeviceManager = this;
        audioDeviceManager.savedAudioMode = audioDeviceManager.audioManager.getMode();
        audioDeviceManager.savedIsMicrophoneMuted = audioDeviceManager.audioManager.isMicrophoneMute();
        audioDeviceManager.savedSpeakerphoneEnabled = audioDeviceManager.audioManager.isSpeakerphoneOn();
    }

    @SuppressLint(value={"NewApi"})
    public final void restoreAudioState() {
        AudioDeviceManager audioDeviceManager = this;
        audioDeviceManager.audioManager.setMode(this.savedAudioMode);
        audioDeviceManager.mute(audioDeviceManager.savedIsMicrophoneMuted);
        audioDeviceManager.enableSpeakerphone(audioDeviceManager.savedSpeakerphoneEnabled);
        if (audioDeviceManager.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest;
            if (audioFocusRequest != null) {
                this.audioManager.abandonAudioFocusRequest(audioFocusRequest);
            }
        } else {
            this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)restoreAudioState.2.INSTANCE);
        }
    }
}

