/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.android.SystemClockWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000:\u0001(B\u001f\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b&\u0010'J\r\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0003R\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R,\u0010\t\u001a\u00060\bR\u00020\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\t\u0010\n\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR*\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b8$@$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010%\u001a\u00020\"8$@$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006)"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "", "cancelBluetoothScoJob", "()V", "executeBluetoothScoJob", "Landroid/os/Handler;", "bluetoothScoHandler", "Landroid/os/Handler;", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "bluetoothScoRunnable", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "getBluetoothScoRunnable", "()Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "setBluetoothScoRunnable", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;)V", "bluetoothScoRunnable$annotations", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "deviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "getDeviceListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "setDeviceListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "deviceListener$annotations", "Lcom/twilio/audioswitch/android/LogWrapper;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "Lkotlin/Function0;", "getScoAction", "()Lkotlin/jvm/functions/Function0;", "scoAction", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener$ConnectionError;", "getTimeoutError", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener$ConnectionError;", "timeoutError", "<init>", "(Lcom/twilio/audioswitch/android/LogWrapper;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "BluetoothScoRunnable", "audioswitch_release"}, xs="", pn="", xi=0)
public abstract class BluetoothScoJob {
    @NotNull
    public BluetoothScoRunnable bluetoothScoRunnable;
    @Nullable
    public BluetoothDeviceConnectionListener deviceListener;
    public final LogWrapper logger;
    public final Handler bluetoothScoHandler;
    public final SystemClockWrapper systemClockWrapper;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void bluetoothScoRunnable$annotations() {
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void deviceListener$annotations() {
    }

    public BluetoothScoJob(@NotNull LogWrapper object, @NotNull Handler handler, @NotNull SystemClockWrapper systemClockWrapper) {
        BluetoothScoRunnable bluetoothScoRunnable;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"bluetoothScoHandler");
        Intrinsics.checkParameterIsNotNull((Object)systemClockWrapper, (String)"systemClockWrapper");
        this.logger = object;
        this.bluetoothScoHandler = handler;
        this.systemClockWrapper = systemClockWrapper;
        object = bluetoothScoRunnable;
        bluetoothScoRunnable = new BluetoothScoRunnable();
        this.bluetoothScoRunnable = object;
    }

    @NotNull
    public final BluetoothScoRunnable getBluetoothScoRunnable() {
        return this.bluetoothScoRunnable;
    }

    public final void setBluetoothScoRunnable(@NotNull BluetoothScoRunnable bluetoothScoRunnable) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothScoRunnable, (String)"<set-?>");
        this.bluetoothScoRunnable = bluetoothScoRunnable;
    }

    @Nullable
    public final BluetoothDeviceConnectionListener getDeviceListener() {
        return this.deviceListener;
    }

    public final void setDeviceListener(@Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }

    @NotNull
    public abstract Function0<Unit> getScoAction();

    @NotNull
    public abstract BluetoothDeviceConnectionListener.ConnectionError getTimeoutError();

    public final void executeBluetoothScoJob() {
        BluetoothScoRunnable bluetoothScoRunnable;
        BluetoothScoJob bluetoothScoJob = this;
        BluetoothScoRunnable bluetoothScoRunnable2 = bluetoothScoRunnable;
        bluetoothScoJob.bluetoothScoRunnable = new BluetoothScoRunnable();
        bluetoothScoJob.bluetoothScoHandler.post((Runnable)bluetoothScoRunnable2);
        bluetoothScoJob.logger.d("BluetoothScoManager", "Scheduled bluetooth sco job");
    }

    public final void cancelBluetoothScoJob() {
        BluetoothScoJob bluetoothScoJob = this;
        bluetoothScoJob.bluetoothScoHandler.removeCallbacks((Runnable)this.bluetoothScoRunnable);
        bluetoothScoJob.logger.d("BluetoothScoManager", "Canceled bluetooth sco job");
    }

    @Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "Ljava/lang/Runnable;", "", "run", "()V", "", "elapsedTime", "J", "startTime", "<init>", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;)V", "audioswitch_release"}, xs="", pn="", xi=0)
    public final class BluetoothScoRunnable
    implements Runnable {
        public final long startTime;
        public long elapsedTime;

        public BluetoothScoRunnable() {
            this.startTime = BluetoothScoJob.this.systemClockWrapper.elapsedRealtime();
        }

        @Override
        public void run() {
            if (this.elapsedTime < 5000L) {
                BluetoothScoRunnable bluetoothScoRunnable = this;
                bluetoothScoRunnable.BluetoothScoJob.this.logger.d("BluetoothScoManager", "Invoking bluetooth sco action");
                bluetoothScoRunnable.BluetoothScoJob.this.getScoAction().invoke();
                bluetoothScoRunnable.elapsedTime = bluetoothScoRunnable.BluetoothScoJob.this.systemClockWrapper.elapsedRealtime() - this.startTime;
                bluetoothScoRunnable.BluetoothScoJob.this.bluetoothScoHandler.postDelayed((Runnable)this, 500L);
            } else {
                TimeoutException timeoutException;
                BluetoothScoRunnable bluetoothScoRunnable = this;
                Object object = timeoutException;
                timeoutException = new TimeoutException();
                bluetoothScoRunnable.BluetoothScoJob.this.logger.e("BluetoothScoManager", "Bluetooth sco job timed out", (Throwable)object);
                object = bluetoothScoRunnable.BluetoothScoJob.this.getDeviceListener();
                if (object != null) {
                    object.onBluetoothConnectionError(BluetoothScoJob.this.getTimeoutError());
                }
                BluetoothScoJob.this.cancelBluetoothScoJob();
            }
        }
    }
}

