/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessor;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothScoJob;
import com.twilio.audioswitch.bluetooth.DisableBluetoothScoJob;
import com.twilio.audioswitch.bluetooth.EnableBluetoothScoJob;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\u0006\u0010)\u001a\u00020(\u0012\b\b\u0002\u0010$\u001a\u00020!\u0012\b\b\u0002\u0010\"\u001a\u00020!\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0007*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001cR$\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u0014R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020!8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetReceiver;", "Landroid/content/BroadcastReceiver;", "", "enable", "", "enableBluetoothSco", "(Z)V", "Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "deviceWrapper", "isHeadsetDevice", "(Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;)Z", "Landroid/content/Context;", "context", "Landroid/content/Intent;", "intent", "onReceive", "(Landroid/content/Context;Landroid/content/Intent;)V", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "deviceListener", "setupDeviceListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "stop", "()V", "getHeadsetDevice", "(Landroid/content/Intent;)Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "bluetoothIntentProcessor", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "Landroid/content/Context;", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "getDeviceListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "setDeviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "disableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "enableBluetoothScoJob", "Lcom/twilio/audioswitch/android/LogWrapper;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "audioDeviceManager", "<init>", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "audioswitch_release"}, xs="", pn="", xi=0)
public final class BluetoothHeadsetReceiver
extends BroadcastReceiver {
    public final Context context;
    public final LogWrapper logger;
    public final BluetoothIntentProcessor bluetoothIntentProcessor;
    public final BluetoothScoJob enableBluetoothScoJob;
    public final BluetoothScoJob disableBluetoothScoJob;
    @Nullable
    public BluetoothDeviceConnectionListener deviceListener;

    private final BluetoothDeviceWrapper getHeadsetDevice(@NotNull Intent object) {
        if ((object = this.bluetoothIntentProcessor.getBluetoothDevice((Intent)object)) == null || !this.isHeadsetDevice((BluetoothDeviceWrapper)object)) {
            object = null;
        }
        return object;
    }

    private final boolean isHeadsetDevice(BluetoothDeviceWrapper bluetoothDeviceWrapper) {
        int n;
        Integer n2 = bluetoothDeviceWrapper.getDeviceClass();
        n = n2 != null && ((n = ((Number)n2).intValue()) == 1032 || n == 1028 || n == 1056 || n == 1048 || n == 7936) ? 1 : 0;
        return n != 0;
    }

    public BluetoothHeadsetReceiver(@NotNull Context context, @NotNull LogWrapper logWrapper, @NotNull BluetoothIntentProcessor bluetoothIntentProcessor, @NotNull AudioDeviceManager audioDeviceManager, @NotNull BluetoothScoJob bluetoothScoJob, @NotNull BluetoothScoJob bluetoothScoJob2, @Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logWrapper, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothIntentProcessor, (String)"bluetoothIntentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothScoJob, (String)"enableBluetoothScoJob");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothScoJob2, (String)"disableBluetoothScoJob");
        this.context = context;
        this.logger = logWrapper;
        this.bluetoothIntentProcessor = bluetoothIntentProcessor;
        this.enableBluetoothScoJob = bluetoothScoJob;
        this.disableBluetoothScoJob = bluetoothScoJob2;
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }

    public /* synthetic */ BluetoothHeadsetReceiver(Context context, LogWrapper logWrapper, BluetoothIntentProcessor bluetoothIntentProcessor, AudioDeviceManager audioDeviceManager, BluetoothScoJob bluetoothScoJob, BluetoothScoJob bluetoothScoJob2, BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            EnableBluetoothScoJob enableBluetoothScoJob;
            bluetoothScoJob = enableBluetoothScoJob;
            enableBluetoothScoJob = new EnableBluetoothScoJob(logWrapper, audioDeviceManager, null, null, 12, null);
        }
        if ((n & 0x20) != 0) {
            DisableBluetoothScoJob disableBluetoothScoJob;
            bluetoothScoJob2 = disableBluetoothScoJob;
            disableBluetoothScoJob = new DisableBluetoothScoJob(logWrapper, audioDeviceManager, null, null, 12, null);
        }
        if ((n & 0x40) != 0) {
            bluetoothDeviceConnectionListener2 = null;
        }
        this(context, logWrapper, bluetoothIntentProcessor, audioDeviceManager, bluetoothScoJob, bluetoothScoJob2, bluetoothDeviceConnectionListener2);
    }

    public void onReceive(@NotNull Context object, @NotNull Intent intent) {
        Intent intent2 = intent;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent2, (String)"intent");
        object = intent2.getAction();
        if (object != null) {
            int n = ((String)object).hashCode();
            if (n != -1692127708) {
                Object object2;
                if (n != -301431627) {
                    if (n == 1821585647 && ((String)object).equals("android.bluetooth.device.action.ACL_DISCONNECTED") && (object = ((BluetoothHeadsetReceiver)((Object)object2)).getHeadsetDevice(intent)) != null) {
                        BluetoothHeadsetReceiver bluetoothHeadsetReceiver = object2;
                        bluetoothHeadsetReceiver.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + object.getName() + " disconnected");
                        object2 = bluetoothHeadsetReceiver.deviceListener;
                        if (object2 != null) {
                            object2.onBluetoothDisconnected();
                        }
                    }
                } else if (((String)object).equals("android.bluetooth.device.action.ACL_CONNECTED") && (object = ((BluetoothHeadsetReceiver)((Object)object2)).getHeadsetDevice(intent)) != null) {
                    BluetoothHeadsetReceiver bluetoothHeadsetReceiver = object2;
                    bluetoothHeadsetReceiver.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + object.getName() + " connected");
                    object2 = bluetoothHeadsetReceiver.deviceListener;
                    if (object2 != null) {
                        object2.onBluetoothConnected((BluetoothDeviceWrapper)object);
                    }
                }
            } else if (((String)object).equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                int n2 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                if (n2 != -1) {
                    if (n2 != 0) {
                        if (n2 == 1) {
                            BluetoothHeadsetReceiver bluetoothHeadsetReceiver = object2;
                            bluetoothHeadsetReceiver.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio connected");
                            bluetoothHeadsetReceiver.enableBluetoothScoJob.cancelBluetoothScoJob();
                        }
                    } else {
                        BluetoothHeadsetReceiver bluetoothHeadsetReceiver = object2;
                        bluetoothHeadsetReceiver.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio disconnected");
                        bluetoothHeadsetReceiver.disableBluetoothScoJob.cancelBluetoothScoJob();
                    }
                } else {
                    ((BluetoothHeadsetReceiver)((Object)object2)).logger.e("BluetoothDeviceReceiver", "Error retrieving Bluetooth SCO Audio state");
                }
            }
        }
    }

    public final void enableBluetoothSco(boolean bl) {
        if (bl) {
            this.enableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.disableBluetoothScoJob.executeBluetoothScoJob();
        }
    }

    public final void setupDeviceListener(@NotNull BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        BluetoothHeadsetReceiver bluetoothHeadsetReceiver = this;
        BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener3 = bluetoothDeviceConnectionListener2;
        Intrinsics.checkParameterIsNotNull((Object)bluetoothDeviceConnectionListener3, (String)"deviceListener");
        bluetoothHeadsetReceiver.deviceListener = bluetoothDeviceConnectionListener3;
        bluetoothHeadsetReceiver.enableBluetoothScoJob.setDeviceListener(bluetoothDeviceConnectionListener2);
        bluetoothHeadsetReceiver.disableBluetoothScoJob.setDeviceListener(bluetoothDeviceConnectionListener2);
    }

    public final void stop() {
        BluetoothHeadsetReceiver bluetoothHeadsetReceiver = this;
        bluetoothHeadsetReceiver.deviceListener = null;
        bluetoothHeadsetReceiver.enableBluetoothScoJob.setDeviceListener(null);
        bluetoothHeadsetReceiver.disableBluetoothScoJob.setDeviceListener(null);
        bluetoothHeadsetReceiver.context.unregisterReceiver((BroadcastReceiver)this);
    }

    @Nullable
    public final BluetoothDeviceConnectionListener getDeviceListener() {
        return this.deviceListener;
    }

    public final void setDeviceListener(@Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }
}

