/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import java.io.EOFException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public final class LSBBitReader {
    private final ImageInputStream imageInput;
    private int bitOffset = 64;
    private long streamPosition = -1L;
    private long buffer;

    public LSBBitReader(ImageInputStream imageInputStream) {
        this.imageInput = imageInputStream;
    }

    public long readBits(int n) throws IOException {
        return this.readBits(n, false);
    }

    public long peekBits(int n) throws IOException {
        if (n > 56) {
            throw new IllegalArgumentException("Tried peeking over 56");
        }
        return this.readBits(n, true);
    }

    private long readBits(int n, boolean bl) throws IOException {
        if (n <= 56) {
            long l = this.imageInput.getStreamPosition();
            if (this.streamPosition != l) {
                this.resetBuffer();
            }
            long l2 = this.buffer >>> this.bitOffset & (1L << n) - 1L;
            if (!bl) {
                this.bitOffset += n;
                this.refillBuffer();
            }
            return l2;
        }
        long l = this.readBits(56);
        return this.readBits(n - 56) << 56 | l;
    }

    private void refillBuffer() throws IOException {
        this.imageInput.seek(this.streamPosition + 8L);
        while (this.bitOffset >= 8) {
            try {
                byte by = this.imageInput.readByte();
                this.buffer >>>= 8;
                ++this.streamPosition;
                this.buffer |= (long)by << 56;
            }
            catch (EOFException eOFException) {
                this.imageInput.seek(this.streamPosition);
                return;
            }
            this.bitOffset -= 8;
        }
        this.imageInput.seek(this.streamPosition);
    }

    private void resetBuffer() throws IOException {
        long l = this.imageInput.getStreamPosition();
        try {
            this.buffer = this.imageInput.readLong();
            this.bitOffset = 0;
            this.streamPosition = l;
            this.imageInput.seek(l);
        }
        catch (EOFException eOFException) {
            this.streamPosition = l - 8L;
            this.bitOffset = 64;
            this.refillBuffer();
        }
    }

    public int readBit() throws IOException {
        return (int)this.readBits(1);
    }
}

