/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFWriter;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;
import com.twelvemonkeys.imageio.plugins.tiff.CCITTFaxEncoderStream;
import com.twelvemonkeys.imageio.plugins.tiff.HorizontalDifferencingStream;
import com.twelvemonkeys.imageio.plugins.tiff.LZWEncoder;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageWriteParam;
import com.twelvemonkeys.imageio.stream.SubImageOutputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import com.twelvemonkeys.lang.Validate;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class TIFFImageWriter
extends ImageWriterBase {
    public static final Rational STANDARD_DPI = new Rational(72L);
    private boolean isWritingSequence = false;
    private EXIFWriter sequenceExifWriter = null;
    private long sequenceLastIFDPos = -1L;

    TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        EXIFWriter eXIFWriter = new EXIFWriter();
        eXIFWriter.writeTIFFHeader(this.imageOutput);
        this.writePage(iIOImage, imageWriteParam, eXIFWriter, this.imageOutput.getStreamPosition());
        this.imageOutput.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writePage(IIOImage iIOImage, ImageWriteParam imageWriteParam, EXIFWriter eXIFWriter, long l) throws IOException {
        long l2;
        long iterator;
        long l3;
        int[] nArray;
        Object object2;
        int[] nArray2;
        int[] nArray3;
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        TIFFImageMetadata tIFFImageMetadata = iIOImage.getMetadata() != null ? this.convertImageMetadata(iIOImage.getMetadata(), ImageTypeSpecifier.createFromRenderedImage(renderedImage), imageWriteParam) : this.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(renderedImage), imageWriteParam);
        ColorModel colorModel = renderedImage.getColorModel();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        int n2 = this.computePixelSize(sampleModel);
        if (sampleModel instanceof ComponentSampleModel) {
            nArray3 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            nArray2 = null;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            nArray2 = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            nArray3 = null;
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            nArray2 = null;
            nArray3 = new int[]{0};
        } else {
            throw new IllegalArgumentException("Unknown bit/bandOffsets for sample model: " + sampleModel);
        }
        LinkedHashMap<Integer, Entry> linkedHashMap = new LinkedHashMap<Integer, Entry>();
        linkedHashMap.put(256, (Entry)new TIFFEntry(256, renderedImage.getWidth()));
        linkedHashMap.put(257, (Entry)new TIFFEntry(257, renderedImage.getHeight()));
        linkedHashMap.put(274, (Entry)new TIFFEntry(274, 1));
        linkedHashMap.put(258, (Entry)new TIFFEntry(258, this.asShortArray(sampleModel.getSampleSize())));
        if (n > colorModel.getNumColorComponents()) {
            if (colorModel.hasAlpha()) {
                linkedHashMap.put(338, (Entry)new TIFFEntry(338, colorModel.isAlphaPremultiplied() ? 1 : 2));
            } else {
                linkedHashMap.put(338, (Entry)new TIFFEntry(338, 0));
            }
        }
        int n3 = (imageWriteParam == null || imageWriteParam.getCompressionMode() == 3) && iIOImage.getMetadata() != null && tIFFImageMetadata.getIFD().getEntryById((Object)259) != null ? (Integer)tIFFImageMetadata.getIFD().getEntryById((Object)259).getValue() : TIFFImageWriteParam.getCompressionType(imageWriteParam);
        linkedHashMap.put(259, (Entry)new TIFFEntry(259, n3));
        switch (n3) {
            case 5: 
            case 8: 
            case 32946: {
                if (n2 < 8) break;
                linkedHashMap.put(317, (Entry)new TIFFEntry(317, 2));
                break;
            }
            case 3: {
                Object object3 = tIFFImageMetadata.getIFD().getEntryById((Object)292);
                if (object3 == null) {
                    object3 = new TIFFEntry(292, 1L);
                }
                linkedHashMap.put(292, (Entry)object3);
                break;
            }
            case 4: {
                object2 = tIFFImageMetadata.getIFD().getEntryById((Object)293);
                if (object2 == null) {
                    object2 = new TIFFEntry(293, 0L);
                }
                linkedHashMap.put(293, (Entry)object2);
                break;
            }
        }
        int n4 = n3 == 7 ? 6 : this.getPhotometricInterpretation(colorModel);
        linkedHashMap.put(262, (Entry)new TIFFEntry(262, n4));
        if (n4 == 3 && colorModel instanceof IndexColorModel) {
            linkedHashMap.put(320, (Entry)new TIFFEntry(320, this.createColorMap((IndexColorModel)colorModel)));
            linkedHashMap.put(277, (Entry)new TIFFEntry(277, 1));
        } else {
            linkedHashMap.put(277, (Entry)new TIFFEntry(277, n));
            object2 = colorModel.getColorSpace();
            if (object2 instanceof ICC_ColorSpace && !((ColorSpace)object2).isCS_sRGB()) {
                linkedHashMap.put(34675, (Entry)new TIFFEntry(34675, ((ICC_ColorSpace)object2).getProfile().getData()));
            }
        }
        if (sampleModel.getDataType() == 2) {
            linkedHashMap.put(339, (Entry)new TIFFEntry(339, 2));
        }
        object2 = tIFFImageMetadata.getIFD().getEntryById((Object)305);
        linkedHashMap.put(305, (Entry)(object2 != null ? object2 : new TIFFEntry(305, "TwelveMonkeys ImageIO TIFF writer " + this.originatingProvider.getVersion())));
        for (int l5 : nArray = new int[]{274, 306, 269, 270, 271, 272, 285, 297, 315, 316, 33432}) {
            Entry entry = tIFFImageMetadata.getIFD().getEntryById((Object)l5);
            if (entry == null) continue;
            linkedHashMap.put(l5, entry);
        }
        Entry entry = tIFFImageMetadata.getIFD().getEntryById((Object)282);
        linkedHashMap.put(282, (Entry)(entry != null ? entry : new TIFFEntry(282, STANDARD_DPI)));
        Entry entry2 = tIFFImageMetadata.getIFD().getEntryById((Object)283);
        linkedHashMap.put(283, (Entry)(entry2 != null ? entry2 : new TIFFEntry(283, STANDARD_DPI)));
        Entry entry3 = tIFFImageMetadata.getIFD().getEntryById((Object)296);
        linkedHashMap.put(296, (Entry)(entry3 != null ? entry3 : new TIFFEntry(296, 2)));
        linkedHashMap.put(278, (Entry)new TIFFEntry(278, renderedImage.getHeight()));
        linkedHashMap.put(279, (Entry)new TIFFEntry(279, -1));
        linkedHashMap.put(273, (Entry)new TIFFEntry(273, -1));
        long l4 = -1L;
        if (n3 == 1) {
            l3 = this.imageOutput.getStreamPosition();
            iterator = eXIFWriter.computeIFDSize(linkedHashMap.values());
            l2 = l3 + 4L + iterator + 4L;
            long l5 = (renderedImage.getWidth() * renderedImage.getHeight() * n2 + 7) / 8;
            linkedHashMap.put(273, (Entry)new TIFFEntry(273, l2));
            linkedHashMap.put(279, (Entry)new TIFFEntry(279, l5));
            long l6 = eXIFWriter.writeIFD(linkedHashMap.values(), this.imageOutput);
            l4 = this.imageOutput.getStreamPosition();
            if (l3 > l) {
                this.imageOutput.seek(l);
                this.imageOutput.writeInt((int)l6);
                this.imageOutput.seek(l4);
            }
            this.imageOutput.writeInt(0);
        } else {
            this.imageOutput.writeInt(0);
        }
        l3 = this.imageOutput.getStreamPosition();
        if (n3 == 7) {
            Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName("JPEG");
            if (!iterator2.hasNext()) {
                throw new IIOException("No JPEG ImageWriter found!");
            }
            ImageWriter imageWriter = iterator2.next();
            try {
                imageWriter.setOutput(new SubImageOutputStream(this.imageOutput));
                imageWriter.write(renderedImage);
            }
            finally {
                imageWriter.dispose();
            }
        } else {
            this.writeImageData(this.createCompressorStream(renderedImage, imageWriteParam, linkedHashMap), renderedImage, n, nArray3, nArray2);
        }
        iterator = this.imageOutput.getStreamPosition() - l3;
        if (n3 != 1) {
            linkedHashMap.put(273, (Entry)new TIFFEntry(273, l3));
            linkedHashMap.put(279, (Entry)new TIFFEntry(279, iterator));
            l2 = eXIFWriter.writeIFD(linkedHashMap.values(), this.imageOutput);
            l4 = this.imageOutput.getStreamPosition();
            this.imageOutput.seek(l);
            this.imageOutput.writeInt((int)l2);
            this.imageOutput.seek(l4);
            this.imageOutput.writeInt(0);
        }
        return l4;
    }

    private int computePixelSize(SampleModel sampleModel) {
        int n = 0;
        for (int i = 0; i < sampleModel.getNumBands(); ++i) {
            n += sampleModel.getSampleSize(i);
        }
        return n;
    }

    private DataOutput createCompressorStream(RenderedImage renderedImage, ImageWriteParam imageWriteParam, Map<Integer, Entry> map) {
        int n = (Integer)map.get(259).getValue();
        switch (n) {
            case 1: {
                return this.imageOutput;
            }
            case 32773: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new PackBitsEncoder(), true);
                return new DataOutputStream(outputStream);
            }
            case 8: 
            case 32946: {
                int n2 = 1;
                if (imageWriteParam.getCompressionMode() == 2) {
                    n2 = 9 - Math.round(8.0f * imageWriteParam.getCompressionQuality());
                }
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new DeflaterOutputStream(outputStream, new Deflater(n2), 1024);
                if (map.containsKey(317) && map.get(317).getValue().equals(2)) {
                    outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                }
                return new DataOutputStream(outputStream);
            }
            case 5: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new LZWEncoder((renderedImage.getTileWidth() * renderedImage.getTileHeight() * renderedImage.getColorModel().getPixelSize() + 7) / 8));
                if (map.containsKey(317) && map.get(317).getValue().equals(2)) {
                    outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                }
                return new DataOutputStream(outputStream);
            }
            case 2: 
            case 3: 
            case 4: {
                Entry entry;
                long l = 0L;
                if (n != 2) {
                    l = (Long)map.get(n == 3 ? 292 : 293).getValue();
                }
                int n3 = (Integer)((entry = map.get(266)) != null ? entry.getValue() : Integer.valueOf(1));
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new CCITTFaxEncoderStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTileHeight(), n, n3, l);
                return new DataOutputStream(outputStream);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported TIFF compression: %d", n));
    }

    private int getPhotometricInterpretation(ColorModel colorModel) {
        if (colorModel.getPixelSize() == 1) {
            if (colorModel instanceof IndexColorModel) {
                if (colorModel.getRGB(0) == -1 && colorModel.getRGB(1) == -16777216) {
                    return 0;
                }
                if (colorModel.getRGB(0) != -16777216 || colorModel.getRGB(1) != -1) {
                    return 3;
                }
            }
            return 1;
        }
        if (colorModel instanceof IndexColorModel) {
            return 3;
        }
        switch (colorModel.getColorSpace().getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 9: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Can't determine PhotometricInterpretation for color model: " + colorModel);
    }

    private short[] createColorMap(IndexColorModel indexColorModel) {
        short[] sArray = new short[(int)(3.0 * Math.pow(2.0, indexColorModel.getPixelSize()))];
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            int n = indexColorModel.getRGB(i);
            sArray[i] = (short)this.upScale(n >> 16 & 0xFF);
            sArray[i + sArray.length / 3] = (short)this.upScale(n >> 8 & 0xFF);
            sArray[i + 2 * sArray.length / 3] = (short)this.upScale(n & 0xFF);
        }
        return sArray;
    }

    private int upScale(int n) {
        return 257 * n;
    }

    private short[] asShortArray(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    private void writeImageData(DataOutput dataOutput, RenderedImage renderedImage, int n, int[] nArray, int[] nArray2) throws IOException {
        this.processImageStarted(0);
        int n2 = renderedImage.getMinTileY();
        int n3 = n2 + renderedImage.getNumYTiles();
        int n4 = renderedImage.getMinTileX();
        int n5 = n4 + renderedImage.getNumXTiles();
        int n6 = renderedImage.getTileHeight();
        int n7 = renderedImage.getTileWidth();
        int n8 = renderedImage.getSampleModel().getSampleSize(0);
        int n9 = renderedImage.getSampleModel().getNumBands();
        ByteBuffer byteBuffer = ByteBuffer.allocate((n7 * n9 * n8 + 7) / 8);
        for (int i = n2; i < n3; ++i) {
            block6: for (int j = n4; j < n5; ++j) {
                Raster raster = renderedImage.getTile(j, i);
                int n10 = raster.getMinX() - raster.getSampleModelTranslateX();
                int n11 = raster.getMinY() - raster.getSampleModelTranslateY();
                int n12 = (raster.getSampleModel().getWidth() * n8 + 7) / 8;
                DataBuffer dataBuffer = raster.getDataBuffer();
                switch (dataBuffer.getDataType()) {
                    case 0: {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18 = (n7 * n8 + 7) / 8;
                        int n19 = n10 % 8;
                        WritableRaster writableRaster = n19 != 0 ? raster.createCompatibleWritableRaster(raster.getWidth(), 1) : null;
                        DataBuffer dataBuffer2 = n19 != 0 ? writableRaster.getDataBuffer() : null;
                        for (n17 = 0; n17 < dataBuffer.getNumBanks(); ++n17) {
                            for (n16 = n11; n16 < n6 + n11; ++n16) {
                                n15 = n16 * n12 * n9;
                                if (n19 != 0) {
                                    writableRaster.setDataElements(0, 0, raster.createChild(0, n16 - n11, raster.getWidth(), 1, 0, 0, null));
                                }
                                for (int k = n10; k < n18 + n10; ++k) {
                                    n14 = n15 + k * n9;
                                    for (n13 = 0; n13 < n9; ++n13) {
                                        if (n8 == 8 || n19 == 0) {
                                            byteBuffer.put((byte)(dataBuffer.getElem(n17, n14 + nArray[n13]) & 0xFF));
                                            continue;
                                        }
                                        byteBuffer.put((byte)(dataBuffer2.getElem(n17, k - n10 + nArray[n13]) & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    case 1: 
                    case 2: {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        if (n == 1) {
                            for (n17 = 0; n17 < dataBuffer.getNumBanks(); ++n17) {
                                for (n16 = n11; n16 < n6 + n11; ++n16) {
                                    n15 = n16 * n12 / 2;
                                    for (int k = n10; k < n7 + n10; ++k) {
                                        n14 = n15 + k;
                                        byteBuffer.putShort((short)(dataBuffer.getElem(n17, n14) & 0xFFFF));
                                    }
                                    this.flushBuffer(byteBuffer, dataOutput);
                                    if (!(dataOutput instanceof DataOutputStream)) continue;
                                    DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                    dataOutputStream.flush();
                                }
                            }
                            continue block6;
                        }
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                    case 3: {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        if (1 == n) {
                            for (n17 = 0; n17 < dataBuffer.getNumBanks(); ++n17) {
                                for (n16 = n11; n16 < n6 + n11; ++n16) {
                                    n15 = n16 * n12 / 4;
                                    for (int k = n10; k < n7 + n10; ++k) {
                                        n14 = n15 + k;
                                        byteBuffer.putInt(dataBuffer.getElem(n17, n14));
                                    }
                                    this.flushBuffer(byteBuffer, dataOutput);
                                    if (!(dataOutput instanceof DataOutputStream)) continue;
                                    DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                    dataOutputStream.flush();
                                }
                            }
                            continue block6;
                        }
                        for (n17 = 0; n17 < dataBuffer.getNumBanks(); ++n17) {
                            for (n16 = 0; n16 < n6; ++n16) {
                                n15 = n16 * n7;
                                for (int k = 0; k < n7; ++k) {
                                    n14 = n15 + k;
                                    n13 = dataBuffer.getElem(n17, n14);
                                    for (int i2 = 0; i2 < n9; ++i2) {
                                        byteBuffer.put((byte)(n13 >> nArray2[i2] & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                }
            }
            if (dataOutput instanceof DataOutputStream) {
                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                dataOutputStream.flush();
            }
            this.processImageProgress(100.0f * (float)i / (float)n3);
        }
        if (dataOutput instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
            dataOutputStream.close();
        }
        this.processImageComplete();
    }

    private void flushBuffer(ByteBuffer byteBuffer, DataOutput dataOutput) throws IOException {
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        byteBuffer.clear();
    }

    public TIFFImageMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.initMeta(null, imageTypeSpecifier, imageWriteParam);
    }

    public TIFFImageMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Directory directory;
        Validate.notNull((Object)iIOMetadata, (String)"inData");
        Validate.notNull((Object)imageTypeSpecifier, (String)"imageType");
        if (iIOMetadata instanceof TIFFImageMetadata) {
            directory = ((TIFFImageMetadata)((Object)iIOMetadata)).getIFD();
        } else {
            TIFFImageMetadata tIFFImageMetadata;
            block6: {
                tIFFImageMetadata = new TIFFImageMetadata(Collections.emptySet());
                try {
                    if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
                        tIFFImageMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_image_1.0", iIOMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_image_1.0"));
                        break block6;
                    }
                    if (iIOMetadata.isStandardMetadataFormatSupported()) {
                        tIFFImageMetadata.setFromTree("javax_imageio_1.0", iIOMetadata.getAsTree("javax_imageio_1.0"));
                        break block6;
                    }
                    return null;
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {
                    // empty catch block
                }
            }
            directory = tIFFImageMetadata.getIFD();
        }
        return this.initMeta(directory, imageTypeSpecifier, imageWriteParam);
    }

    private TIFFImageMetadata initMeta(Directory directory, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Validate.notNull((Object)imageTypeSpecifier, (String)"imageType");
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>(directory != null ? directory.size() + 10 : 20);
        if (directory != null) {
            for (Entry entry : directory) {
                linkedHashMap.put((Integer)entry.getIdentifier(), entry);
            }
        }
        linkedHashMap.put(262, (Object)new TIFFEntry(262, 3, this.getPhotometricInterpretation(imageTypeSpecifier.getColorModel())));
        return new TIFFImageMetadata(linkedHashMap.values());
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return super.getDefaultStreamMetadata(imageWriteParam);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return super.convertStreamMetadata(iIOMetadata, imageWriteParam);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.isWritingSequence) {
            throw new IllegalStateException("sequence writing has already been started!");
        }
        this.assertOutput();
        this.isWritingSequence = true;
        this.sequenceExifWriter = new EXIFWriter();
        this.sequenceExifWriter.writeTIFFHeader(this.imageOutput);
        this.sequenceLastIFDPos = this.imageOutput.getStreamPosition();
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() must be called before writeToSequence()!");
        }
        if (this.sequenceLastIFDPos > 0L) {
            this.imageOutput.flushBefore(this.sequenceLastIFDPos);
        }
        this.sequenceLastIFDPos = this.writePage(iIOImage, imageWriteParam, this.sequenceExifWriter, this.sequenceLastIFDPos);
    }

    public void endWriteSequence() throws IOException {
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() must be called before endWriteSequence()!");
        }
        this.isWritingSequence = false;
        this.sequenceExifWriter = null;
        this.sequenceLastIFDPos = -1L;
        this.imageOutput.flush();
    }

    protected void resetMembers() {
        super.resetMembers();
        this.isWritingSequence = false;
        this.sequenceExifWriter = null;
        this.sequenceLastIFDPos = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        int n2 = 0;
        int n3 = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : -1;
        int n4 = n = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : 0;
        if (stringArray.length <= n2) {
            System.err.println("No file specified");
            System.exit(1);
        }
        File file = new File(stringArray[n2++]);
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            object5 = ImageIO.getImageReaders(imageInputStream);
            if (!object5.hasNext()) {
                System.err.println("No reader for: " + file);
                System.exit(1);
            }
            object4 = object5.next();
            ((ImageReader)object4).setInput(imageInputStream);
            object3 = ((ImageReader)object4).getDefaultReadParam();
            ((ImageReadParam)object3).setDestinationType(((ImageReader)object4).getRawImageType(0));
            if (((IIOParam)object3).getDestinationType() == null) {
                object2 = ((ImageReader)object4).getImageTypes(0);
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((ImageTypeSpecifier)object).getColorModel().getColorSpace().getType() != 9) continue;
                    ((ImageReadParam)object3).setDestinationType((ImageTypeSpecifier)object);
                }
            }
            System.err.println("param.getDestinationType(): " + ((IIOParam)object3).getDestinationType());
            bufferedImage = ((ImageReader)object4).read(0, (ImageReadParam)object3);
        }
        System.err.println("original: " + bufferedImage);
        if (n3 <= 0 || n3 == bufferedImage.getType()) {
            object5 = bufferedImage;
        } else if (n3 == 13) {
            object5 = ImageUtil.createIndexed((Image)bufferedImage, (int)256, null, (int)259);
        } else {
            object5 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n3);
            object4 = ((BufferedImage)object5).createGraphics();
            try {
                ((Graphics)object4).drawImage(bufferedImage, 0, 0, null);
            }
            finally {
                ((Graphics)object4).dispose();
            }
        }
        bufferedImage = null;
        object4 = File.createTempFile(file.getName().replace('.', '-'), ".tif");
        System.err.println("output: " + object4);
        object3 = new TIFFImageWriter(null);
        object2 = ImageIO.createImageOutputStream(object4);
        try {
            ((TIFFImageWriter)((Object)object3)).setOutput(object2);
            object = ((TIFFImageWriter)((Object)object3)).getDefaultWriteParam();
            ((ImageWriteParam)object).setCompressionMode(2);
            ((ImageWriteParam)object).setCompressionType(((ImageWriteParam)object).getCompressionTypes()[n]);
            System.err.println("compression: " + ((ImageWriteParam)object).getLocalizedCompressionTypeName());
            long l = System.currentTimeMillis();
            ((TIFFImageWriter)((Object)object3)).write(null, new IIOImage((RenderedImage)object5, null, null), (ImageWriteParam)object);
            System.err.println("Write time: " + (System.currentTimeMillis() - l) + " ms");
        }
        finally {
            object2.close();
        }
        System.err.println("output.length: " + ((File)object4).length());
        object5 = null;
        object = ImageIO.read((File)object4);
        System.err.println("read: " + object);
        TIFFImageReader.showIt((BufferedImage)object, ((File)object4).getName());
    }

    static final class TIFFEntry
    extends AbstractEntry {
        private final short type;

        private static short guessType(Object object) {
            Object object2 = Validate.notNull((Object)object);
            boolean bl = object2.getClass().isArray();
            if (bl) {
                object2 = Array.get(object2, 0);
            }
            if (object2 instanceof Byte) {
                return 1;
            }
            if (object2 instanceof Short) {
                if (!bl && (Short)object2 < 127) {
                    return 1;
                }
                return 3;
            }
            if (object2 instanceof Integer) {
                if (!bl && (Integer)object2 < Short.MAX_VALUE) {
                    return 3;
                }
                return 4;
            }
            if (object2 instanceof Long && !bl && (Long)object2 < Integer.MAX_VALUE) {
                return 4;
            }
            if (object2 instanceof Rational) {
                return 5;
            }
            if (object2 instanceof String) {
                return 2;
            }
            throw new UnsupportedOperationException(String.format("Method guessType not implemented for value of type %s", object2.getClass()));
        }

        TIFFEntry(int n, Object object) {
            this(n, TIFFEntry.guessType(object), object);
        }

        TIFFEntry(int n, short s, Object object) {
            super((Object)n, object);
            this.type = s;
        }

        public String getTypeName() {
            return TIFF.TYPE_NAMES[this.type];
        }
    }
}

