/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.thumbsdb;

import com.twelvemonkeys.imageio.plugins.thumbsdb.ThumbsDBImageReader;
import com.twelvemonkeys.imageio.plugins.thumbsdb.ThumbsDBProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class ThumbsDBImageReaderSpi
extends ImageReaderSpiBase {
    private ImageReaderSpi jpegProvider;

    public ThumbsDBImageReaderSpi() {
        super((ReaderWriterProviderInfo)new ThumbsDBProviderInfo());
    }

    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && this.canDecode((ImageInputStream)object);
    }

    public boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        this.maybeInitJPEGProvider();
        return this.jpegProvider != null && CompoundDocument.canRead((DataInput)imageInputStream);
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new ThumbsDBImageReader(this);
    }

    private void maybeInitJPEGProvider() {
        if (this.jpegProvider == null) {
            ImageReaderSpi imageReaderSpi = null;
            try {
                Iterator<ImageReaderSpi> iterator = this.getJPEGProviders();
                while (iterator.hasNext() && !"Sun Microsystems, Inc.".equals((imageReaderSpi = iterator.next()).getVendorName())) {
                }
            }
            catch (Exception exception) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(this, ImageReaderSpi.class);
            }
            this.jpegProvider = imageReaderSpi;
        }
    }

    private Iterator<ImageReaderSpi> getJPEGProviders() {
        return IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, new ServiceRegistry.Filter(){

            @Override
            public boolean filter(Object object) {
                if (object instanceof ImageReaderSpi) {
                    ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                    for (String string : imageReaderSpi.getFormatNames()) {
                        if (!"JPEG".equals(string)) continue;
                        return true;
                    }
                }
                return false;
            }
        }, true);
    }

    ImageReader createJPEGReader() {
        this.maybeInitJPEGProvider();
        if (this.jpegProvider == null) {
            throw new IllegalStateException("No suitable JPEG reader provider found");
        }
        try {
            return this.jpegProvider.createReaderInstance();
        }
        catch (IOException iOException) {
            throw new Error("Could not create JPEG reader: " + iOException.getMessage(), iOException);
        }
    }

    public String getDescription(Locale locale) {
        return "Microsoft Windows Thumbs DB (Thumbs.db) image reader";
    }
}

