/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.thumbsdb;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.thumbsdb.Catalog;
import com.twelvemonkeys.imageio.plugins.thumbsdb.ThumbsDBImageReaderSpi;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.Entry;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.SortedSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbsDBImageReader
extends ImageReaderBase {
    private static final int THUMBNAIL_OFFSET = 12;
    private Entry root;
    private Catalog catalog;
    private BufferedImage[] thumbnails;
    private final ImageReader reader;
    private int currentImage = -1;
    private boolean loadEagerly;

    public ThumbsDBImageReader() {
        this(new ThumbsDBImageReaderSpi());
    }

    protected ThumbsDBImageReader(ThumbsDBImageReaderSpi thumbsDBImageReaderSpi) {
        super((ImageReaderSpi)thumbsDBImageReaderSpi);
        this.reader = ThumbsDBImageReader.createJPEGReader(thumbsDBImageReaderSpi);
        this.initReaderListeners();
    }

    protected void resetMembers() {
        this.root = null;
        this.catalog = null;
        this.thumbnails = null;
    }

    private static ImageReader createJPEGReader(ThumbsDBImageReaderSpi thumbsDBImageReaderSpi) {
        return thumbsDBImageReaderSpi.createJPEGReader();
    }

    public void dispose() {
        this.reader.dispose();
        super.dispose();
    }

    public boolean isLoadEagerly() {
        return this.loadEagerly;
    }

    public void setLoadEagerly(boolean bl) {
        this.loadEagerly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.init();
        this.checkBounds(n);
        BufferedImage bufferedImage = null;
        if (n < this.thumbnails.length) {
            bufferedImage = this.thumbnails[n];
        }
        if (bufferedImage == null) {
            this.init(n);
            bufferedImage = this.reader.read(0, imageReadParam);
            this.reader.reset();
            if (imageReadParam == null) {
                this.thumbnails[n] = bufferedImage;
            }
        } else {
            this.processImageStarted(n);
            this.processImageProgress(100.0f);
            this.processImageComplete();
        }
        if (imageReadParam != null && (imageReadParam.getDestination() != null && imageReadParam.getDestination() != bufferedImage || imageReadParam.getDestinationType() != null && imageReadParam.getDestinationType().getBufferedImageType() != bufferedImage.getType())) {
            BufferedImage bufferedImage2 = ThumbsDBImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.getWidth(n), (int)this.getHeight(n));
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    public BufferedImage read(String string, ImageReadParam imageReadParam) throws IOException {
        this.initCatalog();
        int n = this.catalog.getIndex(string);
        if (n < 0) {
            throw new FileNotFoundException("Name not found in \"Catalog\" entry: " + string);
        }
        return this.read(n, imageReadParam);
    }

    public void abort() {
        super.abort();
        this.reader.abort();
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (this.imageInput != null) {
            this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private void init(int n) throws IOException {
        if (this.currentImage == -1 || n != this.currentImage || this.reader.getInput() == null) {
            this.init();
            this.checkBounds(n);
            this.currentImage = n;
            this.initReader(n);
        }
    }

    private void initReader(int n) throws IOException {
        this.init();
        String string = this.catalog.getStreamName(n);
        Entry entry = this.root.getChildEntry(string);
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream((InputStream)entry.getInputStream());
        memoryCacheImageInputStream.skipBytes(12);
        this.reader.setInput(memoryCacheImageInputStream);
    }

    private void initReaderListeners() {
        this.reader.addIIOReadProgressListener((IIOReadProgressListener)new ProgressListenerBase(){

            public void imageComplete(ImageReader imageReader) {
                ThumbsDBImageReader.this.processImageComplete();
            }

            public void imageStarted(ImageReader imageReader, int n) {
                ThumbsDBImageReader.this.processImageStarted(ThumbsDBImageReader.this.currentImage);
            }

            public void imageProgress(ImageReader imageReader, float f) {
                ThumbsDBImageReader.this.processImageProgress(f);
            }

            public void readAborted(ImageReader imageReader) {
                ThumbsDBImageReader.this.processReadAborted();
            }
        });
    }

    private void init() throws IOException {
        this.assertInput();
        if (this.root == null) {
            this.root = new CompoundDocument(this.imageInput).getRootEntry();
            SortedSet sortedSet = this.root.getChildEntries();
            this.thumbnails = new BufferedImage[sortedSet.size() - 1];
            this.initCatalog();
            if (this.loadEagerly) {
                for (int i = 0; i < this.thumbnails.length; ++i) {
                    this.initReader(i);
                    ImageReader imageReader = this.reader;
                    this.thumbnails[i] = imageReader.read(0, null);
                }
            }
        }
    }

    private void initCatalog() throws IOException {
        if (this.catalog == null) {
            Entry entry = this.root.getChildEntry("Catalog");
            if (entry.length() <= 16L) {
                // empty if block
            }
            this.catalog = Catalog.read((InputStream)entry.getInputStream());
        }
    }

    public int getNumImages(boolean bl) throws IOException {
        if (bl) {
            this.init();
        }
        return this.catalog != null ? this.catalog.getThumbnailCount() : super.getNumImages(false);
    }

    public int getWidth(int n) throws IOException {
        this.init(n);
        BufferedImage bufferedImage = this.thumbnails[n];
        return bufferedImage != null ? bufferedImage.getWidth() : this.reader.getWidth(0);
    }

    public int getHeight(int n) throws IOException {
        this.init(n);
        BufferedImage bufferedImage = this.thumbnails[n];
        return bufferedImage != null ? bufferedImage.getHeight() : this.reader.getHeight(0);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.init(n);
        this.initReader(n);
        return this.reader.getImageTypes(0);
    }

    public boolean isPresent(String string) {
        try {
            this.init();
        }
        catch (IOException iOException) {
            this.resetMembers();
            return false;
        }
        String string2 = FileUtil.getExtension((String)string);
        if (StringUtil.isEmpty((String)string2)) {
            return false;
        }
        return !"psd".equals(string2 = string2.toLowerCase()) && !"svg".equals(string2) && this.catalog != null && this.catalog.getIndex(string) != -1;
    }

    public static void main(String[] stringArray) throws IOException {
        ThumbsDBImageReader thumbsDBImageReader = new ThumbsDBImageReader();
        thumbsDBImageReader.setInput(ImageIO.createImageInputStream(new File(stringArray[0])));
        if (stringArray.length > 1) {
            long l = System.currentTimeMillis();
            thumbsDBImageReader.init();
            for (Catalog.CatalogItem catalogItem : thumbsDBImageReader.catalog) {
                thumbsDBImageReader.read(catalogItem.getName(), null);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Time: " + (l2 - l) + " ms");
        } else {
            JFrame jFrame = ThumbsDBImageReader.createWindow(stringArray[0]);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            long l = System.currentTimeMillis();
            thumbsDBImageReader.init();
            for (Catalog.CatalogItem catalogItem : thumbsDBImageReader.catalog) {
                ThumbsDBImageReader.addImage(jPanel, (ImageReader)((Object)thumbsDBImageReader), thumbsDBImageReader.catalog.getIndex(catalogItem.getName()), catalogItem.getName());
            }
            long l3 = System.currentTimeMillis();
            System.out.println("Time: " + (l3 - l) + " ms");
            jFrame.getContentPane().add(new JScrollPane(jPanel));
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    private static JFrame createWindow(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        return jFrame;
    }

    private static void addImage(Container container, ImageReader imageReader, int n, String string) throws IOException {
        JLabel jLabel = new JLabel();
        final BufferedImage bufferedImage = imageReader.read(n);
        jLabel.setIcon(new Icon(){
            private static final int SIZE = 110;

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(Color.DARK_GRAY);
                graphics.fillRoundRect(n, n2, 110, 110, 10, 10);
                graphics.drawImage(bufferedImage, (110 - bufferedImage.getWidth()) / 2 + n, (110 - bufferedImage.getHeight()) / 2 + n2, null);
            }

            public int getIconWidth() {
                return 110;
            }

            public int getIconHeight() {
                return 110;
            }
        });
        jLabel.setText("" + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + ": " + string);
        jLabel.setToolTipText(bufferedImage.toString());
        container.add(jLabel);
    }
}

