/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.thumbsdb;

import com.twelvemonkeys.imageio.plugins.thumbsdb.ThumbsDBImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbsDBImageReaderSpi
extends ImageReaderSpi {
    private ImageReaderSpi jpegProvider;

    public ThumbsDBImageReaderSpi() {
        this(IIOUtil.getProviderInfo(ThumbsDBImageReaderSpi.class));
    }

    private ThumbsDBImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"thumbs", "THUMBS", "Thumbs DB"}, new String[]{"db"}, new String[]{"image/x-thumbs-db", "application/octet-stream"}, "com.twelvemonkeys.imageio.plugins.thumbsdb.ThumbsDBImageReader", new Class[]{ImageInputStream.class}, null, true, null, null, null, null, true, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && this.canDecode((ImageInputStream)object);
    }

    public boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        this.maybeInitJPEGProvider();
        return this.jpegProvider != null && CompoundDocument.canRead((DataInput)imageInputStream);
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new ThumbsDBImageReader(this);
    }

    private void maybeInitJPEGProvider() {
        if (this.jpegProvider == null) {
            ImageReaderSpi imageReaderSpi = null;
            try {
                Iterator<ImageReaderSpi> iterator = this.getJPEGProviders();
                while (iterator.hasNext() && !"Sun Microsystems, Inc.".equals((imageReaderSpi = iterator.next()).getVendorName())) {
                }
            }
            catch (Exception exception) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(this, ImageReaderSpi.class);
            }
            this.jpegProvider = imageReaderSpi;
        }
    }

    private Iterator<ImageReaderSpi> getJPEGProviders() {
        return IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, new ServiceRegistry.Filter(){

            public boolean filter(Object object) {
                if (object instanceof ImageReaderSpi) {
                    ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                    for (String string : imageReaderSpi.getFormatNames()) {
                        if (!"JPEG".equals(string)) continue;
                        return true;
                    }
                }
                return false;
            }
        }, true);
    }

    ImageReader createJPEGReader() {
        this.maybeInitJPEGProvider();
        if (this.jpegProvider == null) {
            throw new IllegalStateException("No suitable JPEG reader provider found");
        }
        try {
            return this.jpegProvider.createReaderInstance();
        }
        catch (IOException iOException) {
            throw new Error("Could not create JPEG reader: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public String getDescription(Locale locale) {
        return "Microsoft Windows Thumbs DB (Thumbs.db) image reader";
    }
}

