/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelSourceDestinationRange;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerBlendMode;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerMaskData;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PSDLayerInfo {
    final int top;
    final int left;
    final int bottom;
    final int right;
    final PSDChannelInfo[] channelInfo;
    final PSDLayerBlendMode blendMode;
    final PSDLayerMaskData layerMaskData;
    final PSDChannelSourceDestinationRange[] ranges;
    private final String layerName;
    private String unicodeLayerName;
    private int layerId;

    PSDLayerInfo(boolean bl, ImageInputStream imageInputStream) throws IOException {
        int n;
        int n2;
        this.top = imageInputStream.readInt();
        this.left = imageInputStream.readInt();
        this.bottom = imageInputStream.readInt();
        this.right = imageInputStream.readInt();
        int n3 = imageInputStream.readUnsignedShort();
        this.channelInfo = new PSDChannelInfo[n3];
        for (int i = 0; i < n3; ++i) {
            short s = imageInputStream.readShort();
            long l = bl ? imageInputStream.readLong() : imageInputStream.readUnsignedInt();
            this.channelInfo[i] = new PSDChannelInfo(s, l);
        }
        this.blendMode = new PSDLayerBlendMode(imageInputStream);
        long l = imageInputStream.readUnsignedInt();
        int n4 = imageInputStream.readInt();
        this.layerMaskData = n4 != 0 ? new PSDLayerMaskData(imageInputStream, n4) : null;
        int n5 = imageInputStream.readInt();
        if (n5 % 8 != 0) {
            throw new IIOException("Illegal PSD Layer Blending Data size: " + n5 + ", expected multiple of 8");
        }
        this.ranges = new PSDChannelSourceDestinationRange[n5 / 8];
        for (n2 = 0; n2 < this.ranges.length; ++n2) {
            this.ranges[n2] = new PSDChannelSourceDestinationRange(imageInputStream, n2 == 0 ? "Gray" : "Channel " + (n2 - 1));
        }
        this.layerName = PSDUtil.readPascalString(imageInputStream);
        n2 = this.layerName.length() + 1;
        if (n2 % 4 != 0) {
            int n6 = 4 - n2 % 4;
            imageInputStream.skipBytes(n6);
            n2 += n6;
        }
        long l2 = imageInputStream.getStreamPosition();
        long l3 = l2 + l - (long)n4 - 4L - (long)n5 - 4L - (long)n2;
        while (imageInputStream.getStreamPosition() < l3 && ((n = imageInputStream.readInt()) == 943868237 || n == 943863348)) {
            int n7 = imageInputStream.readInt();
            boolean bl2 = n != 943868237;
            long l4 = bl2 ? imageInputStream.readLong() : imageInputStream.readUnsignedInt();
            long l5 = imageInputStream.getStreamPosition();
            switch (n7) {
                case 1819635305: {
                    this.unicodeLayerName = PSDUtil.readUnicodeString(imageInputStream);
                    break;
                }
                case 1819896164: {
                    if (l4 != 4L) {
                        throw new IIOException(String.format("Expected layerId length == 4: %d", l4));
                    }
                    this.layerId = imageInputStream.readInt();
                    break;
                }
                default: {
                    imageInputStream.skipBytes(l4);
                }
            }
            if (imageInputStream.getStreamPosition() == l5 + l4) continue;
            imageInputStream.seek(l5 + l4);
        }
        if (imageInputStream.getStreamPosition() != l3) {
            imageInputStream.seek(l3);
        }
    }

    String getLayerName() {
        return this.unicodeLayerName != null ? this.unicodeLayerName : this.layerName;
    }

    int getLayerId() {
        return this.layerId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.top);
        stringBuilder.append(", left: ").append(this.left);
        stringBuilder.append(", bottom: ").append(this.bottom);
        stringBuilder.append(", right: ").append(this.right);
        stringBuilder.append(", channels: ").append(Arrays.toString(this.channelInfo));
        stringBuilder.append(", blend mode: ").append(this.blendMode);
        if (this.layerMaskData != null) {
            stringBuilder.append(", layer mask data: ").append(this.layerMaskData);
        }
        stringBuilder.append(", ranges: ").append(Arrays.toString(this.ranges));
        stringBuilder.append(", layer name: \"").append(this.getLayerName()).append("\"");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

