/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.HorizontalDeDifferencingStream;
import com.twelvemonkeys.imageio.stream.DirectImageInputStream;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.SubStream;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import com.twelvemonkeys.lang.StringUtil;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.ImageInputStream;

final class PSDUtil {
    PSDUtil() {
    }

    static String intToStr(int n) {
        return new String(new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)});
    }

    static String readPascalString(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return StringUtil.decode((byte[])byArray, (int)0, (int)byArray.length, (String)"ASCII");
    }

    static String readUnicodeString(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n * 2];
        dataInput.readFully(byArray);
        return StringUtil.decode((byte[])byArray, (int)0, (int)byArray.length, (String)"UTF-16");
    }

    public static float fixedPointToFloat(int n) {
        return (float)((n & 0xFFFF0000) >> 16) + (float)(n & 0xFFFF) / 65535.0f;
    }

    static ImageInputStream createDecompressorStream(ImageInputStream imageInputStream, int n, int n2, int n3, int[] nArray, long l) throws IOException {
        switch (n) {
            case 0: {
                long l2 = imageInputStream.length();
                return new SubImageInputStream(imageInputStream, l2 < 0L ? Long.MAX_VALUE : l2);
            }
            case 1: {
                int n4 = (n2 * n3 + 7) / 8;
                return new DirectImageInputStream((InputStream)new SequenceInputStream(new LazyPackBitsStreamEnumeration(imageInputStream, nArray, n4)));
            }
            case 2: {
                return new DirectImageInputStream((InputStream)new InflaterInputStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)l)));
            }
            case 3: {
                return new DirectImageInputStream((InputStream)new HorizontalDeDifferencingStream(new InflaterInputStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)l)), n2, 1, n3, ByteOrder.BIG_ENDIAN));
            }
        }
        throw new IllegalArgumentException("Unknown PSD compression: " + n);
    }

    private static class LazyPackBitsStreamEnumeration
    implements Enumeration<InputStream> {
        private final ImageInputStream stream;
        private final int[] byteCounts;
        private final int rowLength;
        private int index;

        public LazyPackBitsStreamEnumeration(ImageInputStream imageInputStream, int[] nArray, int n) {
            this.stream = imageInputStream;
            this.byteCounts = nArray;
            this.rowLength = n;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.byteCounts.length;
        }

        @Override
        public InputStream nextElement() {
            return new SubStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.stream, (long)this.byteCounts[this.index++]), (Decoder)new PackBitsDecoder(), this.rowLength), (long)this.rowLength);
        }
    }
}

