/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.util.Arrays;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

abstract class AbstractMetadata
extends IIOMetadata
implements Cloneable {
    protected AbstractMetadata(boolean bl, String string, String string2, String[] stringArray, String[] stringArray2) {
        super(bl, string, string2, stringArray, stringArray2);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        this.validateFormatName(string);
        if (string.equals(this.nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        this.assertMutable();
        this.validateFormatName(string);
        if (!node.getNodeName().equals(this.nativeMetadataFormatName)) {
            throw new IIOInvalidTreeException("Root must be " + this.nativeMetadataFormatName, node);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
        }
    }

    public void reset() {
        this.assertMutable();
    }

    protected final void assertMutable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    protected abstract Node getNativeTree();

    protected final void validateFormatName(String string) {
        Object[] objectArray = this.getMetadataFormatNames();
        if (objectArray != null) {
            for (String string2 : objectArray) {
                if (!string2.equals(string)) continue;
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Bad format name: \"%s\". Expected one of %s", string, Arrays.toString(objectArray)));
    }
}

