/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

class PSDThumbnail
extends PSDImageResource {
    private int format;
    private int width;
    private int height;
    private int widthBytes;
    private byte[] data;

    public PSDThumbnail(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        this.format = imageInputStream.readInt();
        this.width = imageInputStream.readInt();
        this.height = imageInputStream.readInt();
        this.widthBytes = imageInputStream.readInt();
        int n = imageInputStream.readInt();
        int n2 = imageInputStream.readInt();
        if ((long)n2 != this.size - 28L) {
            throw new IIOException("Corrupt thumbnail in PSD document");
        }
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        if (n3 == 24 || n4 != 1) {
            // empty if block
        }
        this.data = new byte[n2];
        imageInputStream.readFully(this.data);
    }

    BufferedImage imageFromRawData(int n, int n2, int n3, byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n3, 3, new int[]{0, 1, 2}, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
        return new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final BufferedImage getThumbnail() throws IOException {
        switch (this.format) {
            case 0: {
                return this.imageFromRawData(this.width, this.height, this.widthBytes, (byte[])this.data.clone());
            }
            case 1: {
                return ImageIO.read(new ByteArrayInputStream(this.data));
            }
        }
        throw new IIOException(String.format("Unsupported thumbnail format (%s) in PSD document", this.format));
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", format: ");
        switch (this.format) {
            case 0: {
                stringBuilder.append("RAW RGB");
                break;
            }
            case 1: {
                stringBuilder.append("JPEG");
                break;
            }
            default: {
                stringBuilder.append("Unknown");
            }
        }
        stringBuilder.append(", size: ").append(this.data != null ? this.data.length : -1);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

