/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDColorData {
    final byte[] colors;
    private IndexColorModel colorModel;

    PSDColorData(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n == 0) {
            throw new IIOException("No palette information in PSD");
        }
        if (n % 3 != 0) {
            throw new IIOException("Wrong palette information in PSD");
        }
        this.colors = new byte[n];
        imageInputStream.readFully(this.colors);
    }

    IndexColorModel getIndexColorModel() {
        if (this.colorModel == null) {
            int[] nArray = PSDColorData.toInterleavedRGB(this.colors);
            this.colorModel = new InverseColorMapIndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        }
        return this.colorModel;
    }

    private static int[] toInterleavedRGB(byte[] byArray) {
        int[] nArray = new int[byArray.length / 3];
        for (int i = 0; i < nArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            int n2 = byArray[nArray.length + i] & 0xFF;
            int n3 = byArray[2 * nArray.length + i] & 0xFF;
            nArray[i] = n << 16 | n2 << 8 | n3;
        }
        return nArray;
    }
}

