/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PCXHeader {
    private int version;
    private int compression;
    private int bitsPerPixel;
    private int width;
    private int height;
    private int hdpi;
    private int vdpi;
    private byte[] palette;
    private int channels;
    private int bytesPerLine;
    private int paletteInfo;
    private int hScreenSize;
    private int vScreenSize;

    PCXHeader() {
    }

    public int getVersion() {
        return this.version;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHdpi() {
        return this.hdpi;
    }

    public int getVdpi() {
        return this.vdpi;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }

    public int getPaletteInfo() {
        return this.paletteInfo;
    }

    public IndexColorModel getEGAPalette() {
        int n = this.channels * this.bitsPerPixel;
        return new IndexColorModel(n, Math.min(16, 1 << n), this.palette, 0, false);
    }

    public String toString() {
        return "PCXHeader{version=" + this.version + ", compression=" + this.compression + ", bitsPerPixel=" + this.bitsPerPixel + ", width=" + this.width + ", height=" + this.height + ", hdpi=" + this.hdpi + ", vdpi=" + this.vdpi + ", channels=" + this.channels + ", bytesPerLine=" + this.bytesPerLine + ", paletteInfo=" + this.paletteInfo + ", hScreenSize=" + this.hScreenSize + ", vScreenSize=" + this.vScreenSize + ", palette=" + Arrays.toString(this.palette) + '}';
    }

    public static PCXHeader read(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        if (by != 10) {
            throw new IIOException(String.format("Not a PCX image. Expected PCX magic %02x, read %02x", (byte)10, by));
        }
        PCXHeader pCXHeader = new PCXHeader();
        pCXHeader.version = imageInputStream.readUnsignedByte();
        pCXHeader.compression = imageInputStream.readUnsignedByte();
        pCXHeader.bitsPerPixel = imageInputStream.readUnsignedByte();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        pCXHeader.width = imageInputStream.readUnsignedShort() - n + 1;
        pCXHeader.height = imageInputStream.readUnsignedShort() - n2 + 1;
        pCXHeader.hdpi = imageInputStream.readUnsignedShort();
        pCXHeader.vdpi = imageInputStream.readUnsignedShort();
        byte[] byArray = new byte[48];
        imageInputStream.readFully(byArray);
        pCXHeader.palette = byArray;
        imageInputStream.readUnsignedByte();
        pCXHeader.channels = imageInputStream.readUnsignedByte();
        pCXHeader.bytesPerLine = imageInputStream.readUnsignedShort();
        pCXHeader.paletteInfo = imageInputStream.readUnsignedShort();
        pCXHeader.hScreenSize = imageInputStream.readUnsignedShort();
        pCXHeader.vScreenSize = imageInputStream.readUnsignedShort();
        imageInputStream.skipBytes(128L - imageInputStream.getStreamPosition());
        return pCXHeader;
    }
}

