/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.imageio.plugins.pcx.PCXHeader;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

final class PCXMetadata
extends IIOMetadata {
    private final PCXHeader header;
    private final IndexColorModel vgaPalette;

    PCXMetadata(PCXHeader pCXHeader, IndexColorModel indexColorModel) {
        this.header = pCXHeader;
        this.vgaPalette = indexColorModel;
        this.standardFormatSupported = true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if ("javax_imageio_1.0".equals(string)) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Unsupported metadata format: " + string);
    }

    @Override
    public void mergeTree(String string, Node node) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    public void reset() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Chroma");
        IndexColorModel indexColorModel = null;
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.getBitsPerPixel()) {
            case 1: 
            case 2: 
            case 4: {
                indexColorModel = this.header.getEGAPalette();
                iIOMetadataNode3.setAttribute("name", "RGB");
                break;
            }
            case 8: {
                if (this.header.getChannels() == 1 && this.header.getPaletteInfo() != 2) {
                    indexColorModel = this.vgaPalette;
                    iIOMetadataNode3.setAttribute("name", "RGB");
                    break;
                }
                if (this.header.getChannels() == 1) {
                    iIOMetadataNode3.setAttribute("name", "GRAY");
                    break;
                }
                iIOMetadataNode3.setAttribute("name", "RGB");
                break;
            }
            case 24: {
                iIOMetadataNode3.setAttribute("name", "RGB");
                break;
            }
            default: {
                iIOMetadataNode3.setAttribute("name", "Unknown");
            }
        }
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        if (indexColorModel != null) {
            iIOMetadataNode = new IIOMetadataNode("Palette");
            iIOMetadataNode2.appendChild(iIOMetadataNode);
            for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode4.setAttribute("index", Integer.toString(i));
                iIOMetadataNode4.setAttribute("red", Integer.toString(indexColorModel.getRed(i)));
                iIOMetadataNode4.setAttribute("green", Integer.toString(indexColorModel.getGreen(i)));
                iIOMetadataNode4.setAttribute("blue", Integer.toString(indexColorModel.getBlue(i)));
                iIOMetadataNode.appendChild(iIOMetadataNode4);
            }
        }
        iIOMetadataNode = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.setAttribute("value", Integer.toString(this.header.getChannels()));
        iIOMetadataNode2.appendChild(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode5.setAttribute("value", "TRUE");
        iIOMetadataNode2.appendChild(iIOMetadataNode5);
        return iIOMetadataNode2;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        if (this.header.getCompression() != 0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
            iIOMetadataNode2.setAttribute("value", this.header.getCompression() == 1 ? "RLE" : "Uknown");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
            iIOMetadataNode3.setAttribute("value", "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode3);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Data");
        if (this.header.getChannels() > 1) {
            iIOMetadataNode = new IIOMetadataNode("PlanarConfiguration");
            iIOMetadataNode.setAttribute("value", "LineInterleaved");
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        iIOMetadataNode = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode.setAttribute("value", "UnsignedIntegral");
        iIOMetadataNode2.appendChild(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode3.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.header.getBitsPerPixel())));
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("SignificantBitsPerSample");
        iIOMetadataNode4.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.header.getBitsPerPixel())));
        iIOMetadataNode2.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("SampleMSB");
        iIOMetadataNode5.setAttribute("value", this.createListValue(this.header.getChannels(), "0"));
        return iIOMetadataNode2;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.header.getChannels() == 1 || this.header.getChannels() == 3 ? "none" : "nonpremultiplied");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

