/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.CollectionUtil;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractEntry
implements Entry {
    private final Object identifier;
    private final Object value;

    protected AbstractEntry(Object object, Object object2) {
        Validate.notNull((Object)object, (String)"identifier");
        this.identifier = object;
        this.value = object2;
    }

    public final Object getIdentifier() {
        return this.identifier;
    }

    protected String getNativeIdentifier() {
        return String.valueOf(this.getIdentifier());
    }

    public String getFieldName() {
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.valueCount() > 1) {
            if (this.valueCount() < 16) {
                return AbstractEntry.arrayToString(this.value);
            }
            String string = AbstractEntry.arrayToString(CollectionUtil.subArray((Object)this.value, (int)0, (int)4));
            String string2 = AbstractEntry.arrayToString(CollectionUtil.subArray((Object)this.value, (int)(this.valueCount() - 4), (int)4));
            return String.format("%s ... %s (%d)", string.substring(0, string.length() - 1), string2.substring(1), this.valueCount());
        }
        if (this.value != null && this.value.getClass().isArray() && Array.getLength(this.value) == 1) {
            return String.valueOf(Array.get(this.value, 0));
        }
        return String.valueOf(this.value);
    }

    private static String arrayToString(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return Arrays.toString((boolean[])object);
            }
            if (clazz.equals(Byte.TYPE)) {
                return Arrays.toString((byte[])object);
            }
            if (clazz.equals(Character.TYPE)) {
                return new String((char[])object);
            }
            if (clazz.equals(Double.TYPE)) {
                return Arrays.toString((double[])object);
            }
            if (clazz.equals(Float.TYPE)) {
                return Arrays.toString((float[])object);
            }
            if (clazz.equals(Integer.TYPE)) {
                return Arrays.toString((int[])object);
            }
            if (clazz.equals(Long.TYPE)) {
                return Arrays.toString((long[])object);
            }
            if (clazz.equals(Short.TYPE)) {
                return Arrays.toString((short[])object);
            }
            throw new AssertionError((Object)("Unknown type: " + clazz));
        }
        return Arrays.toString((Object[])object);
    }

    public String getTypeName() {
        if (this.value == null) {
            return null;
        }
        return this.value.getClass().getSimpleName();
    }

    public int valueCount() {
        if (this.value != null && this.value.getClass().isArray()) {
            return Array.getLength(this.value);
        }
        return 1;
    }

    public int hashCode() {
        return this.identifier.hashCode() + (this.value != null ? 31 * this.value.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractEntry)) {
            return false;
        }
        AbstractEntry abstractEntry = (AbstractEntry)object;
        return this.identifier.equals(abstractEntry.identifier) && (this.value == null && abstractEntry.value == null || this.value != null && this.value.equals(abstractEntry.value));
    }

    public String toString() {
        String string = this.getFieldName();
        String string2 = string != null ? String.format("/%s", string) : "";
        String string3 = this.getTypeName();
        String string4 = string3 != null ? String.format(" (%s)", string3) : "";
        return String.format("%s%s: %s%s", this.getNativeIdentifier(), string2, this.getValueAsString(), string4);
    }
}

