/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

final class DGBLChunk
extends IFFChunk {
    int displayWidth;
    int displayHeight;
    int compressionType;
    int xAspect;
    int yAspect;

    DGBLChunk(int n) {
        super(1145520716, n);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        if (this.chunkLength != 8) {
            throw new IIOException("Unknown DBGL chunk length: " + this.chunkLength);
        }
        this.displayWidth = dataInput.readUnsignedShort();
        this.displayHeight = dataInput.readUnsignedShort();
        this.compressionType = dataInput.readUnsignedShort();
        this.xAspect = dataInput.readUnsignedByte();
        this.yAspect = dataInput.readUnsignedByte();
    }

    @Override
    void writeChunk(DataOutput dataOutput) {
        throw new InternalError("Not implemented: writeChunk()");
    }

    @Override
    public String toString() {
        return super.toString() + "{displayWidth=" + this.displayWidth + ", displayHeight=" + this.displayHeight + ", compression=" + this.compressionType + ", xAspect=" + this.xAspect + ", yAspect=" + this.yAspect + '}';
    }
}

