/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

final class CAMGChunk
extends IFFChunk {
    int camg;

    CAMGChunk(int n) {
        super(1128353095, n);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        if (this.chunkLength != 4) {
            throw new IIOException("Unknown CAMG chunk length: " + this.chunkLength);
        }
        this.camg = dataInput.readInt();
    }

    @Override
    void writeChunk(DataOutput dataOutput) {
        throw new InternalError("Not implemented: writeChunk()");
    }

    boolean isHires() {
        return (this.camg & 0x8000) != 0;
    }

    boolean isLaced() {
        return (this.camg & 4) != 0;
    }

    boolean isHAM() {
        return (this.camg & 0x800) != 0;
    }

    boolean isEHB() {
        return (this.camg & 0x80) != 0;
    }

    @Override
    public String toString() {
        return super.toString() + " {mode=" + (this.isHAM() ? "HAM" : (this.isEHB() ? "EHB" : "Normal")) + "}";
    }
}

