/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.image.ResampleOp;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.BODYChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.CTBLChunk;
import com.twelvemonkeys.imageio.plugins.iff.DGBLChunk;
import com.twelvemonkeys.imageio.plugins.iff.DLOCChunk;
import com.twelvemonkeys.imageio.plugins.iff.DPELChunk;
import com.twelvemonkeys.imageio.plugins.iff.Form;
import com.twelvemonkeys.imageio.plugins.iff.GRABChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.plugins.iff.PCHGChunk;
import com.twelvemonkeys.imageio.plugins.iff.RGB8RLEDecoder;
import com.twelvemonkeys.imageio.plugins.iff.SHAMChunk;
import com.twelvemonkeys.imageio.plugins.iff.XS24Chunk;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class IFFImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.iff.debug"));
    private Form header;
    private DataInputStream byteRunStream;

    IFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private void init(int n) throws IOException {
        this.checkBounds(n);
        if (this.header == null) {
            this.readMeta();
        }
    }

    protected void resetMembers() {
        this.header = null;
        this.byteRunStream = null;
    }

    private void readMeta() throws IOException {
        int n = this.imageInput.readInt();
        if (n != 1179603533) {
            throw new IIOException(String.format("Unknown file format for IFFImageReader, expected 'FORM': %s", IFFUtil.toChunkStr(n)));
        }
        int n2 = this.imageInput.readInt() - 4;
        int n3 = this.imageInput.readInt();
        if (n3 != 1229734477 && n3 != 1346522400 && n3 != 1380401720 && n3 != 0x44454550 && n3 != 1414942800) {
            throw new IIOException(String.format("Only IFF FORM types 'ILBM' and 'PBM ' supported: %s", IFFUtil.toChunkStr(n3)));
        }
        if (DEBUG) {
            System.out.println("IFF type FORM '" + IFFUtil.toChunkStr(n3) + "', len: " + (n2 + 4));
            System.out.println("Reading Chunks...");
        }
        this.header = Form.ofType(n3);
        block15: while (n2 > 0) {
            int n4 = this.imageInput.readInt();
            int n5 = this.imageInput.readInt();
            n2 -= 8;
            n2 -= n5 % 2 == 0 ? n5 : n5 + 1;
            if (DEBUG) {
                System.out.println("Next chunk: " + IFFUtil.toChunkStr(n4) + " @ pos: " + (this.imageInput.getStreamPosition() - 8L) + ", len: " + n5);
                System.out.println("Remaining bytes after chunk: " + n2);
            }
            switch (n4) {
                case 1112361028: {
                    BMHDChunk bMHDChunk = new BMHDChunk(n5);
                    bMHDChunk.readChunk(this.imageInput);
                    this.header = this.header.with(bMHDChunk);
                    continue block15;
                }
                case 1145520716: {
                    DGBLChunk dGBLChunk = new DGBLChunk(n5);
                    dGBLChunk.readChunk(this.imageInput);
                    this.header = this.header.with(dGBLChunk);
                    continue block15;
                }
                case 1145851715: {
                    DLOCChunk dLOCChunk = new DLOCChunk(n5);
                    dLOCChunk.readChunk(this.imageInput);
                    this.header = this.header.with(dLOCChunk);
                    continue block15;
                }
                case 1146111308: {
                    DPELChunk dPELChunk = new DPELChunk(n5);
                    dPELChunk.readChunk(this.imageInput);
                    this.header = this.header.with(dPELChunk);
                    continue block15;
                }
                case 1481847348: {
                    XS24Chunk xS24Chunk = new XS24Chunk(n5);
                    xS24Chunk.readChunk(this.imageInput);
                    this.header = this.header.with(xS24Chunk);
                    continue block15;
                }
                case 1129136464: {
                    CMAPChunk cMAPChunk = new CMAPChunk(n5);
                    cMAPChunk.readChunk(this.imageInput);
                    this.header = this.header.with(cMAPChunk);
                    continue block15;
                }
                case 1196572994: {
                    GRABChunk gRABChunk = new GRABChunk(n5);
                    gRABChunk.readChunk(this.imageInput);
                    this.header = this.header.with(gRABChunk);
                    continue block15;
                }
                case 1128353095: {
                    CAMGChunk cAMGChunk = new CAMGChunk(n5);
                    cAMGChunk.readChunk(this.imageInput);
                    this.header = this.header.with(cAMGChunk);
                    continue block15;
                }
                case 1346586695: {
                    PCHGChunk pCHGChunk = new PCHGChunk(n5);
                    pCHGChunk.readChunk(this.imageInput);
                    this.header = this.header.with(pCHGChunk);
                    continue block15;
                }
                case 1397244237: {
                    SHAMChunk sHAMChunk = new SHAMChunk(n5);
                    sHAMChunk.readChunk(this.imageInput);
                    this.header = this.header.with(sHAMChunk);
                    continue block15;
                }
                case 1129595468: {
                    CTBLChunk cTBLChunk = new CTBLChunk(n5);
                    cTBLChunk.readChunk(this.imageInput);
                    this.header = this.header.with(cTBLChunk);
                    continue block15;
                }
                case 1112491097: 
                case 0x44424F44: {
                    BODYChunk bODYChunk = new BODYChunk(n4, n5, this.imageInput.getStreamPosition());
                    this.header = this.header.with(bODYChunk);
                    if (DEBUG) {
                        System.out.println("header = " + this.header);
                    }
                    return;
                }
                case 677587232: 
                case 1095650895: 
                case 1096111176: 
                case 1312902469: 
                case 0x54455854: 
                case 1431586360: {
                    GenericChunk genericChunk = new GenericChunk(n4, n5);
                    genericChunk.readChunk(this.imageInput);
                    this.header = this.header.with(genericChunk);
                    continue block15;
                }
            }
            IFFChunk.skipData(this.imageInput, n5, 0);
        }
        if (DEBUG) {
            System.out.println("header = " + this.header);
            System.out.println("No BODY chunk found...");
        }
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.init(n);
        this.processImageStarted(n);
        BufferedImage bufferedImage = IFFImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.getWidth(n), (int)this.getHeight(n));
        this.readBody(imageReadParam, bufferedImage);
        this.processImageComplete();
        return bufferedImage;
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public boolean hasThumbnails(int n) throws IOException {
        this.init(n);
        return this.header.hasThumbnail();
    }

    public int getNumThumbnails(int n) throws IOException {
        this.init(n);
        return this.header.hasThumbnail() ? 1 : 0;
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        this.init(n);
        if (!this.header.hasThumbnail() || n2 > 1) {
            throw new IndexOutOfBoundsException("thumbnailIndex out of bounds: " + n2);
        }
        return this.header.thumbnailWidth();
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        this.init(n);
        if (!this.header.hasThumbnail() || n2 > 1) {
            throw new IndexOutOfBoundsException("thumbnailIndex out of bounds: " + n2);
        }
        return this.header.thumbnailHeight();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        this.init(n);
        if (!this.header.hasThumbnail() || n2 > 1) {
            throw new IndexOutOfBoundsException("thumbnailIndex out of bounds: " + n2);
        }
        this.processThumbnailStarted(n, n2);
        BufferedImage bufferedImage = this.header.thumbnail();
        this.processThumbnailProgress(100.0f);
        this.processThumbnailComplete();
        return bufferedImage;
    }

    public int getWidth(int n) throws IOException {
        this.init(n);
        return this.header.width();
    }

    public int getHeight(int n) throws IOException {
        this.init(n);
        return this.header.height();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.init(n);
        return new IFFImageMetadata(this.header, this.header.colorMap());
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.init(n);
        int n2 = this.header.bitplanes();
        List<ImageTypeSpecifier> list = this.header.formType == 0x44454550 || this.header.formType == 1414942800 ? Arrays.asList(ImageTypeSpecifiers.createFromBufferedImageType((int)7), this.getRawImageType(n)) : Arrays.asList(this.getRawImageType(n), ImageTypeSpecifiers.createFromBufferedImageType((int)(n2 == 32 ? 6 : 5)));
        return list.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.init(n);
        switch (this.header.bitplanes()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (!this.needsConversionToRGB()) {
                    IndexColorModel indexColorModel = this.header.colorMap();
                    if (indexColorModel != null) {
                        return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel);
                    }
                    return ImageTypeSpecifiers.createFromBufferedImageType((int)10);
                }
            }
            case 24: {
                return ImageTypeSpecifiers.createFromBufferedImageType((int)5);
            }
            case 25: {
                if (this.header.formType != 1380401720) {
                    throw new IIOException(String.format("25 bit depth only supported for FORM type RGB8: %s", IFFUtil.toChunkStr(this.header.formType)));
                }
                return ImageTypeSpecifiers.createInterleaved((ColorSpace)ColorSpaces.getColorSpace((int)1000), (int[])new int[]{0, 1, 2, 3}, (int)0, (boolean)true, (boolean)false);
            }
            case 32: {
                return this.header.formType == 0x44454550 || this.header.formType == 1414942800 ? ImageTypeSpecifiers.createInterleaved((ColorSpace)ColorSpaces.getColorSpace((int)1000), (int[])new int[]{1, 2, 3, 0}, (int)0, (boolean)true, (boolean)this.header.premultiplied()) : ImageTypeSpecifiers.createFromBufferedImageType((int)6);
            }
        }
        throw new IIOException(String.format("Bit depth not implemented: %d", this.header.bitplanes()));
    }

    private boolean needsConversionToRGB() {
        return this.header.isHAM() || this.header.isMultiPalette();
    }

    private void readBody(ImageReadParam imageReadParam, BufferedImage bufferedImage) throws IOException {
        if (DEBUG) {
            System.out.println("Reading body");
            System.out.println("pos: " + this.imageInput.getStreamPosition());
            System.out.println("body offset: " + this.header.bodyOffset());
        }
        this.imageInput.seek(this.header.bodyOffset());
        this.byteRunStream = null;
        if (this.header.formType == 1380401720 || this.header.formType == 0x44454550 || this.header.formType == 1414942800) {
            this.readChunky(imageReadParam, bufferedImage, this.imageInput);
        } else if (this.header.colorMap() != null) {
            IndexColorModel indexColorModel = this.header.colorMap();
            this.readInterleavedIndexed(imageReadParam, bufferedImage, indexColorModel, this.imageInput);
        } else {
            this.readInterleaved(imageReadParam, bufferedImage, this.imageInput);
        }
    }

    private void readInterleavedIndexed(ImageReadParam imageReadParam, BufferedImage bufferedImage, IndexColorModel indexColorModel, ImageInputStream imageInputStream) throws IOException {
        WritableRaster writableRaster;
        ColorModel colorModel;
        int n = this.header.width();
        int n2 = this.header.height();
        Rectangle rectangle = IFFImageReader.getSourceRegion((ImageReadParam)imageReadParam, (int)n, (int)n2);
        Point point = imageReadParam == null ? new Point(0, 0) : imageReadParam.getDestinationOffset();
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)(this.needsConversionToRGB() ? 3 : 1), (int)bufferedImage.getSampleModel().getNumBands());
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (nArray2 != null || point.x != 0 || point.y != 0) {
            writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), writableRaster2.getHeight(), point.x, point.y, nArray2);
        }
        int n5 = 2 * ((n + 15) / 16);
        byte[] byArray = new byte[8 * n5];
        if (this.needsConversionToRGB()) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            writableRaster = Raster.createInterleavedRaster(0, n, 1, n * 3, 3, new int[]{2, 1, 0}, null);
        } else {
            colorModel = indexColorModel;
            writableRaster = indexColorModel.createCompatibleWritableRaster(n, 1);
        }
        Raster raster = writableRaster.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, nArray);
        byte[] byArray2 = new byte[n * 8];
        byte[] byArray3 = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        int n6 = this.header.bitplanes();
        Object object = null;
        Object object2 = null;
        ColorConvertOp colorConvertOp = null;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n6; ++n9) {
                this.readPlaneData(byArray, n9 * n5, n5, imageInputStream);
            }
            if (i < rectangle.y || (i - rectangle.y) % n4 != 0) continue;
            if (i >= rectangle.y + rectangle.height) {
                return;
            }
            if (this.header.formType == 1229734477) {
                n9 = 0;
                for (n8 = 0; n8 < n5; ++n8) {
                    IFFUtil.bitRotateCW(byArray, n8, n5, byArray2, n9, 1);
                    n9 += 8;
                }
                if (this.header.isHAM()) {
                    this.hamToRGB(byArray2, indexColorModel, byArray3, 0);
                } else if (this.needsConversionToRGB()) {
                    this.multiPaletteToRGB(i, byArray2, indexColorModel, byArray3, 0);
                } else {
                    writableRaster.setDataElements(0, 0, n, 1, byArray2);
                }
            } else if (this.header.formType == 1346522400) {
                writableRaster.setDataElements(0, 0, n, 1, byArray);
            } else {
                throw new AssertionError((Object)String.format("Unsupported FORM type: %s", IFFUtil.toChunkStr(this.header.formType)));
            }
            n9 = (i - rectangle.y) / n4;
            if (colorModel.isCompatibleRaster(writableRaster2)) {
                if (n3 == 1) {
                    writableRaster2.setRect(point.x, n9, raster);
                } else {
                    for (n8 = 0; n8 < raster.getWidth(); n8 += n3) {
                        object = raster.getDataElements(n8, 0, object);
                        n7 = n8 / n3;
                        writableRaster2.setDataElements(n7, n9, object);
                    }
                }
            } else if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel2 = (IndexColorModel)colorModel;
                for (n7 = 0; n7 < raster.getWidth(); n7 += n3) {
                    object = raster.getDataElements(n7, 0, object);
                    int n10 = indexColorModel2.getRGB(object);
                    object2 = bufferedImage.getColorModel().getDataElements(n10, object2);
                    int n11 = n7 / n3;
                    writableRaster2.setDataElements(n11, n9, object2);
                }
            } else {
                if (colorConvertOp == null) {
                    colorConvertOp = new ColorConvertOp(colorModel.getColorSpace(), bufferedImage.getColorModel().getColorSpace(), null);
                }
                colorConvertOp.filter(writableRaster.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, null), writableRaster2.createWritableChild(point.x, point.y + i - rectangle.y, rectangle.width, 1, 0, 0, null));
            }
            this.processImageProgress((float)i * 100.0f / (float)n);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readChunky(ImageReadParam imageReadParam, BufferedImage bufferedImage, ImageInputStream imageInputStream) throws IOException {
        int n = this.header.width();
        int n2 = this.header.height();
        Rectangle rectangle = IFFImageReader.getSourceRegion((ImageReadParam)imageReadParam, (int)n, (int)n2);
        Point point = imageReadParam == null ? new Point(0, 0) : imageReadParam.getDestinationOffset();
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)4, (int)bufferedImage.getSampleModel().getNumBands());
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (nArray2 != null || point.x != 0 || point.y != 0) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), point.x, point.y, nArray2);
        }
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(0);
        WritableRaster writableRaster2 = imageTypeSpecifier.createBufferedImage(n, 1).getRaster();
        Raster raster = writableRaster2.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, nArray);
        int n5 = n * 4;
        byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            this.readPlaneData(byArray, 0, n5, imageInputStream);
            if (i >= rectangle.y && (i - rectangle.y) % n4 == 0) {
                int n6 = (i - rectangle.y) / n4;
                if (n3 == 1) {
                    writableRaster.setRect(0, n6, raster);
                } else {
                    for (int j = 0; j < raster.getWidth(); j += n3) {
                        object = raster.getDataElements(j, 0, object);
                        int n7 = j / n3;
                        writableRaster.setDataElements(n7, n6, object);
                    }
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)n);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readInterleaved(ImageReadParam imageReadParam, BufferedImage bufferedImage, ImageInputStream imageInputStream) throws IOException {
        int n = this.header.width();
        int n2 = this.header.height();
        Rectangle rectangle = IFFImageReader.getSourceRegion((ImageReadParam)imageReadParam, (int)n, (int)n2);
        Point point = imageReadParam == null ? new Point(0, 0) : imageReadParam.getDestinationOffset();
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)(this.header.bitplanes() / 8), (int)bufferedImage.getSampleModel().getNumBands());
        int n5 = 2 * ((n + 15) / 16);
        byte[] byArray = new byte[8 * n5];
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (nArray2 != null || point.x != 0 || point.y != 0) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), point.x, point.y, nArray2);
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster().createCompatibleWritableRaster(8 * n5, 1);
        Raster raster = writableRaster2.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, nArray);
        byte[] byArray2 = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
        int n6 = (this.header.bitplanes() + 7) / 8;
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n6; ++n9) {
                for (n8 = 0; n8 < 8; ++n8) {
                    this.readPlaneData(byArray, n8 * n5, n5, imageInputStream);
                }
                if (i >= rectangle.y + rectangle.height) {
                    return;
                }
                if (i < rectangle.y || (i - rectangle.y) % n4 != 0) continue;
                if (this.header.formType == 1229734477) {
                    n8 = n6 - n9 - 1;
                    n7 = 0;
                    for (int j = 0; j < n5; ++j) {
                        IFFUtil.bitRotateCW(byArray, j, n5, byArray2, n8 + n7 * n6, n6);
                        n7 += 8;
                    }
                    continue;
                }
                if (this.header.formType == 1346522400) {
                    System.arraycopy(byArray, 0, byArray2, i * 8 * n5, n5);
                    continue;
                }
                throw new AssertionError((Object)String.format("Unsupported FORM type: %s", IFFUtil.toChunkStr(this.header.formType)));
            }
            if (i >= rectangle.y && (i - rectangle.y) % n4 == 0) {
                n9 = (i - rectangle.y) / n4;
                if (n3 == 1) {
                    writableRaster.setRect(0, n9, raster);
                } else {
                    for (n8 = 0; n8 < raster.getWidth(); n8 += n3) {
                        object = raster.getDataElements(n8, 0, object);
                        n7 = n8 / n3;
                        writableRaster.setDataElements(n7, n9, object);
                    }
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)n);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readPlaneData(byte[] byArray, int n, int n2, ImageInputStream imageInputStream) throws IOException {
        switch (this.header.compressionType()) {
            case 0: {
                imageInputStream.readFully(byArray, n, n2);
                if (this.header.bitplanes() * n2 % 2 == 0) break;
                imageInputStream.readByte();
                break;
            }
            case 1: {
                if (this.byteRunStream == null) {
                    this.byteRunStream = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)this.header.bodyLength()), (Decoder)new PackBitsDecoder(this.header.sampleSize(), true), n2 * (this.header.sampleSize() > 1 ? 1 : this.header.bitplanes())));
                }
                this.byteRunStream.readFully(byArray, n, n2);
                break;
            }
            case 4: {
                if (this.header.formType == 1380401720) {
                    if (this.byteRunStream == null) {
                        this.byteRunStream = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)this.header.bodyLength()), (Decoder)new RGB8RLEDecoder(), 1024));
                    }
                    this.byteRunStream.readFully(byArray, n, n2);
                    break;
                }
            }
            default: {
                throw new IIOException(String.format("Unknown compression type: %d", this.header.compressionType()));
            }
        }
    }

    private void multiPaletteToRGB(int n, byte[] byArray, IndexColorModel indexColorModel, byte[] byArray2, int n2) {
        int n3 = this.header.width();
        ColorModel colorModel = this.header.colorMapForRow(indexColorModel, n);
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = colorModel.getRGB(n4);
            int n6 = i * 3 + n2;
            byArray2[2 + n6] = (byte)(n5 >> 16 & 0xFF);
            byArray2[1 + n6] = (byte)(n5 >> 8 & 0xFF);
            byArray2[n6] = (byte)(n5 & 0xFF);
        }
    }

    private void hamToRGB(byte[] byArray, IndexColorModel indexColorModel, byte[] byArray2, int n) {
        int n2 = this.header.bitplanes();
        int n3 = this.header.width();
        int n4 = indexColorModel.getRed(0);
        int n5 = indexColorModel.getGreen(0);
        int n6 = indexColorModel.getBlue(0);
        for (int i = 0; i < n3; ++i) {
            int n7 = byArray[i] & 0xFF;
            int n8 = n2 == 6 ? n7 & 0xF : n7 & 0x3F;
            int n9 = n2 == 6 ? 4 : 2;
            int n10 = n2 == 6 ? 15 : 3;
            switch (n7 >> 8 - n9 & 3) {
                case 0: {
                    n4 = indexColorModel.getRed(n8);
                    n5 = indexColorModel.getGreen(n8);
                    n6 = indexColorModel.getBlue(n8);
                    break;
                }
                case 1: {
                    n6 = n6 & n10 | n8 << n9;
                    break;
                }
                case 2: {
                    n4 = n4 & n10 | n8 << n9;
                    break;
                }
                case 3: {
                    n5 = n5 & n10 | n8 << n9;
                }
            }
            int n11 = i * 3 + n;
            byArray2[2 + n11] = (byte)n4;
            byArray2[1 + n11] = (byte)n5;
            byArray2[n11] = (byte)n6;
        }
    }

    public static void main(String[] stringArray) {
        IFFImageReader iFFImageReader = new IFFImageReader((ImageReaderSpi)((Object)new IFFImageReaderSpi()));
        boolean bl = false;
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                bl = true;
                continue;
            }
            File file = new File(string);
            if (!file.isFile()) continue;
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
                boolean bl2 = ((ImageReader)((Object)iFFImageReader)).getOriginatingProvider().canDecodeInput(imageInputStream);
                if (bl2) {
                    ((ImageReader)((Object)iFFImageReader)).setInput(imageInputStream);
                    ImageReadParam imageReadParam = ((ImageReader)((Object)iFFImageReader)).getDefaultReadParam();
                    BufferedImage bufferedImage = ((ImageReader)((Object)iFFImageReader)).read(0, imageReadParam);
                    System.out.println("image = " + bufferedImage);
                    if (bl) {
                        bufferedImage = new ResampleOp(bufferedImage.getWidth() / 2, bufferedImage.getHeight(), 13).filter(bufferedImage, null);
                    }
                    IFFImageReader.showIt((BufferedImage)bufferedImage, (String)string);
                    continue;
                }
                System.err.println("Foo!");
            }
            catch (IOException iOException) {
                System.err.println("Error reading file: " + file);
                iOException.printStackTrace();
            }
        }
    }
}

