/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.image.ResampleOp;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.BODYChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.CTBLChunk;
import com.twelvemonkeys.imageio.plugins.iff.GRABChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.plugins.iff.MultiPalette;
import com.twelvemonkeys.imageio.plugins.iff.PCHGChunk;
import com.twelvemonkeys.imageio.plugins.iff.SHAMChunk;
import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class IFFImageReader
extends ImageReaderBase {
    private BMHDChunk header;
    private CMAPChunk colorMap;
    private BODYChunk body;
    private GRABChunk grab;
    private CAMGChunk viewPort;
    private MultiPalette paletteChange;
    private int formType;
    private long bodyStart;
    private BufferedImage image;
    private DataInputStream byteRunStream;

    public IFFImageReader() {
        super((ImageReaderSpi)((Object)new IFFImageReaderSpi()));
    }

    protected IFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private void init(int n) throws IOException {
        this.checkBounds(n);
        if (this.header == null) {
            this.readMeta();
        }
    }

    protected void resetMembers() {
        this.header = null;
        this.colorMap = null;
        this.paletteChange = null;
        this.body = null;
        this.viewPort = null;
        this.formType = 0;
        this.image = null;
        this.byteRunStream = null;
    }

    private void readMeta() throws IOException {
        int n;
        int n2 = this.imageInput.readInt();
        if (n2 != 1179603533) {
            throw new IIOException(String.format("Unknown file format for IFFImageReader, expected 'FORM': %s", IFFUtil.toChunkStr(n2)));
        }
        this.formType = this.imageInput.readInt();
        if (this.formType != 1229734477 && this.formType != 1346522400) {
            throw new IIOException(String.format("Only IFF FORM types 'ILBM' and 'PBM ' supported: %s", IFFUtil.toChunkStr(this.formType)));
        }
        this.grab = null;
        this.viewPort = null;
        block11: for (int i = this.imageInput.readInt() - 4; i > 0; i -= n % 2 == 0 ? n : n + 1) {
            int n3 = this.imageInput.readInt();
            n = this.imageInput.readInt();
            i -= 8;
            switch (n3) {
                case 1112361028: {
                    if (this.header != null) {
                        throw new IIOException("Multiple BMHD chunks not allowed");
                    }
                    this.header = new BMHDChunk(n);
                    this.header.readChunk(this.imageInput);
                    continue block11;
                }
                case 1129136464: {
                    if (this.colorMap != null) {
                        throw new IIOException("Multiple CMAP chunks not allowed");
                    }
                    this.colorMap = new CMAPChunk(n);
                    this.colorMap.readChunk(this.imageInput);
                    continue block11;
                }
                case 1196572994: {
                    if (this.grab != null) {
                        throw new IIOException("Multiple GRAB chunks not allowed");
                    }
                    this.grab = new GRABChunk(n);
                    this.grab.readChunk(this.imageInput);
                    continue block11;
                }
                case 1128353095: {
                    if (this.viewPort != null) {
                        throw new IIOException("Multiple CAMG chunks not allowed");
                    }
                    this.viewPort = new CAMGChunk(n);
                    this.viewPort.readChunk(this.imageInput);
                    continue block11;
                }
                case 1346586695: {
                    if (this.paletteChange instanceof PCHGChunk) {
                        throw new IIOException("Multiple PCHG chunks not allowed");
                    }
                    PCHGChunk pCHGChunk = new PCHGChunk(n);
                    pCHGChunk.readChunk(this.imageInput);
                    this.paletteChange = pCHGChunk;
                    continue block11;
                }
                case 1397244237: {
                    if (this.paletteChange instanceof SHAMChunk) {
                        throw new IIOException("Multiple SHAM chunks not allowed");
                    }
                    SHAMChunk sHAMChunk = new SHAMChunk(n);
                    sHAMChunk.readChunk(this.imageInput);
                    if (this.paletteChange != null) continue block11;
                    this.paletteChange = sHAMChunk;
                    continue block11;
                }
                case 1129595468: {
                    if (this.paletteChange instanceof CTBLChunk) {
                        throw new IIOException("Multiple CTBL chunks not allowed");
                    }
                    CTBLChunk cTBLChunk = new CTBLChunk(n);
                    cTBLChunk.readChunk(this.imageInput);
                    if (this.paletteChange != null) continue block11;
                    this.paletteChange = cTBLChunk;
                    continue block11;
                }
                case 1247104587: {
                    IFFChunk.skipData(this.imageInput, n, 0);
                    continue block11;
                }
                case 1112491097: {
                    if (this.body != null) {
                        throw new IIOException("Multiple BODY chunks not allowed");
                    }
                    this.body = new BODYChunk(n);
                    this.bodyStart = this.imageInput.getStreamPosition();
                    return;
                }
            }
            GenericChunk genericChunk = new GenericChunk(n3, n);
            ((IFFChunk)genericChunk).readChunk(this.imageInput);
        }
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.init(n);
        this.processImageStarted(n);
        this.image = IFFImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.header.width, (int)this.header.height);
        if (this.body != null) {
            this.readBody(imageReadParam);
        } else if (this.colorMap != null) {
            this.image = this.colorMap.createPaletteImage(this.header, this.isEHB());
        }
        BufferedImage bufferedImage = this.image;
        this.processImageComplete();
        return bufferedImage;
    }

    public int getWidth(int n) throws IOException {
        this.init(n);
        return this.header.width;
    }

    public int getHeight(int n) throws IOException {
        this.init(n);
        return this.header.height;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.init(n);
        List<ImageTypeSpecifier> list = Arrays.asList(this.getRawImageType(n), ImageTypeSpecifiers.createFromBufferedImageType((int)(this.header.bitplanes == 32 ? 6 : 5)));
        return list.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        this.init(n);
        switch (this.header.bitplanes) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (!this.isConvertToRGB()) {
                    if (this.colorMap != null) {
                        IndexColorModel indexColorModel = this.colorMap.getIndexColorModel(this.header, this.isEHB());
                        imageTypeSpecifier = ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel);
                        break;
                    }
                    imageTypeSpecifier = ImageTypeSpecifiers.createFromBufferedImageType((int)10);
                    break;
                }
            }
            case 24: {
                imageTypeSpecifier = ImageTypeSpecifiers.createFromBufferedImageType((int)5);
                break;
            }
            case 32: {
                imageTypeSpecifier = ImageTypeSpecifiers.createFromBufferedImageType((int)6);
                break;
            }
            default: {
                throw new IIOException(String.format("Bit depth not implemented: %d", this.header.bitplanes));
            }
        }
        return imageTypeSpecifier;
    }

    private boolean isConvertToRGB() {
        return this.isHAM() || this.isPCHG() || this.isSHAM();
    }

    private void readBody(ImageReadParam imageReadParam) throws IOException {
        this.imageInput.seek(this.bodyStart);
        this.byteRunStream = null;
        if (this.colorMap != null) {
            IndexColorModel indexColorModel = this.colorMap.getIndexColorModel(this.header, this.isEHB());
            this.readIndexed(imageReadParam, this.imageInput, indexColorModel);
        } else {
            this.readTrueColor(imageReadParam, this.imageInput);
        }
    }

    private void readIndexed(ImageReadParam imageReadParam, ImageInputStream imageInputStream, IndexColorModel indexColorModel) throws IOException {
        WritableRaster writableRaster;
        ColorModel colorModel;
        int n = this.header.width;
        int n2 = this.header.height;
        Rectangle rectangle = IFFImageReader.getSourceRegion((ImageReadParam)imageReadParam, (int)n, (int)n2);
        Point point = imageReadParam == null ? new Point(0, 0) : imageReadParam.getDestinationOffset();
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)(this.isConvertToRGB() ? 3 : 1), (int)this.image.getSampleModel().getNumBands());
        WritableRaster writableRaster2 = this.image.getRaster();
        if (nArray2 != null || point.x != 0 || point.y != 0) {
            writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), writableRaster2.getHeight(), point.x, point.y, nArray2);
        }
        int n5 = 2 * ((n + 15) / 16);
        byte[] byArray = new byte[8 * n5];
        if (this.isConvertToRGB()) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            writableRaster = Raster.createInterleavedRaster(0, n, 1, n * 3, 3, new int[]{2, 1, 0}, null);
        } else {
            colorModel = indexColorModel;
            writableRaster = indexColorModel.createCompatibleWritableRaster(n, 1);
        }
        Raster raster = writableRaster.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, nArray);
        byte[] byArray2 = new byte[n * 8];
        byte[] byArray3 = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        int n6 = this.header.bitplanes;
        Object object = null;
        Object object2 = null;
        ColorConvertOp colorConvertOp = null;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n6; ++n9) {
                this.readPlaneData(imageInputStream, byArray, n9 * n5, n5);
            }
            if (i < rectangle.y || (i - rectangle.y) % n4 != 0) continue;
            if (i >= rectangle.y + rectangle.height) {
                return;
            }
            if (this.formType == 1229734477) {
                n9 = 0;
                for (n8 = 0; n8 < n5; ++n8) {
                    IFFUtil.bitRotateCW(byArray, n8, n5, byArray2, n9, 1);
                    n9 += 8;
                }
                if (this.isHAM()) {
                    this.hamToRGB(byArray2, indexColorModel, byArray3, 0);
                } else if (this.isConvertToRGB()) {
                    this.multiPaletteToRGB(i, byArray2, indexColorModel, byArray3, 0);
                } else {
                    writableRaster.setDataElements(0, 0, n, 1, byArray2);
                }
            } else if (this.formType == 1346522400) {
                writableRaster.setDataElements(0, 0, n, 1, byArray);
            } else {
                throw new AssertionError((Object)String.format("Unsupported FORM type: %s", this.formType));
            }
            n9 = (i - rectangle.y) / n4;
            if (colorModel.isCompatibleRaster(writableRaster2)) {
                if (n3 == 1) {
                    writableRaster2.setRect(point.x, n9, raster);
                } else {
                    for (n8 = 0; n8 < raster.getWidth(); n8 += n3) {
                        object = raster.getDataElements(n8, 0, object);
                        n7 = n8 / n3;
                        writableRaster2.setDataElements(n7, n9, object);
                    }
                }
            } else if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel2 = (IndexColorModel)colorModel;
                for (n7 = 0; n7 < raster.getWidth(); n7 += n3) {
                    object = raster.getDataElements(n7, 0, object);
                    int n10 = indexColorModel2.getRGB(object);
                    object2 = this.image.getColorModel().getDataElements(n10, object2);
                    int n11 = n7 / n3;
                    writableRaster2.setDataElements(n11, n9, object2);
                }
            } else {
                if (colorConvertOp == null) {
                    colorConvertOp = new ColorConvertOp(colorModel.getColorSpace(), this.image.getColorModel().getColorSpace(), null);
                }
                colorConvertOp.filter(writableRaster.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, null), writableRaster2.createWritableChild(point.x, point.y + i - rectangle.y, rectangle.width, 1, 0, 0, null));
            }
            this.processImageProgress((float)i * 100.0f / (float)this.header.width);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readTrueColor(ImageReadParam imageReadParam, ImageInputStream imageInputStream) throws IOException {
        int n = this.header.width;
        int n2 = this.header.height;
        Rectangle rectangle = IFFImageReader.getSourceRegion((ImageReadParam)imageReadParam, (int)n, (int)n2);
        Point point = imageReadParam == null ? new Point(0, 0) : imageReadParam.getDestinationOffset();
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)(this.header.bitplanes / 8), (int)this.image.getSampleModel().getNumBands());
        int n5 = 2 * ((n + 15) / 16);
        byte[] byArray = new byte[8 * n5];
        WritableRaster writableRaster = this.image.getRaster();
        if (nArray2 != null || point.x != 0 || point.y != 0) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), point.x, point.y, nArray2);
        }
        WritableRaster writableRaster2 = this.image.getRaster().createCompatibleWritableRaster(8 * n5, 1);
        Raster raster = writableRaster2.createChild(rectangle.x, 0, rectangle.width, 1, 0, 0, nArray);
        byte[] byArray2 = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
        int n6 = (this.header.bitplanes + 7) / 8;
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n6; ++n9) {
                for (n8 = 0; n8 < 8; ++n8) {
                    this.readPlaneData(imageInputStream, byArray, n8 * n5, n5);
                }
                if (i >= rectangle.y + rectangle.height) {
                    return;
                }
                if (i < rectangle.y || (i - rectangle.y) % n4 != 0) continue;
                if (this.formType == 1229734477) {
                    n8 = n6 - n9 - 1;
                    n7 = 0;
                    for (int j = 0; j < n5; ++j) {
                        IFFUtil.bitRotateCW(byArray, j, n5, byArray2, n8 + n7 * n6, n6);
                        n7 += 8;
                    }
                    continue;
                }
                if (this.formType == 1346522400) {
                    System.arraycopy(byArray, 0, byArray2, i * 8 * n5, n5);
                    continue;
                }
                throw new AssertionError((Object)String.format("Unsupported FORM type: %s", this.formType));
            }
            if (i >= rectangle.y && (i - rectangle.y) % n4 == 0) {
                n9 = (i - rectangle.y) / n4;
                if (n3 == 1) {
                    writableRaster.setRect(0, n9, raster);
                } else {
                    for (n8 = 0; n8 < raster.getWidth(); n8 += n3) {
                        object = raster.getDataElements(n8, 0, object);
                        n7 = n8 / n3;
                        writableRaster.setDataElements(n7, n9, object);
                    }
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)this.header.width);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readPlaneData(ImageInputStream imageInputStream, byte[] byArray, int n, int n2) throws IOException {
        switch (this.header.compressionType) {
            case 0: {
                imageInputStream.readFully(byArray, n, n2);
                if (this.header.bitplanes * n2 % 2 == 0) break;
                imageInputStream.readByte();
                break;
            }
            case 1: {
                if (this.byteRunStream == null) {
                    this.byteRunStream = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)imageInputStream, (long)this.body.chunkLength), (Decoder)new PackBitsDecoder(true), n2 * this.header.bitplanes));
                }
                this.byteRunStream.readFully(byArray, n, n2);
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown compression type: %d", this.header.compressionType));
            }
        }
    }

    private void multiPaletteToRGB(int n, byte[] byArray, IndexColorModel indexColorModel, byte[] byArray2, int n2) {
        int n3 = this.header.width;
        ColorModel colorModel = this.paletteChange.getColorModel(indexColorModel, n, this.isLaced());
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = colorModel.getRGB(n4);
            int n6 = i * 3 + n2;
            byArray2[2 + n6] = (byte)(n5 >> 16 & 0xFF);
            byArray2[1 + n6] = (byte)(n5 >> 8 & 0xFF);
            byArray2[n6] = (byte)(n5 & 0xFF);
        }
    }

    private void hamToRGB(byte[] byArray, IndexColorModel indexColorModel, byte[] byArray2, int n) {
        int n2 = this.header.bitplanes;
        int n3 = this.header.width;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = byArray[i] & 0xFF;
            int n8 = n2 == 6 ? n7 & 0xF : n7 & 0x3F;
            int n9 = n2 == 6 ? 4 : 2;
            int n10 = n2 == 6 ? 15 : 3;
            switch (n7 >> 8 - n9 & 3) {
                case 0: {
                    n4 = indexColorModel.getRed(n8);
                    n5 = indexColorModel.getGreen(n8);
                    n6 = indexColorModel.getBlue(n8);
                    break;
                }
                case 1: {
                    n6 = n6 & n10 | n8 << n9;
                    break;
                }
                case 2: {
                    n4 = n4 & n10 | n8 << n9;
                    break;
                }
                case 3: {
                    n5 = n5 & n10 | n8 << n9;
                }
            }
            int n11 = i * 3 + n;
            byArray2[2 + n11] = (byte)n4;
            byArray2[1 + n11] = (byte)n5;
            byArray2[n11] = (byte)n6;
        }
    }

    private boolean isSHAM() {
        return false;
    }

    private boolean isPCHG() {
        return this.paletteChange != null;
    }

    private boolean isEHB() {
        return this.viewPort != null && this.viewPort.isEHB();
    }

    private boolean isHAM() {
        return this.viewPort != null && this.viewPort.isHAM();
    }

    public boolean isLaced() {
        return this.viewPort != null && this.viewPort.isLaced();
    }

    public static void main(String[] stringArray) throws IOException {
        IFFImageReader iFFImageReader = new IFFImageReader();
        boolean bl = false;
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                bl = true;
                continue;
            }
            File file = new File(string);
            if (!file.isFile()) continue;
            try {
                BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream(ImageIO.createImageInputStream(file));
                boolean bl2 = ((ImageReader)((Object)iFFImageReader)).getOriginatingProvider().canDecodeInput(bufferedImageInputStream);
                if (bl2) {
                    ((ImageReader)((Object)iFFImageReader)).setInput(bufferedImageInputStream);
                    ImageReadParam imageReadParam = ((ImageReader)((Object)iFFImageReader)).getDefaultReadParam();
                    BufferedImage bufferedImage = ((ImageReader)((Object)iFFImageReader)).read(0, imageReadParam);
                    System.out.println("image = " + bufferedImage);
                    if (bl) {
                        bufferedImage = new ResampleOp(bufferedImage.getWidth() / 2, bufferedImage.getHeight(), 13).filter(bufferedImage, null);
                    }
                    IFFImageReader.showIt((BufferedImage)bufferedImage, (String)string);
                    continue;
                }
                System.err.println("Foo!");
            }
            catch (IOException iOException) {
                System.err.println("Error reading file: " + file);
                iOException.printStackTrace();
            }
        }
    }
}

