/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.Form;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;

final class CMAPChunk
extends IFFChunk {
    byte[] reds;
    byte[] greens;
    byte[] blues;
    private IndexColorModel model;

    CMAPChunk(int n) {
        super(1129136464, n);
    }

    public CMAPChunk(IndexColorModel indexColorModel) {
        super(1129136464, indexColorModel.getMapSize() * 3);
        this.model = indexColorModel;
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        int n = this.chunkLength / 3;
        this.reds = new byte[n];
        this.greens = (byte[])this.reds.clone();
        this.blues = (byte[])this.reds.clone();
        for (int i = 0; i < n; ++i) {
            this.reds[i] = dataInput.readByte();
            this.greens[i] = dataInput.readByte();
            this.blues[i] = dataInput.readByte();
        }
        if (this.chunkLength % 2 != 0) {
            dataInput.readByte();
        }
    }

    @Override
    void writeChunk(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.chunkId);
        dataOutput.writeInt(this.chunkLength);
        int n = this.model.getMapSize();
        for (int i = 0; i < n; ++i) {
            dataOutput.writeByte(this.model.getRed(i));
            dataOutput.writeByte(this.model.getGreen(i));
            dataOutput.writeByte(this.model.getBlue(i));
        }
        if (this.chunkLength % 2 != 0) {
            dataOutput.writeByte(0);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " {colorMap=" + this.model + "}";
    }

    public IndexColorModel getIndexColorModel(Form.ILBMForm iLBMForm) throws IIOException {
        if (this.model == null) {
            int n;
            int n2 = this.reds.length;
            if (iLBMForm.isEHB()) {
                if (n2 == 32) {
                    this.reds = Arrays.copyOf(this.reds, n2 * 2);
                    this.blues = Arrays.copyOf(this.blues, n2 * 2);
                    this.greens = Arrays.copyOf(this.greens, n2 * 2);
                } else if (n2 != 64) {
                    throw new IIOException("Unknown number of colors for EHB: " + n2);
                }
                for (n = 0; n < 32; ++n) {
                    this.reds[n + 32] = (byte)((this.reds[n] & 0xFF) / 2);
                    this.greens[n + 32] = (byte)((this.greens[n] & 0xFF) / 2);
                    this.blues[n + 32] = (byte)((this.blues[n] & 0xFF) / 2);
                }
            }
            n = iLBMForm.transparentIndex();
            int n3 = iLBMForm.bitplanes() == 25 ? 8 : iLBMForm.bitplanes();
            this.model = new IndexColorModel(n3, this.reds.length, this.reds, this.greens, this.blues, n);
        }
        return this.model;
    }
}

