/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageWriterSpi;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.plugins.iff.IFFWriteParam;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public final class IFFImageWriter
extends ImageWriterBase {
    IFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method getDefaultImageMetadata not implemented");
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method convertImageMetadata not implemented");
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new IFFWriteParam(this.getLocale());
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write raster");
        }
        this.processImageStarted(0);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        boolean bl = this.shouldCompress(renderedImage, imageWriteParam);
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(1024);
        this.packImageData((OutputStream)fastByteArrayOutputStream, renderedImage, bl);
        this.writeMeta(renderedImage, fastByteArrayOutputStream.size(), bl);
        this.writeBody((ByteArrayOutputStream)fastByteArrayOutputStream);
        this.processImageComplete();
    }

    private void writeBody(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        this.imageOutput.writeInt(1112491097);
        this.imageOutput.writeInt(byteArrayOutputStream.size());
        try (OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);){
            byteArrayOutputStream.writeTo(outputStream);
        }
        if (byteArrayOutputStream.size() % 2 == 0) {
            this.imageOutput.writeByte(0);
        }
        this.imageOutput.flush();
    }

    private void packImageData(OutputStream outputStream, RenderedImage renderedImage, boolean bl) throws IOException {
        OutputStream outputStream2 = bl ? new EncoderStream(outputStream, (Encoder)new PackBitsEncoder(), true) : outputStream;
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = renderedImage.getData();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        int n3 = 2 * ((n + 15) / 16);
        byte[] byArray = new byte[8 * n3];
        int n4 = (colorModel.getPixelSize() + 7) / 8;
        int n5 = n4 == 1 ? colorModel.getPixelSize() : 8;
        int[] nArray = new int[8 * n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6;
                nArray = raster.getSamples(0, i, n, 1, j, nArray);
                int n7 = 0;
                int n8 = 0;
                for (n6 = 0; n6 < n3; ++n6) {
                    IFFUtil.bitRotateCCW(nArray, n7, 1, byArray, n8, n3);
                    n7 += 8;
                    ++n8;
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    outputStream2.write(byArray, n6 * n3, n3);
                }
            }
            outputStream2.flush();
            this.processImageProgress((float)i * 100.0f / (float)n2);
        }
        outputStream2.flush();
    }

    private void writeMeta(RenderedImage renderedImage, int n, boolean bl) throws IOException {
        BMHDChunk bMHDChunk;
        int n2;
        int n3;
        String string = String.format("Written by %s IFFImageWriter %s", this.getOriginatingProvider().getVendorName(), this.getOriginatingProvider().getVersion());
        GenericChunk genericChunk = new GenericChunk(IFFUtil.toInt("ANNO".getBytes()), string.getBytes());
        ColorModel colorModel = renderedImage.getColorModel();
        IndexColorModel indexColorModel = null;
        int n4 = n3 = bl ? 1 : 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            int n5 = indexColorModel.getTransparency() == 2 ? 2 : 0;
            n2 = indexColorModel.getTransparency() == 2 ? indexColorModel.getTransparentPixel() : 0;
            bMHDChunk = new BMHDChunk(renderedImage.getWidth(), renderedImage.getHeight(), indexColorModel.getPixelSize(), n5, n3, n2);
        } else {
            bMHDChunk = new BMHDChunk(renderedImage.getWidth(), renderedImage.getHeight(), colorModel.getPixelSize(), 0, n3, 0);
        }
        CMAPChunk cMAPChunk = null;
        if (indexColorModel != null) {
            cMAPChunk = new CMAPChunk(indexColorModel);
        }
        n2 = 12 + genericChunk.chunkLength + 28 + 8 + n;
        if (cMAPChunk != null) {
            n2 += 8 + cMAPChunk.chunkLength;
        }
        this.imageOutput.writeInt(1179603533);
        this.imageOutput.writeInt(n2);
        this.imageOutput.writeInt(1229734477);
        genericChunk.writeChunk(this.imageOutput);
        bMHDChunk.writeChunk(this.imageOutput);
        if (cMAPChunk != null) {
            cMAPChunk.writeChunk(this.imageOutput);
        }
    }

    private boolean shouldCompress(RenderedImage renderedImage, ImageWriteParam imageWriteParam) {
        if (imageWriteParam != null && imageWriteParam.canWriteCompressed()) {
            switch (imageWriteParam.getCompressionMode()) {
                case 0: {
                    return false;
                }
                case 2: {
                    return IFFWriteParam.COMPRESSION_TYPES[1].equals(imageWriteParam.getCompressionType());
                }
            }
        }
        return renderedImage.getWidth() >= 32;
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        IFFImageWriter iFFImageWriter = new IFFImageWriter((ImageWriterSpi)((Object)new IFFImageWriterSpi()));
        ((ImageWriter)((Object)iFFImageWriter)).setOutput(ImageIO.createImageOutputStream(new File(stringArray[1])));
        ((ImageWriter)((Object)iFFImageWriter)).write(bufferedImage);
    }
}

