/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.plugins.dds.DDSType;
import java.util.Arrays;
import java.util.function.IntPredicate;

public enum DX10DXGIFormat {
    BC1(DDSType.DXT1, DX10DXGIFormat.rangeInclusive(70, 72)),
    BC2(DDSType.DXT2, DX10DXGIFormat.rangeInclusive(73, 75)),
    BC3(DDSType.DXT5, DX10DXGIFormat.rangeInclusive(76, 78)),
    B8G8R8A8(DDSType.A8B8G8R8, DX10DXGIFormat.exactly(87, 90, 91)),
    B8G8R8X8(DDSType.X8B8G8R8, DX10DXGIFormat.exactly(88, 92, 93)),
    R8G8B8A8(DDSType.A8R8G8B8, DX10DXGIFormat.rangeInclusive(27, 32));

    private final DDSType ddsType;
    private final IntPredicate dxgiFormat;

    private DX10DXGIFormat(DDSType dDSType, IntPredicate intPredicate) {
        this.ddsType = dDSType;
        this.dxgiFormat = intPredicate;
    }

    DDSType getCorrespondingType() {
        return this.ddsType;
    }

    static DX10DXGIFormat getFormat(int n) {
        for (DX10DXGIFormat dX10DXGIFormat : DX10DXGIFormat.values()) {
            if (!dX10DXGIFormat.dxgiFormat.test(n)) continue;
            return dX10DXGIFormat;
        }
        throw new IllegalArgumentException("Unsupported DXGI_FORMAT : " + n);
    }

    private static IntPredicate exactly(int ... nArray) {
        return n -> Arrays.binarySearch(nArray, n) >= 0;
    }

    private static IntPredicate rangeInclusive(int n, int n2) {
        return n3 -> n <= n3 && n3 <= n2;
    }
}

