/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.stream.BufferedChannelImageInputStream;
import com.twelvemonkeys.imageio.stream.DiskCache;
import com.twelvemonkeys.imageio.stream.MemoryCache;
import com.twelvemonkeys.imageio.stream.StreamProviderInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;

public final class URLImageInputStreamSpi
extends ImageInputStreamSpi {
    public URLImageInputStreamSpi() {
        this(new StreamProviderInfo());
    }

    private URLImageInputStreamSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), URL.class);
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object object, boolean bl, File file) throws IOException {
        if (object instanceof URL) {
            URL uRL = (URL)object;
            if ("file".equals(uRL.getProtocol())) {
                try {
                    return new BufferedChannelImageInputStream(new File(uRL.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            }
            InputStream inputStream = uRL.openStream();
            return new BufferedChannelImageInputStream(bl ? new DiskCache(inputStream, file) : new MemoryCache(inputStream));
        }
        throw new IllegalArgumentException("Expected input of type URL: " + object);
    }

    @Override
    public boolean canUseCacheFile() {
        return true;
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider that instantiates an ImageInputStream from a URL";
    }
}

