/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.imageio.path.AdobePathSegment;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.lang.Validate;
import java.awt.geom.Path2D;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;

public final class AdobePathReader {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.path.debug"));
    private final DataInput data;

    public AdobePathReader(DataInput dataInput) {
        Validate.notNull((Object)dataInput, (String)"data");
        this.data = dataInput;
    }

    public AdobePathReader(byte[] byArray) {
        this((DataInput)new ByteArrayImageInputStream((byte[])Validate.notNull((Object)byArray, (String)"data"), 0, ((Integer)Validate.isTrue((byArray.length > 0 && byArray.length % 26 == 0 ? 1 : 0) != 0, (Object)byArray.length, (String)"data.length must be a multiple of 26: %d")).intValue()));
    }

    public Path2D readPath() throws IOException {
        AdobePathSegment adobePathSegment;
        ArrayList<List<AdobePathSegment>> arrayList = new ArrayList<List<AdobePathSegment>>();
        ArrayList<AdobePathSegment> arrayList2 = null;
        int n = 0;
        while ((adobePathSegment = this.nextSegment()) != null) {
            if (DEBUG) {
                System.out.println(adobePathSegment);
            }
            if (adobePathSegment.selector == 3 || adobePathSegment.selector == 0) {
                if (arrayList2 != null) {
                    if (n != arrayList2.size()) {
                        throw new IIOException(String.format("Bad path, expected %d segments, found only %d", n, arrayList2.size()));
                    }
                    arrayList.add(arrayList2);
                }
                arrayList2 = new ArrayList<AdobePathSegment>(adobePathSegment.lengthOrRule);
                n = adobePathSegment.lengthOrRule;
                continue;
            }
            if (adobePathSegment.selector != 4 && adobePathSegment.selector != 5 && adobePathSegment.selector != 1 && adobePathSegment.selector != 2) continue;
            if (arrayList2 == null) {
                throw new IIOException("Bad path, missing subpath length record");
            }
            if (arrayList2.size() >= n) {
                throw new IIOException(String.format("Bad path, expected %d segments, found%d", n, arrayList2.size()));
            }
            arrayList2.add(adobePathSegment);
        }
        if (arrayList2 != null) {
            if (n != arrayList2.size()) {
                throw new IIOException(String.format("Bad path, expected %d segments, found only %d", n, arrayList2.size()));
            }
            arrayList.add((List<AdobePathSegment>)arrayList2);
        }
        return this.pathToShape(arrayList);
    }

    private Path2D pathToShape(List<List<AdobePathSegment>> list) {
        Path2D.Float float_ = new Path2D.Float(0, list.size());
        Path2D.Float float_2 = null;
        for (List<AdobePathSegment> list2 : list) {
            int n = list2.size();
            block6: for (int i = 0; i < list2.size(); ++i) {
                AdobePathSegment adobePathSegment = list2.get(i);
                int n2 = i == 0 ? 0 : (i == n - 1 ? 2 : 1);
                switch (n2) {
                    case 0: {
                        AdobePathSegment adobePathSegment2;
                        float_2 = new Path2D.Float(0, n);
                        ((Path2D)float_2).moveTo(adobePathSegment.apx, adobePathSegment.apy);
                        if (n > 1) {
                            adobePathSegment2 = list2.get(i + 1);
                            ((Path2D)float_2).curveTo(adobePathSegment.cplx, adobePathSegment.cply, adobePathSegment2.cppx, adobePathSegment2.cppy, adobePathSegment2.apx, adobePathSegment2.apy);
                            continue block6;
                        }
                        ((Path2D)float_2).lineTo(adobePathSegment.apx, adobePathSegment.apy);
                        continue block6;
                    }
                    case 1: {
                        AdobePathSegment adobePathSegment2 = list2.get(i + 1);
                        ((Path2D)float_2).curveTo(adobePathSegment.cplx, adobePathSegment.cply, adobePathSegment2.cppx, adobePathSegment2.cppy, adobePathSegment2.apx, adobePathSegment2.apy);
                        continue block6;
                    }
                    case 2: {
                        AdobePathSegment adobePathSegment2 = list2.get(0);
                        if (adobePathSegment2.selector == 1 || adobePathSegment2.selector == 2) {
                            ((Path2D)float_2).curveTo(adobePathSegment.cplx, adobePathSegment.cply, adobePathSegment2.cppx, adobePathSegment2.cppy, adobePathSegment2.apx, adobePathSegment2.apy);
                            float_2.closePath();
                            float_.append(float_2, false);
                            continue block6;
                        }
                        ((Path2D)float_2).lineTo(adobePathSegment.apx, adobePathSegment.apy);
                        float_.append(float_2, true);
                        continue block6;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        return float_;
    }

    private AdobePathSegment nextSegment() throws IOException {
        int n;
        try {
            n = this.data.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            return null;
        }
        switch (n) {
            case 0: 
            case 3: 
            case 6: 
            case 8: {
                int n2 = this.data.readUnsignedShort();
                this.data.skipBytes(22);
                return new AdobePathSegment(n, n2);
            }
        }
        return new AdobePathSegment(n, AdobePathSegment.fromFixedPoint(this.data.readInt()), AdobePathSegment.fromFixedPoint(this.data.readInt()), AdobePathSegment.fromFixedPoint(this.data.readInt()), AdobePathSegment.fromFixedPoint(this.data.readInt()), AdobePathSegment.fromFixedPoint(this.data.readInt()), AdobePathSegment.fromFixedPoint(this.data.readInt()));
    }
}

