/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegmentUtil;
import com.twelvemonkeys.imageio.metadata.psd.PSDReader;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFReader;
import com.twelvemonkeys.imageio.path.AdobePathReader;
import com.twelvemonkeys.imageio.path.AdobePathWriter;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.Validate;
import java.awt.AlphaComposite;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class Paths {
    private Paths() {
    }

    public static Path2D readPath(ImageInputStream imageInputStream) throws IOException {
        CompoundDirectory compoundDirectory;
        Directory directory;
        Entry entry;
        Validate.notNull((Object)imageInputStream, (String)"stream");
        int n = Paths.readMagic(imageInputStream);
        if (n == 943868237) {
            return Paths.readPathFromPhotoshopResources(imageInputStream);
        }
        if (n == 943870035) {
            imageInputStream.skipBytes(26);
            long l = imageInputStream.readUnsignedInt();
            imageInputStream.skipBytes(l);
            long l2 = imageInputStream.readUnsignedInt();
            return Paths.readPathFromPhotoshopResources((ImageInputStream)new SubImageInputStream(imageInputStream, l2));
        }
        if (n >>> 16 == 65496 && (n & 0xFF00) == 65280) {
            Map<Integer, List<String>> map = Collections.singletonMap(65517, Collections.singletonList("Photoshop 3.0"));
            List list = JPEGSegmentUtil.readSegments((ImageInputStream)imageInputStream, map);
            if (!list.isEmpty()) {
                return Paths.readPathFromPhotoshopResources(new MemoryCacheImageInputStream(((JPEGSegment)list.get(0)).data()));
            }
        } else if ((n >>> 16 == 19789 && (n & 0xFFFF) == 42 || n >>> 16 == 18761 && (n & 0xFFFF) == 10752) && (entry = (directory = (compoundDirectory = (CompoundDirectory)new TIFFReader().read(imageInputStream)).getDirectory(0)).getEntryById((Object)34377)) != null) {
            return Paths.readPathFromPhotoshopResources((ImageInputStream)new ByteArrayImageInputStream((byte[])entry.getValue()));
        }
        return null;
    }

    private static int readMagic(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        try {
            int n = imageInputStream.readInt();
            return n;
        }
        finally {
            imageInputStream.reset();
        }
    }

    private static Path2D readPathFromPhotoshopResources(ImageInputStream imageInputStream) throws IOException {
        Entry entry;
        Directory directory = new PSDReader().read(imageInputStream);
        if (AdobePathReader.DEBUG) {
            System.out.println("resourceBlocks: " + directory);
        }
        if ((entry = directory.getEntryById((Object)2000)) != null) {
            return new AdobePathReader((byte[])entry.getValue()).readPath();
        }
        return null;
    }

    public static BufferedImage applyClippingPath(Shape shape, BufferedImage bufferedImage) {
        return Paths.applyClippingPath(shape, (BufferedImage)Validate.notNull((Object)bufferedImage, (String)"image"), new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage applyClippingPath(Shape shape, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Validate.notNull((Object)shape, (String)"clip");
        Validate.notNull((Object)bufferedImage, (String)"image");
        Validate.isTrue((bufferedImage2 != null && bufferedImage2 != bufferedImage ? 1 : 0) != 0, (String)"destination may not be null or same instance as image");
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(shape);
            graphics2D.setTransform(affineTransform);
            graphics2D.setComposite(AlphaComposite.SrcIn);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage readClipped(ImageInputStream imageInputStream) throws IOException {
        Path2D path2D = Paths.readPath(imageInputStream);
        imageInputStream.seek(0L);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        if (path2D == null) {
            return bufferedImage;
        }
        return Paths.applyClippingPath(path2D, bufferedImage);
    }

    public static boolean writeClipped(RenderedImage renderedImage, Shape shape, String string, ImageOutputStream imageOutputStream) throws IOException {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (imageOutputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, string);
        if (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            byte[] byArray = new AdobePathWriter(shape).writePathResource(2000);
            if (list.contains("javax_imageio_tiff_image_1.0") || list.contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionType("Deflate");
                String string2 = list.contains("javax_imageio_tiff_image_1.0") ? "javax_imageio_tiff_image_1.0" : "com_sun_media_imageio_plugins_tiff_image_1.0";
                IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(string2);
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFFIFD");
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("TIFFField");
                iIOMetadataNode3.setAttribute("number", String.valueOf(34377));
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("TIFFUndefined");
                iIOMetadataNode4.setAttribute("value", Paths.arrayAsString(byArray));
                iIOMetadataNode3.appendChild(iIOMetadataNode4);
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                iIOMetadata.mergeTree(string2, iIOMetadataNode);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(renderedImage, null, iIOMetadata), imageWriteParam);
                return true;
            }
            if (list.contains("javax_imageio_jpeg_image_1.0")) {
                String string3 = "javax_imageio_jpeg_image_1.0";
                IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(string3);
                iIOMetadataNode.appendChild(new IIOMetadataNode("JPEGvariety"));
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("markerSequence");
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("unknown");
                iIOMetadataNode6.setAttribute("MarkerTag", Integer.toString(237));
                byte[] byArray2 = "Photoshop 3.0".getBytes(StandardCharsets.US_ASCII);
                byte[] byArray3 = new byte[byArray2.length + 1 + byArray.length];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
                iIOMetadataNode6.setUserObject(byArray3);
                iIOMetadataNode5.appendChild(iIOMetadataNode6);
                iIOMetadataNode.appendChild(iIOMetadataNode5);
                iIOMetadata.mergeTree(string3, iIOMetadataNode);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(renderedImage, null, iIOMetadata), imageWriteParam);
                return true;
            }
        }
        return false;
    }

    private static String arrayAsString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            stringBuilder.append(byArray[n]);
            if (n == byArray.length - 1) {
                return stringBuilder.toString();
            }
            stringBuilder.append(",");
            ++n;
        }
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        Object object;
        BufferedImage bufferedImage;
        if (stringArray.length == 1) {
            bufferedImage = Paths.readClipped(ImageIO.createImageInputStream(new File(stringArray[0])));
        } else {
            object = ImageIO.createImageInputStream(new File(stringArray[1]));
            Throwable throwable = null;
            try {
                bufferedImage = Paths.applyClippingPath(Paths.readPath((ImageInputStream)object), ImageIO.read(new File(stringArray[0])));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        object = File.createTempFile("clipped-", ".png");
        ((File)object).deleteOnExit();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", (File)object);
        Desktop.getDesktop().open((File)object);
        Thread.sleep(3000L);
        if (!((File)object).delete()) {
            System.err.printf("%s not deleted\n", object);
        }
    }
}

